/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Manager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Expression;
import org.eclipse.cdt.debug.mi.core.cdi.model.LocalVariable;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIVarCreate;
import org.eclipse.cdt.debug.mi.core.command.MIVarDelete;
import org.eclipse.cdt.debug.mi.core.command.MIVarUpdate;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarDeletedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarChange;
import org.eclipse.cdt.debug.mi.core.output.MIVarCreateInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVarUpdateInfo;

public class ExpressionManager
extends Manager {
    static final ICDIExpression[] EMPTY_EXPRESSIONS = new ICDIExpression[0];
    Map expMap;
    Map varMap;
    MIVarChange[] noChanges = new MIVarChange[0];

    public ExpressionManager(Session session) {
        super(session, true);
        this.expMap = new Hashtable();
        this.varMap = new Hashtable();
    }

    synchronized List getExpressionList(Target target) {
        List expList = (List)this.expMap.get(target);
        if (expList == null) {
            expList = Collections.synchronizedList(new ArrayList());
            this.expMap.put(target, expList);
        }
        return expList;
    }

    synchronized List getVariableList(Target target) {
        List varList = (List)this.varMap.get(target);
        if (varList == null) {
            varList = Collections.synchronizedList(new ArrayList());
            this.varMap.put(target, varList);
        }
        return varList;
    }

    public ICDIExpression createExpression(Target target, String name) throws CDIException {
        Expression expression = new Expression(target, name);
        List exprList = this.getExpressionList(target);
        exprList.add(expression);
        return expression;
    }

    public ICDIExpression[] getExpressions(Target target) throws CDIException {
        List expList = (List)this.expMap.get(target);
        if (expList != null) {
            return expList.toArray(EMPTY_EXPRESSIONS);
        }
        return EMPTY_EXPRESSIONS;
    }

    public void destroyExpressions(Target target, ICDIExpression[] expressions) throws CDIException {
        List expList = this.getExpressionList(target);
        int i = 0;
        while (i < expressions.length) {
            expList.remove(expressions[i]);
            ++i;
        }
    }

    public void destroyAllExpressions(Target target) throws CDIException {
        ICDIExpression[] expressions = this.getExpressions(target);
        this.destroyExpressions(target, expressions);
    }

    public void update(Target target) throws CDIException {
        ArrayList<MIEvent> eventList = new ArrayList<MIEvent>();
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        List varList = this.getVariableList(target);
        Variable[] variables = varList.toArray(new Variable[varList.size()]);
        int i = 0;
        while (i < variables.length) {
            Variable variable = variables[i];
            String varName = variable.getMIVar().getVarName();
            MIVarChange[] changes = this.noChanges;
            MIVarUpdate update = factory.createMIVarUpdate(varName);
            MIVarUpdateInfo info = null;
            try {
                mi.postCommand(update);
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            boolean timedout = false;
            try {
                info = update.getMIVarUpdateInfo();
                if (info == null) {
                    timedout = true;
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                changes = info.getMIVarChanges();
            }
            catch (MIException e) {
                if (timedout) {
                    throw new MI2CDIException(e);
                }
                eventList.add(new MIVarDeletedEvent(mi, varName));
            }
            int j = 0;
            while (j < changes.length) {
                String n = changes[j].getVarName();
                if (changes[j].isInScope()) {
                    eventList.add(new MIVarChangedEvent(mi, n));
                } else {
                    this.deleteVariable(variable);
                    eventList.add(new MIVarDeletedEvent(mi, n));
                }
                ++j;
            }
            ++i;
        }
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        mi.fireEvents(events);
    }

    public Variable getVariable(MISession miSession, String varName) {
        Session session = (Session)this.getSession();
        Target target = session.getTarget(miSession);
        List varList = this.getVariableList(target);
        Variable[] vars = varList.toArray(new Variable[0]);
        int i = 0;
        while (i < vars.length) {
            try {
                if (vars[i].getMIVar().getVarName().equals(varName)) {
                    return vars[i];
                }
                Variable v = vars[i].getChild(varName);
                if (v != null) {
                    return v;
                }
            }
            catch (CDIException cDIException) {}
            ++i;
        }
        return null;
    }

    public Variable createVariable(StackFrame frame, String code) throws CDIException {
        LocalVariable localVariable;
        Target target = (Target)frame.getTarget();
        Thread currentThread = (Thread)target.getCurrentThread();
        StackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.lockTarget();
        try {
            target.setCurrentThread(frame.getThread(), false);
            ((Thread)frame.getThread()).setCurrentStackFrame(frame, false);
            MISession mi = target.getMISession();
            CommandFactory factory = mi.getCommandFactory();
            MIVarCreate var = factory.createMIVarCreate(code);
            mi.postCommand(var);
            MIVarCreateInfo info = var.getMIVarCreateInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            LocalVariable variable = new LocalVariable(target, null, frame, code, null, 0, 0, info.getMIVar());
            List varList = this.getVariableList(target);
            varList.add(variable);
            localVariable = variable;
            Object var12_14 = null;
        }
        catch (MIException e) {
            try {
                throw new MI2CDIException(e);
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                target.setCurrentThread(currentThread, false);
                currentThread.setCurrentStackFrame(currentFrame, false);
                target.releaseTarget();
                throw throwable;
            }
        }
        target.setCurrentThread(currentThread, false);
        currentThread.setCurrentStackFrame(currentFrame, false);
        target.releaseTarget();
        return localVariable;
    }

    public Variable removeVariableFromList(MISession miSession, String varName) {
        Variable var = this.getVariable(miSession, varName);
        if (var != null) {
            Target target = ((Session)this.getSession()).getTarget(miSession);
            List varList = this.getVariableList(target);
            varList.remove(var);
            return var;
        }
        return null;
    }

    public void deleteAllVariables(Target target) throws CDIException {
        List varList = this.getVariableList(target);
        Variable[] variables = varList.toArray(new Variable[varList.size()]);
        int i = 0;
        while (i < variables.length) {
            this.deleteVariable(variables[i]);
            ++i;
        }
    }

    public void deleteVariable(Variable variable) throws CDIException {
        Target target = (Target)variable.getTarget();
        MISession miSession = target.getMISession();
        MIVar miVar = variable.getMIVar();
        CommandFactory factory = miSession.getCommandFactory();
        MIVarDelete var = factory.createMIVarDelete(miVar.getVarName());
        try {
            miSession.postCommand(var);
            var.getMIInfo();
        }
        catch (MIException mIException) {}
        List varList = this.getVariableList(target);
        varList.remove(variable);
        ICDIVariable[] children = variable.children;
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                if (children[0] instanceof Variable) {
                    Variable child = (Variable)children[i];
                    MIVarDeletedEvent event = new MIVarDeletedEvent(miSession, child.getMIVar().getVarName());
                    miSession.fireEvent(event);
                }
                ++i;
            }
        }
        miSession.fireEvent(new MIVarDeletedEvent(miSession, variable.getMIVar().getVarName()));
    }
}

