/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SourceManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.IncompleteType;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataEvaluateExpression;
import org.eclipse.cdt.debug.mi.core.output.MIDataEvaluateExpressionInfo;

public abstract class VariableDescriptor
extends CObject
implements ICDIVariableDescriptor {
    String[] castingTypes;
    int castingIndex;
    int castingLength;
    String fName;
    int position;
    StackFrame fStackFrame;
    Thread fThread;
    int stackdepth;
    String qualifiedName = null;
    String fFullName = null;
    protected ICDIType fType = null;
    protected String fTypename = null;
    String sizeof = null;

    public VariableDescriptor(VariableDescriptor desc) {
        super((Target)desc.getTarget());
        this.fName = desc.getName();
        this.fFullName = desc.fFullName;
        this.sizeof = desc.sizeof;
        this.fType = desc.fType;
        try {
            this.fStackFrame = (StackFrame)desc.getStackFrame();
            this.fThread = (Thread)desc.getThread();
        }
        catch (CDIException cDIException) {}
        this.position = desc.getPosition();
        this.stackdepth = desc.getStackDepth();
        this.castingIndex = desc.getCastingArrayStart();
        this.castingLength = desc.getCastingArrayEnd();
        this.castingTypes = desc.getCastingTypes();
    }

    public VariableDescriptor(Target target, Thread thread, StackFrame stack, String n, String fn, int pos, int depth) {
        super(target);
        this.fName = n;
        this.fFullName = fn;
        this.fStackFrame = stack;
        this.fThread = thread;
        this.position = pos;
        this.stackdepth = depth;
    }

    public int getPosition() {
        return this.position;
    }

    public int getStackDepth() {
        return this.stackdepth;
    }

    public void setCastingArrayStart(int start) {
        this.castingIndex = start;
    }

    public int getCastingArrayStart() {
        return this.castingIndex;
    }

    public void setCastingArrayEnd(int end) {
        this.castingLength = end;
    }

    public int getCastingArrayEnd() {
        return this.castingLength;
    }

    public void setCastingTypes(String[] t) {
        this.castingTypes = t;
    }

    public String[] getCastingTypes() {
        return this.castingTypes;
    }

    public String encodeVariable() {
        String fn = this.getFullName();
        if (this.castingLength > 0 || this.castingIndex > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("*(");
            buffer.append('(').append(fn).append(')');
            buffer.append('+').append(this.castingIndex).append(')');
            buffer.append('@').append(this.castingLength);
            fn = buffer.toString();
        } else if (this.castingTypes != null && this.castingTypes.length > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < this.castingTypes.length) {
                if (this.castingTypes[i] != null && this.castingTypes[i].length() > 0) {
                    if (buffer.length() == 0) {
                        buffer.append('(').append(this.castingTypes[i]).append(')');
                        buffer.append(fn);
                    } else {
                        buffer.insert(0, '(');
                        buffer.append(')');
                        StringBuffer b = new StringBuffer();
                        b.append('(').append(this.castingTypes[i]).append(')');
                        buffer.insert(0, b.toString());
                    }
                }
                ++i;
            }
            fn = buffer.toString();
        }
        return fn;
    }

    public String getFullName() {
        if (this.fFullName == null) {
            this.fFullName = this.getName();
        }
        return this.fFullName;
    }

    protected ICDIType getFromTypeCache(String nameType) throws CDIException {
        StackFrame frame = (StackFrame)this.getStackFrame();
        ICDIType detailedType = null;
        if (frame != null) {
            detailedType = frame.getFromTypeCache(nameType);
        }
        return detailedType;
    }

    protected void addToTypeCache(String nameType, ICDIType typeDefinition) throws CDIException {
        StackFrame frame = (StackFrame)this.getStackFrame();
        if (frame != null) {
            frame.addToTypeCache(nameType, typeDefinition);
        }
    }

    public String getName() {
        return this.fName;
    }

    public ICDIType getType() throws CDIException {
        if (this.fType == null) {
            Target target;
            String nametype;
            block9: {
                nametype = this.getTypeName();
                target = (Target)this.getTarget();
                Session session = (Session)target.getSession();
                SourceManager sourceMgr = session.getSourceManager();
                try {
                    this.fType = sourceMgr.getType(target, nametype);
                }
                catch (CDIException cDIException) {
                    this.fType = this.getFromTypeCache(nametype);
                    if (this.fType != null) break block9;
                    try {
                        String ptype = sourceMgr.getDetailTypeName(target, nametype);
                        this.fType = sourceMgr.getType(target, ptype);
                    }
                    catch (CDIException cDIException2) {
                        StackFrame frame = (StackFrame)this.getStackFrame();
                        if (frame == null) {
                            Thread thread = (Thread)this.getThread();
                            frame = thread != null ? thread.getCurrentStackFrame() : ((Thread)target.getCurrentThread()).getCurrentStackFrame();
                        }
                        try {
                            String ptype = sourceMgr.getDetailTypeNameFromVariable(frame, this.getQualifiedName());
                            this.fType = sourceMgr.getType(target, ptype);
                        }
                        catch (CDIException cDIException3) {}
                    }
                }
            }
            if (this.fType == null) {
                this.fType = new IncompleteType(target, nametype);
            }
            this.addToTypeCache(nametype, this.fType);
        }
        return this.fType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public int sizeof() throws CDIException {
        if (this.sizeof == null) {
            Target target = (Target)this.getTarget();
            Thread currentThread = (Thread)target.getCurrentThread();
            StackFrame currentFrame = currentThread.getCurrentStackFrame();
            StackFrame frame = (StackFrame)this.getStackFrame();
            Thread thread = (Thread)this.getThread();
            target.lockTarget();
            try {
                try {
                    if (frame != null) {
                        target.setCurrentThread(frame.getThread(), false);
                        ((Thread)frame.getThread()).setCurrentStackFrame(frame, false);
                    } else if (thread != null) {
                        target.setCurrentThread(thread, false);
                    }
                    MISession mi = target.getMISession();
                    CommandFactory factory = mi.getCommandFactory();
                    String exp = "sizeof(" + this.getTypeName() + ")";
                    MIDataEvaluateExpression evaluate = factory.createMIDataEvaluateExpression(exp);
                    mi.postCommand(evaluate);
                    MIDataEvaluateExpressionInfo info = evaluate.getMIDataEvaluateExpressionInfo();
                    if (info == null) {
                        throw new CDIException(CdiResources.getString("cdi.model.VariableDescriptor.Target_not_responding"));
                    }
                    this.sizeof = info.getExpression();
                }
                catch (MIException e) {
                    throw new MI2CDIException(e);
                }
                Object var11_15 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    if (frame != null) {
                        target.setCurrentThread(currentThread, false);
                        currentThread.setCurrentStackFrame(currentFrame, false);
                    } else if (thread != null) {
                        target.setCurrentThread(currentThread, false);
                    }
                    Object var13_19 = null;
                    target.releaseTarget();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    Object var13_18 = null;
                    target.releaseTarget();
                    throw throwable2;
                }
            }
            try {}
            catch (Throwable throwable) {
                Object var13_20 = null;
                target.releaseTarget();
                throw throwable;
            }
            if (frame != null) {
                target.setCurrentThread(currentThread, false);
                currentThread.setCurrentStackFrame(currentFrame, false);
            } else if (thread != null) {
                target.setCurrentThread(currentThread, false);
            }
            Object var13_21 = null;
            target.releaseTarget();
        }
        if (this.sizeof == null) return 0;
        try {
            return Integer.parseInt(this.sizeof);
        }
        catch (NumberFormatException e) {
            throw new CDIException(e.getMessage());
        }
    }

    public ICDIStackFrame getStackFrame() throws CDIException {
        return this.fStackFrame;
    }

    public ICDIThread getThread() throws CDIException {
        return this.fThread;
    }

    public String getTypeName() throws CDIException {
        if (this.fTypename == null) {
            Target target = (Target)this.getTarget();
            StackFrame frame = (StackFrame)this.getStackFrame();
            if (frame == null) {
                Thread thread = (Thread)this.getThread();
                frame = thread != null ? thread.getCurrentStackFrame() : ((Thread)target.getCurrentThread()).getCurrentStackFrame();
            }
            Session session = (Session)target.getSession();
            SourceManager sourceMgr = session.getSourceManager();
            this.fTypename = frame != null ? sourceMgr.getTypeNameFromVariable(frame, this.getQualifiedName()) : sourceMgr.getTypeName(target, this.getQualifiedName());
        }
        return this.fTypename;
    }

    public String getQualifiedName() throws CDIException {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.encodeVariable();
        }
        return this.qualifiedName;
    }

    public static boolean equalsCasting(VariableDescriptor var1, VariableDescriptor var2) {
        String[] castings1 = var1.getCastingTypes();
        String[] castings2 = var2.getCastingTypes();
        if (castings1 == null && castings2 == null) {
            return true;
        }
        if (castings1 != null && castings2 != null && castings1.length == castings2.length) {
            int i = 0;
            while (i < castings1.length) {
                if (!castings1[i].equals(castings2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean equals(ICDIVariableDescriptor varDesc) {
        VariableDescriptor desc;
        if (varDesc instanceof VariableDescriptor && (desc = (VariableDescriptor)varDesc).getFullName().equals(this.getFullName()) && desc.getName().equals(this.getName()) && desc.getCastingArrayStart() == this.getCastingArrayStart() && desc.getCastingArrayEnd() == this.getCastingArrayEnd() && VariableDescriptor.equalsCasting(desc, this)) {
            ICDIThread varThread = null;
            ICDIThread ourThread = null;
            try {
                varThread = desc.getThread();
                ourThread = this.getThread();
            }
            catch (CDIException cDIException) {}
            if (ourThread == null && varThread == null || varThread != null && ourThread != null && varThread.equals(ourThread)) {
                ICDIStackFrame varFrame = null;
                ICDIStackFrame ourFrame = null;
                try {
                    varFrame = desc.getStackFrame();
                    ourFrame = this.getStackFrame();
                }
                catch (CDIException cDIException) {}
                if (ourFrame == null && varFrame == null) {
                    return true;
                }
                if (varFrame != null && ourFrame != null && varFrame.equals(ourFrame) && desc.getStackDepth() == this.getStackDepth() && desc.getPosition() == this.getPosition()) {
                    return true;
                }
            }
            return false;
        }
        return super.equals(varDesc);
    }

    public ICDIVariableDescriptor getVariableDescriptorAsArray(int start, int length) throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        VariableManager mgr = session.getVariableManager();
        return mgr.getVariableDescriptorAsArray(this, start, length);
    }

    public ICDIVariableDescriptor getVariableDescriptorAsType(String type) throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        VariableManager mgr = session.getVariableManager();
        return mgr.getVariableDescriptorAsType(this, type);
    }
}

