/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigInfoFactory2;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;

public class ScannerConfigProfileManager {
    public static final String SI_PROFILE_SIMPLE_ID = "ScannerConfigurationDiscoveryProfile";
    public static final String PER_PROJECT_PROFILE_ID;
    public static final String DEFAULT_SI_PROFILE_ID;
    public static final String NULL_PROFILE_ID = "";
    private Map projectProfileInstance = new HashMap();
    private List profileIds;
    private static ScannerConfigProfileManager instance;

    static {
        DEFAULT_SI_PROFILE_ID = PER_PROJECT_PROFILE_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".GCCStandardMakePerProjectProfile";
        instance = null;
    }

    private ScannerConfigProfileManager() {
    }

    public static ScannerConfigProfileManager getInstance() {
        if (instance == null) {
            instance = new ScannerConfigProfileManager();
        }
        return instance;
    }

    private String getProfileId(IProject project) {
        String profileId;
        IScannerConfigBuilderInfo2 buildInfo = null;
        try {
            buildInfo = ScannerConfigProfileManager.createScannerConfigBuildInfo2(project);
            profileId = buildInfo.getSelectedProfileId();
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e);
            profileId = DEFAULT_SI_PROFILE_ID;
        }
        return profileId;
    }

    public void addProfile(IProject project, ScannerConfigProfile profile) {
        this.projectProfileInstance.put(project, profile);
    }

    public SCProfileInstance getSCProfileInstance(IProject project, String profileId) {
        SCProfileInstance profileInstance;
        if (profileId == NULL_PROFILE_ID) {
            profileId = this.getProfileId(project);
        }
        if ((profileInstance = (SCProfileInstance)this.projectProfileInstance.get(project)) == null || !profileInstance.getProfile().getId().equals(profileId)) {
            profileInstance = new SCProfileInstance(project, this.getSCProfileConfiguration(profileId));
            this.projectProfileInstance.put(project, profileInstance);
        }
        return profileInstance;
    }

    public SCProfileInstance getSCProfileInstance(String profileId) {
        SCProfileInstance profileInstance = null;
        if (profileId != NULL_PROFILE_ID) {
            profileInstance = new SCProfileInstance(null, this.getSCProfileConfiguration(profileId));
        }
        return profileInstance;
    }

    public ScannerConfigProfile getSCProfileConfiguration(String profileId) {
        profileId = profileId == NULL_PROFILE_ID ? ScannerConfigProfileManager.getDefaultSIProfileId() : profileId;
        return new ScannerConfigProfile(profileId);
    }

    public List getProfileIds() {
        if (this.profileIds == null) {
            this.profileIds = new ArrayList();
            IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.make.core", SI_PROFILE_SIMPLE_ID);
            if (extension != null) {
                IExtension[] extensions = extension.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    String rProfileId = extensions[i].getUniqueIdentifier();
                    this.profileIds.add(rProfileId);
                    ++i;
                }
            }
        }
        return this.profileIds;
    }

    public static String getDefaultSIProfileId() {
        return DEFAULT_SI_PROFILE_ID;
    }

    public static IScannerConfigBuilderInfo2 createScannerConfigBuildInfo2(IProject project, String profileId) throws CoreException {
        return ScannerConfigInfoFactory2.create(project, profileId);
    }

    public static IScannerConfigBuilderInfo2 createScannerConfigBuildInfo2(IProject project) throws CoreException {
        return ScannerConfigInfoFactory2.create(project, NULL_PROFILE_ID);
    }

    public static IScannerConfigBuilderInfo2 createScannerConfigBuildInfo2(Preferences prefs, String profileId, boolean useDefaults) {
        return ScannerConfigInfoFactory2.create(prefs, profileId, useDefaults);
    }

    public static IScannerConfigBuilderInfo2 createScannerConfigBuildInfo2(Preferences prefs, boolean useDefaults) {
        return ScannerConfigInfoFactory2.create(prefs, NULL_PROFILE_ID, useDefaults);
    }
}

