/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class JavaElementImageProvider {
    public static final int OVERLAY_ICONS = 1;
    public static final int SMALL_ICONS = 2;
    public static final int LIGHT_TYPE_ICONS = 4;
    public static final Point SMALL_SIZE = new Point(16, 16);
    public static final Point BIG_SIZE = new Point(22, 16);
    private static ImageDescriptor DESC_OBJ_PROJECT_CLOSED;
    private static ImageDescriptor DESC_OBJ_PROJECT;
    private ImageDescriptorRegistry fRegistry;
    static /* synthetic */ Class class$0;

    public JavaElementImageProvider() {
        ISharedImages images = JavaPlugin.getDefault().getWorkbench().getSharedImages();
        DESC_OBJ_PROJECT_CLOSED = images.getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
        DESC_OBJ_PROJECT = images.getImageDescriptor("IMG_OBJ_PROJECT");
        this.fRegistry = null;
    }

    public Image getImageLabel(Object element, int flags) {
        return this.getImageLabel(this.computeDescriptor(element, flags));
    }

    private Image getImageLabel(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return this.getRegistry().get(descriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = JavaPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    private ImageDescriptor computeDescriptor(Object element, int flags) {
        if (element instanceof IJavaElement) {
            return this.getJavaImageDescriptor((IJavaElement)element, flags);
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            if (JavaCore.isJavaLikeFileName((String)file.getName())) {
                return this.getCUResourceImageDescriptor(file, flags);
            }
            return this.getWorkbenchImageDescriptor((IAdaptable)file, flags);
        }
        if (element instanceof IAdaptable) {
            return this.getWorkbenchImageDescriptor((IAdaptable)element, flags);
        }
        return null;
    }

    private static boolean showOverlayIcons(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    private static boolean useLightIcons(int flags) {
        return (flags & 4) != 0;
    }

    public ImageDescriptor getCUResourceImageDescriptor(IFile file, int flags) {
        Point size = JavaElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_CUNIT_RESOURCE, 0, size);
    }

    public ImageDescriptor getJavaImageDescriptor(IJavaElement element, int flags) {
        int adornmentFlags = this.computeJavaAdornmentFlags(element, flags);
        Point size = JavaElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new JavaElementImageDescriptor(this.getBaseImageDescriptor(element, flags), adornmentFlags, size);
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable adaptable, int flags) {
        IWorkbenchAdapter wbAdapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((wbAdapter = (IWorkbenchAdapter)adaptable.getAdapter((Class)clazz)) == null) {
            return null;
        }
        ImageDescriptor descriptor = wbAdapter.getImageDescriptor((Object)adaptable);
        if (descriptor == null) {
            return null;
        }
        Point size = JavaElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new JavaElementImageDescriptor(descriptor, 0, size);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImageDescriptor getBaseImageDescriptor(IJavaElement element, int renderFlags) {
        try {
            switch (element.getElementType()) {
                case 10: {
                    return JavaPluginImages.DESC_MISC_PRIVATE;
                }
                case 9: {
                    IMethod method = (IMethod)element;
                    IType declType = method.getDeclaringType();
                    int flags = method.getFlags();
                    if (!declType.isEnum() || !JavaElementImageProvider.isDefaultFlag(flags) || !method.isConstructor()) return JavaElementImageProvider.getMethodImageDescriptor(JavaModelUtil.isInterfaceOrAnnotation(declType), flags);
                    return JavaPluginImages.DESC_MISC_PRIVATE;
                }
                case 8: {
                    IMember member = (IMember)element;
                    IType declType = member.getDeclaringType();
                    return JavaElementImageProvider.getFieldImageDescriptor(JavaModelUtil.isInterfaceOrAnnotation(declType), member.getFlags());
                }
                case 14: {
                    return JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE;
                }
                case 11: {
                    return JavaPluginImages.DESC_OBJS_PACKDECL;
                }
                case 13: {
                    return JavaPluginImages.DESC_OBJS_IMPDECL;
                }
                case 12: {
                    return JavaPluginImages.DESC_OBJS_IMPCONT;
                }
                case 7: {
                    IType type = (IType)element;
                    IType declType = type.getDeclaringType();
                    boolean isInner = declType != null;
                    boolean isInInterfaceOrAnnotation = isInner && JavaModelUtil.isInterfaceOrAnnotation(declType);
                    return JavaElementImageProvider.getTypeImageDescriptor(isInner, isInInterfaceOrAnnotation, type.getFlags(), JavaElementImageProvider.useLightIcons(renderFlags));
                }
                case 3: {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                    if (!root.isArchive()) return JavaPluginImages.DESC_OBJS_PACKFRAG_ROOT;
                    IPath attach = root.getSourceAttachmentPath();
                    if (root.isExternal()) {
                        if (attach != null) return JavaPluginImages.DESC_OBJS_EXTJAR_WSRC;
                        return JavaPluginImages.DESC_OBJS_EXTJAR;
                    }
                    if (attach != null) return JavaPluginImages.DESC_OBJS_JAR_WSRC;
                    return JavaPluginImages.DESC_OBJS_JAR;
                }
                case 4: {
                    return this.getPackageFragmentIcon(element, renderFlags);
                }
                case 5: {
                    return JavaPluginImages.DESC_OBJS_CUNIT;
                }
                case 6: {
                    return JavaPluginImages.DESC_OBJS_CFILE;
                }
                case 2: {
                    ImageDescriptor result;
                    IWorkbenchAdapter adapter;
                    IJavaProject jp = (IJavaProject)element;
                    if (!jp.getProject().isOpen()) return DESC_OBJ_PROJECT_CLOSED;
                    IProject project = jp.getProject();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((adapter = (IWorkbenchAdapter)project.getAdapter((Class)clazz)) == null || (result = adapter.getImageDescriptor((Object)project)) == null) return DESC_OBJ_PROJECT;
                    return result;
                }
                case 1: {
                    return JavaPluginImages.DESC_OBJS_JAVA_MODEL;
                }
                case 15: {
                    return JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE;
                }
            }
            Assert.isTrue((boolean)false, (String)JavaUIMessages.JavaImageLabelprovider_assert_wrongImage);
            return JavaPluginImages.DESC_OBJS_GHOST;
        }
        catch (JavaModelException e) {
            if (e.isDoesNotExist()) {
                return JavaPluginImages.DESC_OBJS_UNKNOWN;
            }
            JavaPlugin.log(e);
            return JavaPluginImages.DESC_OBJS_GHOST;
        }
    }

    private static boolean isDefaultFlag(int flags) {
        return !Flags.isPublic((int)flags) && !Flags.isProtected((int)flags) && !Flags.isPrivate((int)flags);
    }

    protected ImageDescriptor getPackageFragmentIcon(IJavaElement element, int renderFlags) throws JavaModelException {
        IPackageFragment fragment = (IPackageFragment)element;
        boolean containsJavaElements = false;
        try {
            containsJavaElements = fragment.hasChildren();
        }
        catch (JavaModelException javaModelException) {}
        if (!containsJavaElements && fragment.getNonJavaResources().length > 0) {
            return JavaPluginImages.DESC_OBJS_EMPTY_PACKAGE_RESOURCES;
        }
        if (!containsJavaElements) {
            return JavaPluginImages.DESC_OBJS_EMPTY_PACKAGE;
        }
        return JavaPluginImages.DESC_OBJS_PACKAGE;
    }

    public void dispose() {
    }

    private int computeJavaAdornmentFlags(IJavaElement element, int renderFlags) {
        int flags = 0;
        if (JavaElementImageProvider.showOverlayIcons(renderFlags) && element instanceof IMember) {
            try {
                int modifiers;
                IMember member = (IMember)element;
                if (element.getElementType() == 9 && ((IMethod)element).isConstructor()) {
                    flags |= 0x200;
                }
                if (Flags.isAbstract((int)(modifiers = member.getFlags())) && JavaElementImageProvider.confirmAbstract(member)) {
                    flags |= 1;
                }
                if (Flags.isFinal((int)modifiers) || JavaElementImageProvider.isInterfaceOrAnnotationField(member) || JavaElementImageProvider.isEnumConstant(member, modifiers)) {
                    flags |= 2;
                }
                if (Flags.isSynchronized((int)modifiers) && JavaElementImageProvider.confirmSynchronized((IJavaElement)member)) {
                    flags |= 4;
                }
                if (Flags.isStatic((int)modifiers) || JavaElementImageProvider.isInterfaceOrAnnotationFieldOrType(member) || JavaElementImageProvider.isEnumConstant(member, modifiers)) {
                    flags |= 8;
                }
                if (Flags.isDeprecated((int)modifiers)) {
                    flags |= 0x400;
                }
                if (member.getElementType() == 7 && JavaModelUtil.hasMainMethod((IType)member)) {
                    flags |= 0x10;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return flags;
    }

    private static boolean confirmAbstract(IMember element) throws JavaModelException {
        if (element.getElementType() == 7) {
            return !JavaModelUtil.isInterfaceOrAnnotation((IType)element);
        }
        return !JavaModelUtil.isInterfaceOrAnnotation(element.getDeclaringType());
    }

    private static boolean isInterfaceOrAnnotationField(IMember element) throws JavaModelException {
        if (element.getElementType() == 8) {
            return JavaModelUtil.isInterfaceOrAnnotation(element.getDeclaringType());
        }
        return false;
    }

    private static boolean isInterfaceOrAnnotationFieldOrType(IMember element) throws JavaModelException {
        if (element.getElementType() == 8) {
            return JavaModelUtil.isInterfaceOrAnnotation(element.getDeclaringType());
        }
        if (element.getElementType() == 7 && element.getDeclaringType() != null) {
            return JavaModelUtil.isInterfaceOrAnnotation(element.getDeclaringType());
        }
        return false;
    }

    private static boolean isEnumConstant(IMember element, int modifiers) throws JavaModelException {
        if (element.getElementType() == 8) {
            return Flags.isEnum((int)modifiers);
        }
        return false;
    }

    private static boolean confirmSynchronized(IJavaElement member) {
        return member.getElementType() != 7;
    }

    public static ImageDescriptor getMethodImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInInterfaceOrAnnotation) {
            return JavaPluginImages.DESC_MISC_PUBLIC;
        }
        if (Flags.isProtected((int)flags)) {
            return JavaPluginImages.DESC_MISC_PROTECTED;
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_MISC_PRIVATE;
        }
        return JavaPluginImages.DESC_MISC_DEFAULT;
    }

    public static ImageDescriptor getFieldImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInInterfaceOrAnnotation || Flags.isEnum((int)flags)) {
            return JavaPluginImages.DESC_FIELD_PUBLIC;
        }
        if (Flags.isProtected((int)flags)) {
            return JavaPluginImages.DESC_FIELD_PROTECTED;
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_FIELD_PRIVATE;
        }
        return JavaPluginImages.DESC_FIELD_DEFAULT;
    }

    public static ImageDescriptor getTypeImageDescriptor(boolean isInterface, boolean isInner, boolean isInInterface, int flags) {
        return JavaElementImageProvider.getTypeImageDescriptor(isInner, isInInterface, isInterface ? flags | 0x200 : flags, false);
    }

    public static ImageDescriptor getTypeImageDescriptor(boolean isInner, boolean isInInterfaceOrAnnotation, int flags, boolean useLightIcons) {
        if (Flags.isEnum((int)flags)) {
            if (useLightIcons) {
                return JavaPluginImages.DESC_OBJS_ENUM_ALT;
            }
            if (isInner) {
                return JavaElementImageProvider.getInnerEnumImageDescriptor(isInInterfaceOrAnnotation, flags);
            }
            return JavaElementImageProvider.getEnumImageDescriptor(flags);
        }
        if (Flags.isAnnotation((int)flags)) {
            if (useLightIcons) {
                return JavaPluginImages.DESC_OBJS_ANNOTATION_ALT;
            }
            if (isInner) {
                return JavaElementImageProvider.getInnerAnnotationImageDescriptor(isInInterfaceOrAnnotation, flags);
            }
            return JavaElementImageProvider.getAnnotationImageDescriptor(flags);
        }
        if (Flags.isInterface((int)flags)) {
            if (useLightIcons) {
                return JavaPluginImages.DESC_OBJS_INTERFACEALT;
            }
            if (isInner) {
                return JavaElementImageProvider.getInnerInterfaceImageDescriptor(isInInterfaceOrAnnotation, flags);
            }
            return JavaElementImageProvider.getInterfaceImageDescriptor(flags);
        }
        if (useLightIcons) {
            return JavaPluginImages.DESC_OBJS_CLASSALT;
        }
        if (isInner) {
            return JavaElementImageProvider.getInnerClassImageDescriptor(isInInterfaceOrAnnotation, flags);
        }
        return JavaElementImageProvider.getClassImageDescriptor(flags);
    }

    public static Image getDecoratedImage(ImageDescriptor baseImage, int adornments, Point size) {
        return JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new JavaElementImageDescriptor(baseImage, adornments, size));
    }

    private static ImageDescriptor getClassImageDescriptor(int flags) {
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags) || Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_CLASS;
        }
        return JavaPluginImages.DESC_OBJS_CLASS_DEFAULT;
    }

    private static ImageDescriptor getInnerClassImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInInterfaceOrAnnotation) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PUBLIC;
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PRIVATE;
        }
        if (Flags.isProtected((int)flags)) {
            return JavaPluginImages.DESC_OBJS_INNER_CLASS_PROTECTED;
        }
        return JavaPluginImages.DESC_OBJS_INNER_CLASS_DEFAULT;
    }

    private static ImageDescriptor getEnumImageDescriptor(int flags) {
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags) || Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_ENUM;
        }
        return JavaPluginImages.DESC_OBJS_ENUM_DEFAULT;
    }

    private static ImageDescriptor getInnerEnumImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInInterfaceOrAnnotation) {
            return JavaPluginImages.DESC_OBJS_ENUM;
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_ENUM_PRIVATE;
        }
        if (Flags.isProtected((int)flags)) {
            return JavaPluginImages.DESC_OBJS_ENUM_PROTECTED;
        }
        return JavaPluginImages.DESC_OBJS_ENUM_DEFAULT;
    }

    private static ImageDescriptor getAnnotationImageDescriptor(int flags) {
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags) || Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_ANNOTATION;
        }
        return JavaPluginImages.DESC_OBJS_ANNOTATION_DEFAULT;
    }

    private static ImageDescriptor getInnerAnnotationImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInInterfaceOrAnnotation) {
            return JavaPluginImages.DESC_OBJS_ANNOTATION;
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_ANNOTATION_PRIVATE;
        }
        if (Flags.isProtected((int)flags)) {
            return JavaPluginImages.DESC_OBJS_ANNOTATION_PROTECTED;
        }
        return JavaPluginImages.DESC_OBJS_ANNOTATION_DEFAULT;
    }

    private static ImageDescriptor getInterfaceImageDescriptor(int flags) {
        if (Flags.isPublic((int)flags) || Flags.isProtected((int)flags) || Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_INTERFACE;
        }
        return JavaPluginImages.DESC_OBJS_INTERFACE_DEFAULT;
    }

    private static ImageDescriptor getInnerInterfaceImageDescriptor(boolean isInInterfaceOrAnnotation, int flags) {
        if (Flags.isPublic((int)flags) || isInInterfaceOrAnnotation) {
            return JavaPluginImages.DESC_OBJS_INNER_INTERFACE_PUBLIC;
        }
        if (Flags.isPrivate((int)flags)) {
            return JavaPluginImages.DESC_OBJS_INNER_INTERFACE_PRIVATE;
        }
        if (Flags.isProtected((int)flags)) {
            return JavaPluginImages.DESC_OBJS_INNER_INTERFACE_PROTECTED;
        }
        return JavaPluginImages.DESC_OBJS_INTERFACE_DEFAULT;
    }
}

