/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragAndDropEffect;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

class TableDragAndDropEffect
extends DragAndDropEffect {
    Table table;
    int currentEffect = 0;
    TableItem currentItem;
    PaintListener paintListener;
    TableItem dropSelection = null;
    TableItem scrollItem;
    long scrollBeginTime;
    static final int SCROLL_HYSTERESIS = 150;

    TableDragAndDropEffect(Table table) {
        this.table = table;
    }

    int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    Widget getItem(int x, int y) {
        Rectangle area;
        Point coordinates = new Point(x, y);
        TableItem item = this.table.getItem(coordinates = this.table.toControl(coordinates));
        if (item == null && (area = this.table.getClientArea()).contains(coordinates)) {
            int x1 = area.x;
            while (x1 < area.x + area.width) {
                Point pt = new Point(x1, coordinates.y);
                item = this.table.getItem(pt);
                if (item != null) break;
                ++x1;
            }
        }
        return item;
    }

    void setDropSelection(TableItem item) {
        Rectangle bounds;
        if (item == this.dropSelection) {
            return;
        }
        if (this.dropSelection != null && !this.dropSelection.isDisposed()) {
            bounds = this.dropSelection.getBounds(0);
            this.table.redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
        }
        this.dropSelection = item;
        if (this.dropSelection != null && !this.dropSelection.isDisposed()) {
            bounds = this.dropSelection.getBounds(0);
            this.table.redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
        }
        if (this.dropSelection == null) {
            if (this.paintListener != null) {
                this.table.removePaintListener(this.paintListener);
                this.paintListener = null;
            }
        } else if (this.paintListener == null) {
            this.paintListener = new PaintListener(){

                public void paintControl(PaintEvent e) {
                    if (TableDragAndDropEffect.this.dropSelection == null || TableDragAndDropEffect.this.dropSelection.isDisposed()) {
                        return;
                    }
                    GC gc = e.gc;
                    boolean xor = gc.getXORMode();
                    gc.setXORMode(true);
                    Rectangle bounds = TableDragAndDropEffect.this.dropSelection.getBounds(0);
                    gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                    gc.setXORMode(xor);
                }
            };
            this.table.addPaintListener(this.paintListener);
        }
    }

    void showDropTargetEffect(int effect, int x, int y) {
        effect = this.checkEffect(effect);
        TableItem item = (TableItem)this.getItem(x, y);
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollItem = null;
        } else if (item != null && item.equals(this.scrollItem) && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                int index;
                Rectangle area = this.table.getClientArea();
                int headerHeight = this.table.getHeaderHeight();
                int itemHeight = this.table.getItemHeight();
                Point pt = new Point(x, y);
                pt = this.table.getDisplay().map(null, (Control)this.table, pt);
                TableItem nextItem = null;
                if (pt.y < area.y + headerHeight + 2 * itemHeight) {
                    index = Math.max(0, this.table.indexOf(item) - 1);
                    nextItem = this.table.getItem(index);
                }
                if (pt.y > area.y + area.height - 2 * itemHeight) {
                    index = Math.min(this.table.getItemCount() - 1, this.table.indexOf(item) + 1);
                    nextItem = this.table.getItem(index);
                }
                if (nextItem != null) {
                    this.table.showItem(nextItem);
                }
                this.scrollBeginTime = 0L;
                this.scrollItem = null;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollItem = item;
        }
        if ((effect & 1) != 0) {
            if (this.currentItem != item || (this.currentEffect & 1) == 0) {
                this.setDropSelection(item);
                this.currentEffect = effect;
                this.currentItem = item;
            }
        } else {
            this.setDropSelection(null);
        }
    }
}

