/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XTextProperty;
import org.eclipse.swt.widgets.Display;

public class TextTransfer
extends ByteArrayTransfer {
    static TextTransfer _instance = new TextTransfer();
    static final String COMPOUND_TEXT = "COMPOUND_TEXT";
    static final String STRING = "STRING";
    static final int COMPOUND_TEXT_ID = TextTransfer.registerType("COMPOUND_TEXT");
    static final int STRING_ID = TextTransfer.registerType("STRING");

    TextTransfer() {
    }

    public static TextTransfer getInstance() {
        return _instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void javaToNative(Object object, TransferData transferData) {
        byte[] buffer;
        block11: {
            transferData.result = 0;
            if (!this.checkText(object) || !this.isSupportedType(transferData)) {
                DND.error(2003);
            }
            String string = (String)object;
            buffer = Converter.wcsToMbcs(null, string, true);
            if (transferData.type != COMPOUND_TEXT_ID) break block11;
            Display display = Display.getCurrent();
            if (display == null) {
                return;
            }
            int xDisplay = display.xDisplay;
            int pBuffer = OS.XtMalloc(buffer.length);
            if (pBuffer == 0) {
                return;
            }
            try {
                XTextProperty text_prop_return;
                block14: {
                    block13: {
                        int list;
                        block12: {
                            OS.memmove(pBuffer, buffer, buffer.length);
                            list = OS.XtMalloc(4);
                            if (list != 0) break block12;
                            break block13;
                        }
                        OS.memmove(list, new int[]{pBuffer}, 4);
                        text_prop_return = new XTextProperty();
                        int result = OS.XmbTextListToTextProperty(xDisplay, list, 1, 1, text_prop_return);
                        OS.XtFree(list);
                        if (result == 0) break block14;
                    }
                    Object var11_10 = null;
                    OS.XtFree(pBuffer);
                    return;
                }
                transferData.format = text_prop_return.format;
                transferData.length = text_prop_return.nitems;
                transferData.pValue = text_prop_return.value;
                transferData.type = text_prop_return.encoding;
                transferData.result = 1;
                Object var11_12 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                OS.XtFree(pBuffer);
                throw throwable;
            }
            OS.XtFree(pBuffer);
        }
        if (transferData.type == STRING_ID) {
            int pValue = OS.XtMalloc(buffer.length);
            if (pValue == 0) {
                return;
            }
            OS.memmove(pValue, buffer, buffer.length);
            transferData.type = STRING_ID;
            transferData.format = 8;
            transferData.length = buffer.length - 1;
            transferData.pValue = pValue;
            transferData.result = 1;
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        byte[] buffer = null;
        if (transferData.type == COMPOUND_TEXT_ID) {
            Display display = Display.getCurrent();
            if (display == null) {
                return null;
            }
            int xDisplay = display.xDisplay;
            XTextProperty text_prop = new XTextProperty();
            text_prop.encoding = transferData.type;
            text_prop.format = transferData.format;
            text_prop.nitems = transferData.length;
            text_prop.value = transferData.pValue;
            int[] list_return = new int[1];
            int[] count_return = new int[1];
            int result = OS.XmbTextPropertyToTextList(xDisplay, text_prop, list_return, count_return);
            if (result != 0 || list_return[0] == 0) {
                return null;
            }
            int[] ptr = new int[1];
            OS.memmove(ptr, list_return[0], 4);
            int length = OS.strlen(ptr[0]);
            buffer = new byte[length];
            OS.memmove(buffer, ptr[0], length);
            OS.XFreeStringList(list_return[0]);
        }
        if (transferData.type == STRING_ID) {
            int size = transferData.format * transferData.length / 8;
            if (size == 0) {
                return null;
            }
            buffer = new byte[size];
            OS.memmove(buffer, transferData.pValue, size);
        }
        if (buffer == null) {
            return null;
        }
        char[] unicode = Converter.mbcsToWcs(null, buffer);
        String string = new String(unicode);
        int end = string.indexOf(0);
        return end == -1 ? string : string.substring(0, end);
    }

    protected int[] getTypeIds() {
        return new int[]{COMPOUND_TEXT_ID, STRING_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{COMPOUND_TEXT, STRING};
    }

    boolean checkText(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkText(object);
    }
}

