/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XColor;

public final class Cursor
extends Resource {
    public int handle;
    static final byte[] APPSTARTING_SRC;
    static final byte[] APPSTARTING_MASK;

    static {
        byte[] byArray = new byte[128];
        byArray[8] = 4;
        byArray[12] = 12;
        byArray[16] = 28;
        byArray[20] = 60;
        byArray[24] = 124;
        byArray[28] = -4;
        byArray[32] = -4;
        byArray[33] = 1;
        byArray[36] = -4;
        byArray[37] = 59;
        byArray[40] = 124;
        byArray[41] = 56;
        byArray[44] = 108;
        byArray[45] = 84;
        byArray[48] = -60;
        byArray[49] = -36;
        byArray[52] = -64;
        byArray[53] = 68;
        byArray[56] = -128;
        byArray[57] = 57;
        byArray[60] = -128;
        byArray[61] = 57;
        APPSTARTING_SRC = byArray;
        byte[] byArray2 = new byte[128];
        byArray2[4] = 6;
        byArray2[8] = 14;
        byArray2[12] = 30;
        byArray2[16] = 62;
        byArray2[20] = 126;
        byArray2[24] = -2;
        byArray2[28] = -2;
        byArray2[29] = 1;
        byArray2[32] = -2;
        byArray2[33] = 59;
        byArray2[36] = -2;
        byArray2[37] = 127;
        byArray2[40] = -2;
        byArray2[41] = 127;
        byArray2[44] = -2;
        byArray2[45] = -2;
        byArray2[48] = -18;
        byArray2[49] = -1;
        byArray2[50] = 1;
        byArray2[52] = -28;
        byArray2[53] = -1;
        byArray2[56] = -64;
        byArray2[57] = 127;
        byArray2[60] = -64;
        byArray2[61] = 127;
        byArray2[64] = -128;
        byArray2[65] = 57;
        APPSTARTING_MASK = byArray2;
    }

    Cursor() {
    }

    public Cursor(Device device, int style) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        int shape = 0;
        switch (style) {
            case 3: {
                break;
            }
            case 0: {
                shape = 68;
                break;
            }
            case 1: {
                shape = 150;
                break;
            }
            case 21: {
                shape = 60;
                break;
            }
            case 2: {
                shape = 30;
                break;
            }
            case 4: {
                shape = 92;
                break;
            }
            case 5: {
                shape = 52;
                break;
            }
            case 6: {
                shape = 120;
                break;
            }
            case 7: {
                shape = 42;
                break;
            }
            case 8: {
                shape = 120;
                break;
            }
            case 9: {
                shape = 108;
                break;
            }
            case 10: {
                shape = 138;
                break;
            }
            case 11: {
                shape = 16;
                break;
            }
            case 12: {
                shape = 96;
                break;
            }
            case 13: {
                shape = 70;
                break;
            }
            case 14: {
                shape = 136;
                break;
            }
            case 15: {
                shape = 14;
                break;
            }
            case 16: {
                shape = 12;
                break;
            }
            case 17: {
                shape = 134;
                break;
            }
            case 18: {
                shape = 114;
                break;
            }
            case 19: {
                shape = 152;
                break;
            }
            case 20: {
                shape = 0;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.handle = shape == 0 && style == 3 ? this.createCursor(APPSTARTING_SRC, APPSTARTING_MASK, 32, 32, 2, 2, true) : OS.XCreateFontCursor(device.xDisplay, shape);
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Cursor(Device device, ImageData source, ImageData mask, int hotspotX, int hotspotY) {
        byte s;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            if (source.getTransparencyType() != 2) {
                SWT.error(5);
            }
            mask = source.getTransparencyMask();
        }
        if (mask.width != source.width || mask.height != source.height) {
            SWT.error(5);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        source = ImageData.convertMask(source);
        mask = ImageData.convertMask(mask);
        byte[] sourceData = new byte[source.data.length];
        byte[] maskData = new byte[mask.data.length];
        byte[] data = source.data;
        int i = 0;
        while (i < data.length) {
            s = data[i];
            sourceData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
            sourceData[i] = ~sourceData[i];
            ++i;
        }
        sourceData = ImageData.convertPad(sourceData, source.width, source.height, source.depth, source.scanlinePad, 1);
        data = mask.data;
        i = 0;
        while (i < data.length) {
            s = data[i];
            maskData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
            maskData[i] = ~maskData[i];
            ++i;
        }
        maskData = ImageData.convertPad(maskData, mask.width, mask.height, mask.depth, mask.scanlinePad, 1);
        this.handle = this.createCursor(maskData, sourceData, source.width, source.height, hotspotX, hotspotY, true);
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Cursor(Device device, ImageData source, int hotspotX, int hotspotY) {
        byte s;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (source == null) {
            SWT.error(4);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        ImageData mask = source.getTransparencyMask();
        if (source.depth > 1) {
            ImageData newSource = new ImageData(source.width, source.height, 1, ImageData.bwPalette(), 1, null, 0, null, null, -1, -1, source.type, source.x, source.y, source.disposalMethod, source.delayTime);
            PaletteData palette = source.palette;
            if (palette.isDirect) {
                ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, 0, 0, 0, 255, null, 0, 0, 0, newSource.data, newSource.depth, newSource.bytesPerLine, newSource.getByteOrder(), 0, 0, newSource.width, newSource.height, 0, 0, 0, false, false);
            } else {
                ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, source.width, source.height, null, null, null, 255, null, 0, 0, 0, newSource.data, newSource.depth, newSource.bytesPerLine, newSource.getByteOrder(), 0, 0, newSource.width, newSource.height, null, null, null, false, false);
            }
            source = newSource;
        }
        byte[] sourceData = new byte[source.data.length];
        byte[] maskData = new byte[mask.data.length];
        byte[] data = source.data;
        int i = 0;
        while (i < data.length) {
            s = data[i];
            sourceData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
            ++i;
        }
        sourceData = ImageData.convertPad(sourceData, source.width, source.height, source.depth, source.scanlinePad, 1);
        data = mask.data;
        i = 0;
        while (i < data.length) {
            s = data[i];
            maskData[i] = (byte)((s & 0x80) >> 7 | (s & 0x40) >> 5 | (s & 0x20) >> 3 | (s & 0x10) >> 1 | (s & 8) << 1 | (s & 4) << 3 | (s & 2) << 5 | (s & 1) << 7);
            ++i;
        }
        maskData = ImageData.convertPad(maskData, mask.width, mask.height, mask.depth, mask.scanlinePad, 1);
        this.handle = this.createCursor(sourceData, maskData, source.width, source.height, hotspotX, hotspotY, false);
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    int createCursor(byte[] sourceData, byte[] maskData, int width, int height, int hotspotX, int hotspotY, boolean reverse) {
        int xDisplay = this.device.xDisplay;
        int drawable = OS.XDefaultRootWindow(xDisplay);
        int sourcePixmap = OS.XCreateBitmapFromData(xDisplay, drawable, sourceData, width, height);
        int maskPixmap = OS.XCreateBitmapFromData(xDisplay, drawable, maskData, width, height);
        int cursor = 0;
        if (sourcePixmap != 0 && maskPixmap != 0) {
            int screenNum = OS.XDefaultScreen(xDisplay);
            XColor foreground = new XColor();
            int n = foreground.pixel = !reverse ? OS.XWhitePixel(xDisplay, screenNum) : OS.XBlackPixel(xDisplay, screenNum);
            if (!reverse) {
                foreground.blue = (short)-1;
                foreground.green = (short)-1;
                foreground.red = (short)-1;
            }
            XColor background = new XColor();
            int n2 = background.pixel = reverse ? OS.XWhitePixel(xDisplay, screenNum) : OS.XBlackPixel(xDisplay, screenNum);
            if (reverse) {
                background.blue = (short)-1;
                background.green = (short)-1;
                background.red = (short)-1;
            }
            cursor = OS.XCreatePixmapCursor(xDisplay, sourcePixmap, maskPixmap, foreground, background, hotspotX, hotspotY);
        }
        if (sourcePixmap != 0) {
            OS.XFreePixmap(xDisplay, sourcePixmap);
        }
        if (maskPixmap != 0) {
            OS.XFreePixmap(xDisplay, maskPixmap);
        }
        return cursor;
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        OS.XFreeCursor(this.device.xDisplay, this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public static Cursor motif_new(Device device, int handle) {
        if (device == null) {
            device = Device.getDevice();
        }
        Cursor cursor = new Cursor();
        cursor.device = device;
        cursor.handle = handle;
        return cursor;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }
}

