/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;

public final class FontData {
    public String foundry;
    public String fontFamily;
    public String weight;
    public String slant;
    public String setWidth;
    public String addStyle;
    public int pixels;
    public int points;
    public int horizontalResolution;
    public int verticalResolution;
    public String spacing;
    public int averageWidth;
    public String characterSetRegistry;
    public String characterSetName;
    String lang;
    String country;
    String variant;

    public FontData() {
    }

    public FontData(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int start = 0;
        int end = string.indexOf(124);
        if (end == -1) {
            SWT.error(4);
        }
        String version1 = string.substring(start, end);
        try {
            if (Integer.parseInt(version1) != 1) {
                SWT.error(5);
            }
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        if ((end = string.indexOf(124, start = end + 1)) == -1) {
            SWT.error(4);
        }
        String name = string.substring(start, end);
        start = end + 1;
        if ((end = string.indexOf(124, start)) == -1) {
            SWT.error(4);
        }
        int height = 0;
        try {
            height = Integer.parseInt(string.substring(start, end));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(4);
        }
        start = end + 1;
        end = string.indexOf(124, start);
        if (end == -1) {
            SWT.error(4);
        }
        int style = 0;
        try {
            style = Integer.parseInt(string.substring(start, end));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(4);
        }
        start = end + 1;
        end = string.indexOf(124, start);
        if (end == -1) {
            this.setName(name);
            this.setHeight(height);
            this.setStyle(style);
            return;
        }
        String platform = string.substring(start, end);
        start = end + 1;
        if ((end = string.indexOf(124, start)) == -1) {
            this.setName(name);
            this.setHeight(height);
            this.setStyle(style);
            return;
        }
        String version2 = string.substring(start, end);
        if (platform.equals("MOTIF") && version2.equals("1")) {
            start = end + 1;
            end = string.length();
            if (end == -1) {
                this.setName(name);
                this.setHeight(height);
                this.setStyle(style);
                return;
            }
            String xlfd = string.substring(start, end);
            this.setXlfd(xlfd);
            return;
        }
        this.setName(name);
        this.setHeight(height);
        this.setStyle(style);
    }

    public FontData(String name, int height, int style) {
        int dash;
        if (name == null) {
            SWT.error(4);
        }
        if (height < 0) {
            SWT.error(5);
        }
        if ((dash = name.indexOf(45)) != -1) {
            this.foundry = name.substring(0, dash);
            this.fontFamily = name.substring(dash + 1);
        } else {
            this.fontFamily = name;
        }
        this.points = height * 10;
        this.weight = (style & 1) != 0 ? "bold" : "medium";
        this.slant = (style & 2) != 0 ? "i" : "r";
    }

    public boolean equals(Object object) {
        return object == this || object instanceof FontData && this.getXlfd().equals(((FontData)object).getXlfd());
    }

    public int getHeight() {
        return this.points / 10;
    }

    public String getLocale() {
        String result;
        int length;
        StringBuffer buffer = new StringBuffer();
        char sep = '_';
        if (this.lang != null) {
            buffer.append(this.lang);
            buffer.append(sep);
        }
        if (this.country != null) {
            buffer.append(this.country);
            buffer.append(sep);
        }
        if (this.variant != null) {
            buffer.append(this.variant);
        }
        if ((length = (result = buffer.toString()).length()) > 0 && result.charAt(length - 1) == sep) {
            result = result.substring(0, length - 1);
        }
        return result;
    }

    public String getName() {
        StringBuffer buffer = new StringBuffer();
        if (this.foundry != null) {
            buffer.append(this.foundry);
            buffer.append("-");
        }
        if (this.fontFamily != null) {
            buffer.append(this.fontFamily);
        }
        return buffer.toString();
    }

    public int getStyle() {
        int style = 0;
        if (this.weight != null && this.weight.equals("bold")) {
            style |= 1;
        }
        if (this.slant != null && this.slant.equals("i")) {
            style |= 2;
        }
        return style;
    }

    String getXlfd() {
        String s14 = "*";
        String s13 = "*";
        String s12 = "*";
        String s11 = "*";
        String s10 = "*";
        String s9 = "*";
        String s8 = "*";
        String s7 = "*";
        String s6 = "*";
        String s5 = "*";
        String s4 = "*";
        String s3 = "*";
        String s2 = "*";
        String s1 = "*";
        if (this.foundry != null) {
            s1 = this.foundry;
        }
        if (this.fontFamily != null) {
            s2 = this.fontFamily;
        }
        if (this.weight != null) {
            s3 = this.weight;
        }
        if (this.slant != null) {
            s4 = this.slant;
        }
        if (this.setWidth != null) {
            s5 = this.setWidth;
        }
        if (this.addStyle != null) {
            s6 = this.addStyle;
        }
        if (this.pixels != 0) {
            s7 = Integer.toString(this.pixels);
        }
        if (this.points != 0) {
            s8 = Integer.toString(this.points);
        }
        if (this.horizontalResolution != 0) {
            s9 = Integer.toString(this.horizontalResolution);
        }
        if (this.verticalResolution != 0) {
            s10 = Integer.toString(this.verticalResolution);
        }
        if (this.spacing != null) {
            s11 = this.spacing;
        }
        if (this.averageWidth != 0) {
            s12 = Integer.toString(this.averageWidth);
        }
        if (this.characterSetRegistry != null) {
            s13 = this.characterSetRegistry;
        }
        if (this.characterSetName != null) {
            s14 = this.characterSetName;
        }
        return "-" + s1 + "-" + s2 + "-" + s3 + "-" + s4 + "-" + s5 + "-" + s6 + "-" + s7 + "-" + s8 + "-" + s9 + "-" + s10 + "-" + s11 + "-" + s12 + "-" + s13 + "-" + s14;
    }

    public int hashCode() {
        return this.getXlfd().hashCode();
    }

    public static FontData motif_new(String xlfd) {
        FontData fontData = new FontData();
        fontData.setXlfd(xlfd);
        return fontData;
    }

    public void setHeight(int height) {
        if (height < 0) {
            SWT.error(5);
        }
        this.points = height * 10;
    }

    public void setName(String name) {
        int dash;
        if (name == null) {
            SWT.error(4);
        }
        if ((dash = name.indexOf(45)) != -1) {
            this.foundry = name.substring(0, dash);
            this.fontFamily = name.substring(dash + 1);
        } else {
            this.fontFamily = name;
        }
    }

    public void setLocale(String locale) {
        this.variant = null;
        this.country = null;
        this.lang = null;
        if (locale != null) {
            int secondSep;
            int sep = 95;
            int length = locale.length();
            int firstSep = locale.indexOf(sep);
            if (firstSep == -1) {
                firstSep = secondSep = length;
            } else {
                secondSep = locale.indexOf(sep, firstSep + 1);
                if (secondSep == -1) {
                    secondSep = length;
                }
            }
            if (firstSep > 0) {
                this.lang = locale.substring(0, firstSep);
            }
            if (secondSep > firstSep + 1) {
                this.country = locale.substring(firstSep + 1, secondSep);
            }
            if (length > secondSep + 1) {
                this.variant = locale.substring(secondSep + 1);
            }
        }
    }

    public void setStyle(int style) {
        this.weight = (style & 1) != 0 ? "bold" : "medium";
        this.slant = (style & 2) != 0 ? "i" : "r";
        this.averageWidth = 0;
    }

    void setXlfd(String xlfd) {
        String s;
        int start = 1;
        int stop = xlfd.indexOf("-", start);
        this.foundry = xlfd.substring(start, stop);
        if (this.foundry.equals("*")) {
            this.foundry = null;
        }
        start = stop + 1;
        stop = xlfd.indexOf("-", start);
        this.fontFamily = xlfd.substring(start, stop);
        if (this.fontFamily.equals("*")) {
            this.fontFamily = null;
        }
        start = stop + 1;
        stop = xlfd.indexOf("-", start);
        this.weight = xlfd.substring(start, stop);
        if (this.weight.equals("*")) {
            this.weight = null;
        }
        start = stop + 1;
        stop = xlfd.indexOf("-", start);
        this.slant = xlfd.substring(start, stop);
        if (this.slant.equals("*")) {
            this.slant = null;
        }
        start = stop + 1;
        stop = xlfd.indexOf("-", start);
        this.setWidth = xlfd.substring(start, stop);
        if (this.setWidth.equals("*")) {
            this.setWidth = null;
        }
        start = stop + 1;
        stop = xlfd.indexOf("-", start);
        this.addStyle = xlfd.substring(start, stop);
        if (this.addStyle.equals("*")) {
            this.addStyle = null;
        }
        if (!(s = xlfd.substring(start = stop + 1, stop = xlfd.indexOf("-", start))).equals("") && !s.equals("*")) {
            this.pixels = Integer.parseInt(s);
        }
        if (!(s = xlfd.substring(start = stop + 1, stop = xlfd.indexOf("-", start))).equals("") && !s.equals("*")) {
            this.points = Integer.parseInt(s);
        }
        if (!(s = xlfd.substring(start = stop + 1, stop = xlfd.indexOf("-", start))).equals("") && !s.equals("*")) {
            this.horizontalResolution = Integer.parseInt(s);
        }
        if (!(s = xlfd.substring(start = stop + 1, stop = xlfd.indexOf("-", start))).equals("") && !s.equals("*")) {
            this.verticalResolution = Integer.parseInt(s);
        }
        start = stop + 1;
        stop = xlfd.indexOf("-", start);
        this.spacing = xlfd.substring(start, stop);
        start = stop + 1;
        s = xlfd.substring(start, stop = xlfd.indexOf("-", start));
        if (!s.equals("") && !s.equals("*")) {
            if (s.startsWith("~")) {
                s = "-" + s.substring(1);
            }
            this.averageWidth = Integer.parseInt(s);
        }
        start = stop + 1;
        stop = xlfd.indexOf("-", start);
        this.characterSetRegistry = xlfd.substring(start, stop);
        if (this.characterSetRegistry.equals("*")) {
            this.characterSetRegistry = null;
        }
        start = stop + 1;
        stop = xlfd.indexOf("-", start);
        this.characterSetName = xlfd.substring(start);
        if (this.characterSetName.equals("*")) {
            this.characterSetName = null;
        }
    }

    public String toString() {
        return "1|" + this.fontFamily + "|" + this.getHeight() + "|" + this.getStyle() + "|" + "MOTIF|1|" + this.getXlfd();
    }
}

