/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XRectangle;

public final class Region
extends Resource {
    public int handle;

    public Region() {
        this(null);
    }

    public Region(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.handle = OS.XCreateRegion();
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    Region(Device device, int handle) {
        this.device = device;
        this.handle = handle;
    }

    public void add(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        short[] points = new short[pointArray.length];
        int i = 0;
        while (i < pointArray.length) {
            points[i] = (short)pointArray[i];
            ++i;
        }
        int polyRgn = OS.XPolygonRegion(points, points.length / 2, 0);
        OS.XUnionRegion(this.handle, polyRgn, this.handle);
        OS.XDestroyRegion(polyRgn);
    }

    public void add(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.add(rect.x, rect.y, rect.width, rect.height);
    }

    public void add(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        XRectangle xRect = new XRectangle();
        xRect.x = (short)x;
        xRect.y = (short)y;
        xRect.width = (short)width;
        xRect.height = (short)height;
        OS.XUnionRectWithRegion(xRect, this.handle, this.handle);
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.XUnionRegion(this.handle, region.handle, this.handle);
    }

    public boolean contains(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.XPointInRegion(this.handle, x, y);
    }

    public boolean contains(Point pt) {
        if (pt == null) {
            SWT.error(4);
        }
        return this.contains(pt.x, pt.y);
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        OS.XDestroyRegion(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.handle == region.handle;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        XRectangle rect = new XRectangle();
        OS.XClipBox(this.handle, rect);
        return new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public int hashCode() {
        return this.handle;
    }

    public void intersect(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.intersect(rect.x, rect.y, rect.width, rect.height);
    }

    public void intersect(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        int rectRgn = OS.XCreateRegion();
        XRectangle xRect = new XRectangle();
        xRect.x = (short)x;
        xRect.y = (short)y;
        xRect.width = (short)width;
        xRect.height = (short)height;
        OS.XUnionRectWithRegion(xRect, rectRgn, rectRgn);
        OS.XIntersectRegion(this.handle, rectRgn, this.handle);
        OS.XDestroyRegion(rectRgn);
    }

    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.XIntersectRegion(this.handle, region.handle, this.handle);
    }

    public boolean intersects(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.XRectInRegion(this.handle, x, y, width, height) != 0;
    }

    public boolean intersects(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        return this.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.XEmptyRegion(this.handle);
    }

    public static Region motif_new(Device device, int handle) {
        return new Region(device, handle);
    }

    public void subtract(int[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        short[] points = new short[pointArray.length];
        int i = 0;
        while (i < pointArray.length) {
            points[i] = (short)pointArray[i];
            ++i;
        }
        int polyRgn = OS.XPolygonRegion(points, points.length / 2, 0);
        OS.XSubtractRegion(this.handle, polyRgn, this.handle);
        OS.XDestroyRegion(polyRgn);
    }

    public void subtract(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.subtract(rect.x, rect.y, rect.width, rect.height);
    }

    public void subtract(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            SWT.error(5);
        }
        int rectRgn = OS.XCreateRegion();
        XRectangle xRect = new XRectangle();
        xRect.x = (short)x;
        xRect.y = (short)y;
        xRect.width = (short)width;
        xRect.height = (short)height;
        OS.XUnionRectWithRegion(xRect, rectRgn, rectRgn);
        OS.XSubtractRegion(this.handle, rectRgn, this.handle);
        OS.XDestroyRegion(rectRgn);
    }

    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.XSubtractRegion(this.handle, region.handle, this.handle);
    }

    public void translate(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.XOffsetRegion(this.handle, x, y);
    }

    public void translate(Point pt) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pt == null) {
            SWT.error(4);
        }
        this.translate(pt.x, pt.y);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

