/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.internal.motif.OS;

public final class Converter {
    static final byte[] NULL_BYTE_ARRAY;
    static final byte[] EMPTY_BYTE_ARRAY;
    static final char[] EMPTY_CHAR_ARRAY;
    static String CodePage;
    static final byte[] UCS2;
    static final byte[] UTF8;
    static final Object LOCK;
    static boolean LastMbcsToUCS2Failed;
    static boolean LastUCS2ToMbcsFailed;
    static String LastMbcsToUCS2CodePage;
    static String LastUCS2ToMbcsCodePage;
    static int LastUCS2ToMbcs;
    static int LastUTF8ToMbcs;
    static int LastMbcsToUCS2;
    static int LastMbcsToUTF8;
    static int UTF8ToUCS2;
    static int UCS2ToUTF8;
    static int BufferSize;
    static int MbcsBuffer;
    static int Ucs2Buffer;
    static int Utf8Buffer;

    static {
        int length;
        NULL_BYTE_ARRAY = new byte[1];
        EMPTY_BYTE_ARRAY = new byte[0];
        EMPTY_CHAR_ARRAY = new char[0];
        LOCK = new Object();
        LastUCS2ToMbcs = -1;
        LastUTF8ToMbcs = -1;
        LastMbcsToUCS2 = -1;
        LastMbcsToUTF8 = -1;
        UTF8ToUCS2 = -1;
        UCS2ToUTF8 = -1;
        if (OS.IsHPUX) {
            UCS2 = Converter.getAsciiBytes("ucs2");
            UTF8 = Converter.getAsciiBytes("utf8");
        } else {
            UCS2 = Converter.getAsciiBytes("UCS-2");
            UTF8 = Converter.getAsciiBytes("UTF-8");
        }
        int item = OS.nl_langinfo(OS.CODESET);
        if (item != 0 && (length = OS.strlen(item)) > 0) {
            byte[] buffer = new byte[length];
            OS.memmove(buffer, item, length);
            CodePage = new String(buffer);
            if (OS.IsSunOS && length > 3 && CodePage.indexOf("ISO") == 0) {
                CodePage = CodePage.substring(3, length);
            }
        } else {
            CodePage = OS.IsLinux ? "ISO-8859-1" : (OS.IsAIX ? "ISO8859-1" : (OS.IsSunOS ? "8859-1" : "iso8859_1"));
        }
        BufferSize = 512;
        Ucs2Buffer = OS.XtMalloc(BufferSize * 2);
        Utf8Buffer = OS.XtMalloc(BufferSize * 6);
        MbcsBuffer = OS.XtMalloc(BufferSize * 6);
    }

    public static String defaultCodePage() {
        return CodePage;
    }

    static byte[] getAsciiBytes(String str) {
        int length = str.length();
        byte[] buffer = new byte[length + 1];
        int i = 0;
        while (i < length) {
            buffer[i] = (byte)str.charAt(i);
            ++i;
        }
        return buffer;
    }

    static String getAsciiString(byte[] buffer) {
        int length = buffer.length;
        char[] chars = new char[length];
        int i = 0;
        while (i < length) {
            chars[i] = (char)buffer[i];
            ++i;
        }
        return new String(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] mbcsToWcs(String codePage, byte[] buffer) {
        if (buffer == null) {
            return EMPTY_CHAR_ARRAY;
        }
        int length = buffer.length;
        if (length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] wideCharStr = new char[length];
        int i = 0;
        while (i < length) {
            if ((buffer[i] & 0xFF) > 127) {
                Object object = LOCK;
                synchronized (object) {
                    int cd;
                    String cp;
                    String string = cp = codePage != null ? codePage : CodePage;
                    if (cp != LastMbcsToUCS2CodePage && !cp.equals(LastMbcsToUCS2CodePage)) {
                        if (LastMbcsToUCS2 != -1) {
                            OS.iconv_close(LastMbcsToUCS2);
                        }
                        if (LastMbcsToUTF8 != -1) {
                            OS.iconv_close(LastMbcsToUTF8);
                        }
                        LastMbcsToUTF8 = -1;
                        LastMbcsToUCS2 = -1;
                        LastMbcsToUCS2CodePage = cp;
                        LastMbcsToUCS2Failed = false;
                    }
                    if ((cd = LastMbcsToUCS2) == -1 && !LastMbcsToUCS2Failed) {
                        cd = LastMbcsToUCS2 = OS.iconv_open(UCS2, Converter.getAsciiBytes(cp));
                    }
                    if (cd == -1) {
                        LastMbcsToUCS2Failed = true;
                        cd = UTF8ToUCS2;
                        if (cd == -1) {
                            cd = UTF8ToUCS2 = OS.iconv_open(UCS2, UTF8);
                        }
                        if (cd == -1) {
                            return EMPTY_CHAR_ARRAY;
                        }
                        cd = LastMbcsToUTF8;
                        if (cd == -1) {
                            cd = LastMbcsToUTF8 = OS.iconv_open(UTF8, Converter.getAsciiBytes(cp));
                        }
                    }
                    if (cd == -1) {
                        return EMPTY_CHAR_ARRAY;
                    }
                    boolean utf8 = cd == LastMbcsToUTF8;
                    int inByteCount = length;
                    int outByteCount = utf8 ? length * 6 : length * 2;
                    int ptr1 = 0;
                    int ptr2 = 0;
                    int ptr3 = 0;
                    if (length <= BufferSize) {
                        ptr1 = MbcsBuffer;
                        ptr2 = Utf8Buffer;
                        ptr3 = Ucs2Buffer;
                    } else {
                        ptr1 = OS.XtMalloc(inByteCount);
                        if (utf8) {
                            ptr2 = OS.XtMalloc(length * 6);
                        }
                        ptr3 = OS.XtMalloc(length * 2);
                    }
                    int ptr = utf8 ? ptr2 : ptr3;
                    int[] inBuffer = new int[]{ptr1};
                    int[] inBytesLeft = new int[]{inByteCount};
                    int[] outBuffer = new int[]{ptr};
                    int[] outBytesLeft = new int[]{outByteCount};
                    OS.memmove(ptr1, buffer, inByteCount);
                    OS.iconv(cd, inBuffer, inBytesLeft, outBuffer, outBytesLeft);
                    outByteCount = outBuffer[0] - ptr;
                    if (utf8) {
                        cd = UTF8ToUCS2;
                        inByteCount = outByteCount;
                        outByteCount = length * 2;
                        inBuffer[0] = ptr2;
                        inBytesLeft[0] = inByteCount;
                        outBuffer[0] = ptr3;
                        outBytesLeft[0] = outByteCount;
                        OS.iconv(cd, inBuffer, inBytesLeft, outBuffer, outBytesLeft);
                        outByteCount = outBuffer[0] - ptr3;
                    }
                    wideCharStr = new char[outByteCount / 2];
                    OS.memmove(wideCharStr, ptr3, outByteCount);
                    if (ptr1 != 0 && ptr1 != MbcsBuffer) {
                        OS.XtFree(ptr1);
                    }
                    if (ptr2 != 0 && ptr2 != Utf8Buffer) {
                        OS.XtFree(ptr2);
                    }
                    if (ptr3 != 0 && ptr3 != Ucs2Buffer) {
                        OS.XtFree(ptr3);
                    }
                }
                return wideCharStr;
            }
            wideCharStr[i] = (char)buffer[i];
            ++i;
        }
        return wideCharStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release() {
        Object object = LOCK;
        synchronized (object) {
            if (Ucs2Buffer != 0) {
                OS.XtFree(Ucs2Buffer);
            }
            if (Utf8Buffer != 0) {
                OS.XtFree(Utf8Buffer);
            }
            if (MbcsBuffer != 0) {
                OS.XtFree(MbcsBuffer);
            }
            if (LastUCS2ToMbcs != -1) {
                OS.iconv_close(LastUCS2ToMbcs);
            }
            if (LastUTF8ToMbcs != -1) {
                OS.iconv_close(LastUTF8ToMbcs);
            }
            if (LastMbcsToUCS2 != -1) {
                OS.iconv_close(LastMbcsToUCS2);
            }
            if (LastMbcsToUTF8 != -1) {
                OS.iconv_close(LastMbcsToUTF8);
            }
            if (UTF8ToUCS2 != -1) {
                OS.iconv_close(UTF8ToUCS2);
            }
            if (UCS2ToUTF8 != -1) {
                OS.iconv_close(UCS2ToUTF8);
            }
            LastMbcsToUTF8 = UTF8ToUCS2 = UCS2ToUTF8 - 1;
            LastMbcsToUCS2 = UTF8ToUCS2;
            LastUTF8ToMbcs = UTF8ToUCS2;
            LastUCS2ToMbcs = UTF8ToUCS2;
            MbcsBuffer = 0;
            Utf8Buffer = 0;
            Ucs2Buffer = 0;
        }
    }

    public static byte[] wcsToMbcs(String codePage, char[] buffer) {
        return Converter.wcsToMbcs(codePage, buffer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] wcsToMbcs(String codePage, char[] buffer, boolean terminate) {
        if (buffer == null) {
            return terminate ? NULL_BYTE_ARRAY : EMPTY_BYTE_ARRAY;
        }
        int length = buffer.length;
        if (length == 0) {
            return terminate ? NULL_BYTE_ARRAY : EMPTY_BYTE_ARRAY;
        }
        byte[] mbcs = new byte[terminate ? length + 1 : length];
        int i = 0;
        while (i < length) {
            if ((buffer[i] & 0xFFFF) > 127) {
                Object object = LOCK;
                synchronized (object) {
                    int cd;
                    String cp;
                    String string = cp = codePage != null ? codePage : CodePage;
                    if (cp != LastUCS2ToMbcsCodePage && !cp.equals(LastUCS2ToMbcsCodePage)) {
                        if (LastUCS2ToMbcs != -1) {
                            OS.iconv_close(LastUCS2ToMbcs);
                        }
                        if (LastUTF8ToMbcs != -1) {
                            OS.iconv_close(LastUTF8ToMbcs);
                        }
                        LastUTF8ToMbcs = -1;
                        LastUCS2ToMbcs = -1;
                        LastUCS2ToMbcsCodePage = cp;
                    }
                    if ((cd = LastUCS2ToMbcs) == -1 && !LastUCS2ToMbcsFailed) {
                        cd = LastUCS2ToMbcs = OS.iconv_open(Converter.getAsciiBytes(cp), UCS2);
                    }
                    if (cd == -1) {
                        LastUCS2ToMbcsFailed = true;
                        cd = LastUTF8ToMbcs;
                        if (cd == -1) {
                            cd = LastUTF8ToMbcs = OS.iconv_open(Converter.getAsciiBytes(cp), UTF8);
                        }
                        if (cd == -1) {
                            return terminate ? NULL_BYTE_ARRAY : EMPTY_BYTE_ARRAY;
                        }
                        cd = UCS2ToUTF8;
                        if (cd == -1) {
                            cd = UCS2ToUTF8 = OS.iconv_open(UTF8, UCS2);
                        }
                    }
                    if (cd == -1) {
                        return terminate ? NULL_BYTE_ARRAY : EMPTY_BYTE_ARRAY;
                    }
                    boolean utf8 = cd == UCS2ToUTF8;
                    int inByteCount = length * 2;
                    int outByteCount = length * 6;
                    int ptr1 = 0;
                    int ptr2 = 0;
                    int ptr3 = 0;
                    if (length <= BufferSize) {
                        ptr1 = Ucs2Buffer;
                        ptr2 = Utf8Buffer;
                        ptr3 = MbcsBuffer;
                    } else {
                        ptr1 = OS.XtMalloc(inByteCount);
                        if (utf8) {
                            ptr2 = OS.XtMalloc(outByteCount);
                        }
                        ptr3 = OS.XtMalloc(outByteCount);
                    }
                    int ptr = utf8 ? ptr2 : ptr3;
                    int[] inBuffer = new int[]{ptr1};
                    int[] inBytesLeft = new int[]{inByteCount};
                    int[] outBuffer = new int[]{ptr};
                    int[] outBytesLeft = new int[]{outByteCount};
                    OS.memmove(ptr1, buffer, inByteCount);
                    while (inBytesLeft[0] > 0) {
                        OS.iconv(cd, inBuffer, inBytesLeft, outBuffer, outBytesLeft);
                        if (inBytesLeft[0] == 0) continue;
                        inBuffer[0] = inBuffer[0] + 2;
                        inBytesLeft[0] = inBytesLeft[0] - 2;
                    }
                    outByteCount = outBuffer[0] - ptr;
                    if (utf8) {
                        cd = LastUTF8ToMbcs;
                        inByteCount = outByteCount;
                        outByteCount = length * 6;
                        inBuffer[0] = ptr2;
                        inBytesLeft[0] = inByteCount;
                        outBuffer[0] = ptr3;
                        outBytesLeft[0] = outByteCount;
                        OS.iconv(cd, inBuffer, inBytesLeft, outBuffer, outBytesLeft);
                        outByteCount = outBuffer[0] - ptr3;
                    }
                    mbcs = new byte[terminate ? outByteCount + 1 : outByteCount];
                    OS.memmove(mbcs, ptr3, outByteCount);
                    if (ptr1 != 0 && ptr1 != Ucs2Buffer) {
                        OS.XtFree(ptr1);
                    }
                    if (ptr2 != 0 && ptr2 != Utf8Buffer) {
                        OS.XtFree(ptr2);
                    }
                    if (ptr3 != 0 && ptr3 != MbcsBuffer) {
                        OS.XtFree(ptr3);
                    }
                }
                return mbcs;
            }
            mbcs[i] = (byte)buffer[i];
            ++i;
        }
        return mbcs;
    }

    public static byte[] wcsToMbcs(String codePage, String string) {
        return Converter.wcsToMbcs(codePage, string, false);
    }

    public static byte[] wcsToMbcs(String codePage, String string, boolean terminate) {
        if (terminate) {
            if (string == null) {
                return NULL_BYTE_ARRAY;
            }
            int count = string.length();
            char[] buffer = new char[count + 1];
            string.getChars(0, count, buffer, 0);
            return Converter.wcsToMbcs(codePage, buffer, false);
        }
        if (string == null) {
            return EMPTY_BYTE_ARRAY;
        }
        int count = string.length();
        char[] buffer = new char[count];
        string.getChars(0, count, buffer, 0);
        return Converter.wcsToMbcs(codePage, buffer, false);
    }
}

