/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

public class Library {
    static int MAJOR_VERSION = 3;
    static int MINOR_VERSION = 236;
    static int REVISION = 0;
    public static final int JAVA_VERSION = Library.parseVersion(System.getProperty("java.version"));
    public static final int SWT_VERSION = Library.SWT_VERSION(MAJOR_VERSION, MINOR_VERSION);

    static int parseVersion(String version) {
        if (version == null) {
            return 0;
        }
        int major = 0;
        int minor = 0;
        int micro = 0;
        int length = version.length();
        int index = 0;
        int start = 0;
        while (index < length && Character.isDigit(version.charAt(index))) {
            ++index;
        }
        try {
            if (start < length) {
                major = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        start = ++index;
        while (index < length && Character.isDigit(version.charAt(index))) {
            ++index;
        }
        try {
            if (start < length) {
                minor = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        start = ++index;
        while (index < length && Character.isDigit(version.charAt(index))) {
            ++index;
        }
        try {
            if (start < length) {
                micro = Integer.parseInt(version.substring(start, index));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return Library.JAVA_VERSION(major, minor, micro);
    }

    public static int JAVA_VERSION(int major, int minor, int micro) {
        return (major << 16) + (minor << 8) + micro;
    }

    public static int SWT_VERSION(int major, int minor) {
        return major * 1000 + minor;
    }

    public static void loadLibrary(String name) {
        String platform = "motif";
        String version = System.getProperty("swt.version");
        if (version == null) {
            version = "" + MAJOR_VERSION;
            if (MINOR_VERSION < 10) {
                version = String.valueOf(version) + "00";
            } else if (MINOR_VERSION < 100) {
                version = String.valueOf(version) + "0";
            }
            version = String.valueOf(version) + MINOR_VERSION;
            if (REVISION > 0) {
                version = String.valueOf(version) + "r" + REVISION;
            }
        }
        try {
            String newName = String.valueOf(name) + "-" + platform + "-" + version;
            System.loadLibrary(newName);
            return;
        }
        catch (UnsatisfiedLinkError e1) {
            try {
                String newName = String.valueOf(name) + "-" + platform;
                System.loadLibrary(newName);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw e1;
            }
        }
    }
}

