/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XRectangle;
import org.eclipse.swt.internal.motif.XmTextBlockRec;
import org.eclipse.swt.internal.motif.XmTextVerifyCallbackStruct;
import org.eclipse.swt.internal.motif.XtWidgetGeometry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    int visibleCount = 5;
    public static final int LIMIT = Integer.MAX_VALUE;
    boolean ignoreSelect;

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
    }

    public void add(String string) {
        byte[] buffer;
        int xmString;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((xmString = OS.XmStringCreateLocalized(buffer = Converter.wcsToMbcs(this.getCodePage(), this.encodeString(string), true))) == 0) {
            this.error(14);
        }
        OS.XmComboBoxAddItem(this.handle, xmString, -1, false);
        OS.XmStringFree(xmString);
    }

    public void add(String string, int index) {
        byte[] buffer;
        int xmString;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index == -1) {
            this.error(6);
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNitemCount;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (index < 0 || index > argList[1]) {
            this.error(6);
        }
        if ((xmString = OS.XmStringCreateLocalized(buffer = Converter.wcsToMbcs(this.getCodePage(), this.encodeString(string), true))) == 0) {
            this.error(14);
        }
        OS.XmComboBoxAddItem(this.handle, xmString, index + 1, false);
        OS.XmStringFree(xmString);
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int style) {
        style &= 0xFFFFF7FF;
        style &= 0xFFFFFCFF;
        if (((style = Combo.checkBits(style, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return style & 0xFFFFFFF7;
        }
        return style;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        OS.XmTextClearSelection(argList[1], OS.XtLastTimestampProcessed(xDisplay));
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int[] nArray = new int[16];
        nArray[0] = OS.XmNlist;
        nArray[2] = OS.XmNtextField;
        nArray[4] = OS.XmNitemCount;
        nArray[6] = OS.XmNmarginWidth;
        nArray[8] = OS.XmNshadowThickness;
        nArray[10] = OS.XmNhighlightThickness;
        nArray[12] = OS.XmNarrowSize;
        nArray[14] = OS.XmNarrowSpacing;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        XtWidgetGeometry result = new XtWidgetGeometry();
        result.request_mode = 4;
        OS.XtQueryGeometry(argList[1], null, result);
        int width = result.width;
        int height = this.getTextHeight();
        int[] nArray2 = new int[4];
        nArray2[0] = OS.XmNmarginWidth;
        nArray2[2] = OS.XmNshadowThickness;
        int[] argList2 = nArray2;
        OS.XtGetValues(argList[3], argList2, argList2.length / 2);
        if ((this.style & 8) == 0) {
            width += 2 * argList[7];
        }
        if ((this.style & 4) != 0) {
            width += argList[13] + argList[15];
        } else {
            int itemCount = argList[5] == 0 ? 5 : argList[5];
            height += this.getItemHeight() * itemCount;
        }
        width += 2 * argList[9] + 2 * argList[11] + 2 * argList2[1] + 2 * argList2[3];
        if (argList[5] == 0) {
            width = 64;
        }
        if (hHint != -1) {
            height = hHint;
        }
        if (wHint != -1) {
            width = wHint;
        }
        Rectangle rect = this.computeTrim(0, 0, width, height);
        return new Point(rect.width, rect.height);
    }

    public void copy() {
        this.checkWidget();
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        OS.XmTextCopy(argList[1], OS.XtLastTimestampProcessed(xDisplay));
    }

    void createHandle(int index) {
        int parentHandle = this.parent.handle;
        int[] argList1 = new int[]{OS.XmNancestorSensitive, 1};
        this.formHandle = OS.XmCreateForm(parentHandle, null, argList1, argList1.length / 2);
        if (this.formHandle == 0) {
            this.error(2);
        }
        int comboBoxType = 1;
        if ((this.style & 0x40) != 0) {
            comboBoxType = 0;
        } else if ((this.style & 8) != 0) {
            comboBoxType = 2;
        }
        int[] nArray = new int[12];
        nArray[0] = OS.XmNcomboBoxType;
        nArray[1] = comboBoxType;
        nArray[2] = OS.XmNtopAttachment;
        nArray[3] = 1;
        nArray[4] = OS.XmNbottomAttachment;
        nArray[5] = 1;
        nArray[6] = OS.XmNleftAttachment;
        nArray[7] = 1;
        nArray[8] = OS.XmNrightAttachment;
        nArray[9] = 1;
        nArray[10] = OS.XmNresizable;
        int[] argList2 = nArray;
        this.handle = OS.XmCreateComboBox(this.formHandle, null, argList2, argList2.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
        int[] nArray2 = new int[2];
        nArray2[0] = OS.XmNtextField;
        int[] argList3 = nArray2;
        OS.XtGetValues(this.handle, argList3, argList3.length / 2);
        int textHandle = argList3[1];
        int[] nArray3 = new int[2];
        nArray3[0] = OS.XmNverifyBell;
        int[] argList4 = nArray3;
        OS.XtSetValues(textHandle, argList4, argList4.length / 2);
        OS.XmDropSiteUnregister(textHandle);
    }

    public void cut() {
        this.checkWidget();
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        OS.XmTextCut(argList[1], OS.XtLastTimestampProcessed(xDisplay));
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index == -1) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNtextField;
        nArray[2] = OS.XmNlist;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (OS.XmListPosSelected(argList[3], index + 1)) {
            boolean warnings = this.display.getWarnings();
            this.display.setWarnings(false);
            OS.XmTextSetString(argList[1], new byte[1]);
            this.display.setWarnings(warnings);
            OS.XmListDeselectAllItems(argList[3]);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNtextField;
        nArray[2] = OS.XmNlist;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextSetString(argList[1], new byte[1]);
        this.display.setWarnings(warnings);
        OS.XmListDeselectAllItems(argList[3]);
    }

    public String getItem(int index) {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNitemCount;
        nArray[2] = OS.XmNitems;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (index < 0 || index >= argList[1]) {
            this.error(6);
        }
        if (argList[3] == 0) {
            this.error(8);
        }
        int ptr = argList[3] + index * 4;
        int[] buffer1 = new int[1];
        OS.memmove(buffer1, ptr, 4);
        ptr = buffer1[0];
        int[] table = new int[]{this.display.tabMapping, this.display.crMapping};
        int address = OS.XmStringUnparse(ptr, null, 0, 0, table, table.length, 0);
        if (address == 0) {
            this.error(8);
        }
        int length = OS.strlen(address);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, address, length);
        OS.XtFree(address);
        return this.decodeString(new String(Converter.mbcsToWcs(this.getCodePage(), buffer)));
    }

    public int getItemCount() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNitemCount;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getItemHeight() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNlist;
        int[] listHandleArgs = nArray;
        OS.XtGetValues(this.handle, listHandleArgs, listHandleArgs.length / 2);
        int[] nArray2 = new int[6];
        nArray2[0] = OS.XmNlistSpacing;
        nArray2[2] = OS.XmNhighlightThickness;
        nArray2[4] = OS.XmNfontList;
        int[] argList = nArray2;
        OS.XtGetValues(listHandleArgs[1], argList, argList.length / 2);
        int spacing = argList[1];
        int highlight = argList[3];
        int fontList = argList[5];
        return this.getFontHeight(fontList) + spacing + 2 * highlight;
    }

    public String[] getItems() {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNitems;
        nArray[2] = OS.XmNitemCount;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int items = argList[1];
        int itemCount = argList[3];
        int[] buffer1 = new int[1];
        String[] result = new String[itemCount];
        String codePage = this.getCodePage();
        int i = 0;
        while (i < itemCount) {
            OS.memmove(buffer1, items, 4);
            int ptr = buffer1[0];
            int[] table = new int[]{this.display.tabMapping, this.display.crMapping};
            int address = OS.XmStringUnparse(ptr, null, 0, 0, table, table.length, 0);
            if (address == 0) {
                this.error(8);
            }
            int length = OS.strlen(address);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, address, length);
            OS.XtFree(address);
            result[i] = this.decodeString(new String(Converter.mbcsToWcs(codePage, buffer)));
            items += 4;
            ++i;
        }
        return result;
    }

    int getMinimumHeight() {
        return this.getTextHeight();
    }

    String getNameText() {
        return this.getText();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        int[] start = new int[1];
        int[] end = new int[1];
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        OS.XmTextGetSelectionPosition(argList[1], start, end);
        if (start[0] == end[0]) {
            start[0] = end[0] = OS.XmTextGetInsertionPosition(argList[1]);
        }
        return new Point(start[0], end[0]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNlist;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int index = OS.XmListGetKbdItemPos(argList[1]);
        if (OS.XmListPosSelected(argList[1], index)) {
            return index - 1;
        }
        int[] positions = new int[1];
        int[] count = new int[1];
        if (!OS.XmListGetSelectedPos(argList[1], positions, count)) {
            return -1;
        }
        if (count[0] == 0) {
            return -1;
        }
        int address = positions[0];
        int[] indices = new int[1];
        OS.memmove(indices, address, 4);
        OS.XtFree(address);
        return indices[0] - 1;
    }

    public String getText() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int ptr = OS.XmTextGetString(argList[1]);
        if (ptr == 0) {
            return "";
        }
        int length = OS.strlen(ptr);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, ptr, length);
        OS.XtFree(ptr);
        return this.decodeString(new String(Converter.mbcsToWcs(this.getCodePage(), buffer)));
    }

    public int getTextHeight() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if (!OS.XtIsRealized(this.handle)) {
                this.getShell().realizeWidget();
            }
            XtWidgetGeometry result = new XtWidgetGeometry();
            result.request_mode = 8;
            OS.XtQueryGeometry(this.handle, null, result);
            return result.height;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int[] nArray2 = new int[2];
        nArray2[0] = OS.XmNmarginHeight;
        int[] argList2 = nArray2;
        OS.XtGetValues(argList[1], argList2, argList2.length / 2);
        int height = this.getFontHeight(this.font.handle);
        XRectangle rect = new XRectangle();
        OS.XmWidgetGetDisplayRect(argList[1], rect);
        height += rect.y * 2 + 2 * argList2[1];
        int[] nArray3 = new int[6];
        nArray3[0] = OS.XmNmarginHeight;
        nArray3[2] = OS.XmNshadowThickness;
        nArray3[4] = OS.XmNhighlightThickness;
        int[] argList3 = nArray3;
        OS.XtGetValues(this.handle, argList3, argList3.length / 2);
        return height += 2 * argList3[1] + 2 * argList3[3] + 2 * argList3[5];
    }

    public int getTextLimit() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return OS.XmTextGetMaxLength(argList[1]);
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        if ((this.style & 0x40) != 0) {
            return this.visibleCount;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNvisibleItemCount;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.display.windowProc;
        int[] nArray = new int[4];
        nArray[0] = OS.XmNlist;
        nArray[2] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int listHandle = argList[1];
        int textHandle = argList[3];
        OS.XtAddCallback(listHandle, OS.XmNbrowseSelectionCallback, windowProc, 11);
        OS.XtAddEventHandler(listHandle, 1, false, windowProc, 6);
        OS.XtAddEventHandler(listHandle, 2, false, windowProc, 7);
        OS.XtAddCallback(textHandle, OS.XmNactivateCallback, windowProc, 9);
        OS.XtAddCallback(textHandle, OS.XmNvalueChangedCallback, windowProc, 24);
        OS.XtAddCallback(textHandle, OS.XmNmodifyVerifyCallback, windowProc, 19);
        OS.XtAddEventHandler(textHandle, 4, false, windowProc, 1);
        OS.XtAddEventHandler(textHandle, 8, false, windowProc, 2);
        OS.XtAddEventHandler(textHandle, 16, false, windowProc, 4);
        OS.XtAddEventHandler(textHandle, 32, false, windowProc, 8);
        OS.XtAddEventHandler(textHandle, 1, false, windowProc, 6);
        OS.XtAddEventHandler(textHandle, 2, false, windowProc, 7);
        OS.XtInsertEventHandler(textHandle, 0x200000, false, windowProc, 5, 1);
    }

    public int indexOf(String string) {
        byte[] buffer;
        int xmString;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((xmString = OS.XmStringCreateLocalized(buffer = Converter.wcsToMbcs(this.getCodePage(), this.encodeString(string), true))) == 0) {
            return -1;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNlist;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int index = OS.XmListItemPos(argList[1], xmString);
        OS.XmStringFree(xmString);
        return index - 1;
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNitems;
        nArray[2] = OS.XmNitemCount;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int items = argList[1];
        int itemCount = argList[3];
        if (start < 0 || start >= itemCount) {
            return -1;
        }
        byte[] buffer1 = Converter.wcsToMbcs(this.getCodePage(), this.encodeString(string), true);
        int xmString = OS.XmStringCreateLocalized(buffer1);
        if (xmString == 0) {
            return -1;
        }
        int index = start;
        items += start * 4;
        int[] buffer2 = new int[1];
        while (index < itemCount) {
            OS.memmove(buffer2, items, 4);
            if (OS.XmStringCompare(buffer2[0], xmString)) break;
            items += 4;
            ++index;
        }
        OS.XmStringFree(xmString);
        if (index == itemCount) {
            return -1;
        }
        return index;
    }

    public void paste() {
        this.checkWidget();
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        OS.XmTextFieldPaste(argList[1]);
        this.display.setWarnings(warnings);
    }

    public void remove(int index) {
        this.checkWidget();
        if (index == -1) {
            this.error(6);
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNitemCount;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (index < 0 || index >= argList[1]) {
            this.error(6);
        }
        if (argList[1] == 1) {
            this.removeAll();
        } else {
            OS.XmComboBoxDeletePos(this.handle, index + 1);
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNitemCount;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (start < 0 || start > end || end >= argList[1]) {
            this.error(6);
        }
        if (argList[1] == end - start + 1) {
            this.removeAll();
        } else {
            int i = start;
            while (i <= end) {
                OS.XmComboBoxDeletePos(this.handle, start + 1);
                ++i;
            }
        }
    }

    void register() {
        super.register();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNlist;
        nArray[2] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        this.display.addWidget(argList[1], this);
        this.display.addWidget(argList[3], this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if ((this.style & 4) != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNlist;
            int[] argList = nArray;
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            int xtParent = OS.XtParent(argList[1]);
            while (xtParent != 0 && !OS.XtIsSubclass(xtParent, OS.shellWidgetClass())) {
                xtParent = OS.XtParent(xtParent);
            }
            if (xtParent != 0) {
                OS.XtPopdown(xtParent);
            }
        }
    }

    public void remove(String string) {
        byte[] buffer;
        int xmString;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((xmString = OS.XmStringCreateLocalized(buffer = Converter.wcsToMbcs(this.getCodePage(), this.encodeString(string), true))) == 0) {
            this.error(15);
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNlist;
        nArray[2] = OS.XmNitemCount;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int index = OS.XmListItemPos(argList[1], xmString);
        OS.XmStringFree(xmString);
        if (index == 0) {
            this.error(5);
        }
        if (argList[3] == 1) {
            this.removeAll();
        } else {
            OS.XmComboBoxDeletePos(this.handle, index);
        }
    }

    public void removeAll() {
        this.checkWidget();
        int[] nArray = new int[6];
        nArray[0] = OS.XmNtextField;
        nArray[2] = OS.XmNlist;
        nArray[4] = OS.XmNitemCount;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextSetString(argList[1], new byte[1]);
        this.display.setWarnings(warnings);
        OS.XmListDeselectAllItems(argList[3]);
        int i = 0;
        while (i < argList[5]) {
            OS.XmComboBoxDeletePos(this.handle, 1);
            ++i;
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index == -1) {
            int[] nArray = new int[4];
            nArray[0] = OS.XmNtextField;
            nArray[2] = OS.XmNlist;
            int[] argList = nArray;
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            boolean warnings = this.display.getWarnings();
            this.display.setWarnings(false);
            OS.XmTextSetString(argList[1], new byte[1]);
            this.display.setWarnings(warnings);
            OS.XmListDeselectAllItems(argList[3]);
        } else {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNitemCount;
            int[] argList = nArray;
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            if (index < 0 || index >= argList[1]) {
                return;
            }
            int[] argList2 = new int[]{OS.XmNselectedPosition, index};
            this.ignoreSelect = true;
            OS.XtSetValues(this.handle, argList2, argList2.length / 2);
            this.ignoreSelect = false;
        }
    }

    boolean sendIMKeyEvent(int type, XKeyEvent xEvent) {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return super.sendIMKeyEvent(type, xEvent, argList[1]);
    }

    void setBackgroundPixel(int pixel) {
        super.setBackgroundPixel(pixel);
        int[] nArray = new int[4];
        nArray[0] = OS.XmNtextField;
        nArray[2] = OS.XmNlist;
        int[] argList1 = nArray;
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        int text = argList1[1];
        int list = argList1[3];
        int[] nArray2 = new int[4];
        nArray2[0] = OS.XmNforeground;
        nArray2[2] = OS.XmNhighlightColor;
        int[] argList2 = nArray2;
        OS.XtGetValues(text, argList2, argList2.length / 2);
        OS.XmChangeColor(text, pixel);
        OS.XtSetValues(text, argList2, argList2.length / 2);
        int[] nArray3 = new int[4];
        nArray3[0] = OS.XmNforeground;
        nArray3[2] = OS.XmNhighlightColor;
        int[] argList3 = nArray3;
        OS.XtGetValues(list, argList3, argList3.length / 2);
        OS.XmChangeColor(list, pixel);
        OS.XtSetValues(list, argList3, argList3.length / 2);
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        this.checkWidget();
        int newHeight = resize && (this.style & 4) != 0 ? this.getTextHeight() : height;
        return super.setBounds(x, y, width, newHeight, move, resize);
    }

    public void setFont(Font font) {
        boolean fixString;
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNitems;
        nArray[2] = OS.XmNitemCount;
        int[] argList1 = nArray;
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        boolean bl = fixString = OS.IsDBLocale && argList1[3] == 0;
        if (fixString) {
            byte[] buffer = Converter.wcsToMbcs(this.getCodePage(), "string", true);
            int xmString = OS.XmStringCreateLocalized(buffer);
            OS.XmComboBoxAddItem(this.handle, xmString, -1, false);
            OS.XmStringFree(xmString);
        }
        super.setFont(font);
        if (fixString) {
            OS.XtSetValues(this.handle, argList1, argList1.length / 2);
        }
        if (OS.XtIsRealized(this.handle)) {
            int[] nArray2 = new int[6];
            nArray2[0] = OS.XmNwidth;
            nArray2[2] = OS.XmNheight;
            nArray2[4] = OS.XmNborderWidth;
            int[] argList2 = nArray2;
            OS.XtGetValues(this.handle, argList2, argList2.length / 2);
            OS.XtResizeWidget(this.handle, argList2[1], argList2[3] + 1, argList2[5]);
            OS.XtResizeWidget(this.handle, argList2[1], argList2[3], argList2[5]);
        }
    }

    void setForegroundPixel(int pixel) {
        int[] nArray = new int[4];
        nArray[0] = OS.XmNtextField;
        nArray[2] = OS.XmNlist;
        int[] argList1 = nArray;
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        int[] argList2 = new int[]{OS.XmNforeground, pixel};
        OS.XtSetValues(argList1[1], argList2, argList2.length / 2);
        OS.XtSetValues(argList1[3], argList2, argList2.length / 2);
        super.setForegroundPixel(pixel);
    }

    public void setItem(int index, String string) {
        byte[] buffer;
        int xmString;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index == -1) {
            this.error(6);
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNlist;
        nArray[2] = OS.XmNitemCount;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (index < 0 || index >= argList[3]) {
            this.error(6);
        }
        if ((xmString = OS.XmStringCreateLocalized(buffer = Converter.wcsToMbcs(this.getCodePage(), this.encodeString(string), true))) == 0) {
            this.error(14);
        }
        boolean isSelected = OS.XmListPosSelected(argList[1], index + 1);
        OS.XmListReplaceItemsPosUnselected(argList[1], new int[]{xmString}, 1, index + 1);
        if (isSelected) {
            OS.XmListSelectPos(argList[1], index + 1, false);
        }
        OS.XmStringFree(xmString);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                this.error(5);
            }
            ++i;
        }
        if (items.length == 0) {
            this.removeAll();
            return;
        }
        int index = 0;
        int[] table = new int[items.length];
        String codePage = this.getCodePage();
        while (index < items.length) {
            String string = items[index];
            byte[] buffer = Converter.wcsToMbcs(codePage, this.encodeString(string), true);
            int xmString = OS.XmStringCreateLocalized(buffer);
            if (xmString == 0) break;
            table[index++] = xmString;
        }
        int ptr = OS.XtMalloc(index * 4);
        OS.memmove(ptr, table, index * 4);
        int[] argList1 = new int[]{OS.XmNitems, ptr, OS.XmNitemCount, index};
        OS.XtSetValues(this.handle, argList1, argList1.length / 2);
        int i2 = 0;
        while (i2 < index) {
            OS.XmStringFree(table[i2]);
            ++i2;
        }
        OS.XtFree(ptr);
        if (index < items.length) {
            this.error(14);
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList2 = nArray;
        OS.XtGetValues(this.handle, argList2, argList2.length / 2);
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextSetString(argList2[1], new byte[1]);
        this.display.setWarnings(warnings);
        int[] nArray2 = new int[2];
        nArray2[0] = OS.XmNlist;
        int[] argList3 = nArray2;
        OS.XtGetValues(this.handle, argList3, argList3.length / 2);
        int[] nArray3 = new int[4];
        nArray3[0] = OS.XmNselectedItemCount;
        nArray3[2] = OS.XmNselectedItems;
        int[] argList4 = nArray3;
        OS.XtSetValues(argList3[1], argList4, argList4.length / 2);
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public void setSelection(Point selection) {
        int xDisplay;
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int position = OS.XmTextGetLastPosition(argList[1]);
        if (!OS.XtIsRealized(this.handle)) {
            this.getShell().realizeWidget();
        }
        if ((xDisplay = OS.XtDisplay(argList[1])) == 0) {
            return;
        }
        int nStart = Math.min(Math.max(Math.min(selection.x, selection.y), 0), position);
        int nEnd = Math.min(Math.max(Math.max(selection.x, selection.y), 0), position);
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XmTextSetSelection(argList[1], nStart, nEnd, OS.XtLastTimestampProcessed(xDisplay));
        OS.XmTextSetInsertionPosition(argList[1], nEnd);
        this.display.setWarnings(warnings);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int index = this.indexOf(string);
            if (index != -1) {
                this.select(index);
            }
        } else {
            byte[] buffer = Converter.wcsToMbcs(this.getCodePage(), string, true);
            int xmString = OS.XmStringCreateLocalized(buffer);
            if (xmString == 0) {
                return;
            }
            int[] nArray = new int[4];
            nArray[0] = OS.XmNtextField;
            nArray[2] = OS.XmNlist;
            int[] argList = nArray;
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            int index = OS.XmListItemPos(argList[3], xmString);
            if (index > 0) {
                OS.XmComboBoxSelectItem(this.handle, xmString);
            } else {
                boolean warnings = this.display.getWarnings();
                this.display.setWarnings(false);
                OS.XmTextSetString(argList[1], buffer);
                OS.XmTextSetInsertionPosition(argList[1], 0);
                this.display.setWarnings(warnings);
            }
            OS.XmStringFree(xmString);
        }
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        OS.XmTextSetMaxLength(argList[1], limit);
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count < 0) {
            return;
        }
        this.visibleCount = count;
        int[] nArray = new int[2];
        nArray[0] = OS.XmNlist;
        int[] argList1 = nArray;
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        int[] argList2 = new int[]{OS.XmNvisibleItemCount, count};
        OS.XtSetValues(argList1[1], argList2, argList2.length / 2);
    }

    void deregister() {
        super.deregister();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNlist;
        nArray[2] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        this.display.removeWidget(argList[1]);
        this.display.removeWidget(argList[3]);
    }

    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        int[] nArray = new int[4];
        nArray[0] = OS.XmNlist;
        nArray[2] = OS.XmNtextField;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        this.enableHandle(enabled, argList[1]);
        this.enableHandle(enabled, argList[3]);
    }

    String encodeString(String string) {
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) != ' ') {
                return string;
            }
            ++i;
        }
        return String.valueOf(string) + ' ';
    }

    String decodeString(String string) {
        if (string.length() == 0) {
            return string;
        }
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) != ' ') {
                return string;
            }
            ++i;
        }
        return string.substring(0, string.length() - 1);
    }

    int XmNactivateCallback(int w, int client_data, int call_data) {
        this.postEvent(14);
        return 0;
    }

    int XmNbrowseSelectionCallback(int w, int client_data, int call_data) {
        if (this.ignoreSelect || this.getSelectionIndex() == -1) {
            return 0;
        }
        this.postEvent(13);
        return 0;
    }

    int XmNmodifyVerifyCallback(int w, int client_data, int call_data) {
        int result = super.XmNmodifyVerifyCallback(w, client_data, call_data);
        if (result != 0) {
            return result;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return result;
        }
        XmTextVerifyCallbackStruct textVerify = new XmTextVerifyCallbackStruct();
        OS.memmove(textVerify, call_data, 32);
        XmTextBlockRec textBlock = new XmTextBlockRec();
        OS.memmove(textBlock, textVerify.text, 12);
        byte[] buffer = new byte[textBlock.length];
        OS.memmove(buffer, textBlock.ptr, textBlock.length);
        String codePage = this.getCodePage();
        String text = new String(Converter.mbcsToWcs(codePage, buffer));
        Event event = new Event();
        if (textVerify.event != 0) {
            XKeyEvent xEvent = new XKeyEvent();
            OS.memmove(xEvent, textVerify.event, 60);
            event.time = xEvent.time;
            this.setKeyState(event, xEvent);
        }
        event.start = textVerify.startPos;
        event.end = textVerify.endPos;
        event.doit = textVerify.doit == 1;
        event.text = text;
        this.sendEvent(25, event);
        String newText = event.text;
        textVerify.doit = (byte)(event.doit && newText != null ? 1 : 0);
        if (newText != null && newText != text) {
            OS.XtFree(textBlock.ptr);
            byte[] buffer2 = Converter.wcsToMbcs(codePage, newText, true);
            int length = buffer2.length;
            int ptr = OS.XtMalloc(length);
            OS.memmove(ptr, buffer2, length);
            textBlock.ptr = ptr;
            textBlock.length = buffer2.length - 1;
            OS.memmove(textVerify.text, textBlock, 12);
        }
        OS.memmove(call_data, textVerify, 32);
        return result;
    }

    int XmNvalueChangedCallback(int w, int client_data, int call_data) {
        this.sendEvent(24);
        return 0;
    }
}

