/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    boolean hasLocation;
    MenuItem cascade;
    MenuItem defaultItem;
    Decorations parent;

    public Menu(Control parent) {
        this(Menu.checkNull(parent).menuShell(), 8);
    }

    public Menu(Decorations parent, int style) {
        super(parent, Menu.checkStyle(style));
        this.parent = parent;
        this.createWidget(0);
    }

    public Menu(Menu parentMenu) {
        this(Menu.checkNull((Menu)parentMenu).parent, 4);
    }

    public Menu(MenuItem parentItem) {
        this(Menu.checkNull((MenuItem)parentItem).parent);
    }

    void _setVisible(boolean visible) {
        if ((this.style & 6) != 0) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.getItemCount() != 0) {
                int xDisplay = OS.XtDisplay(this.handle);
                if (xDisplay == 0) {
                    return;
                }
                int xWindow = OS.XDefaultRootWindow(xDisplay);
                if (xWindow == 0) {
                    return;
                }
                int[] unused = new int[1];
                int[] rootX = new int[1];
                int[] rootY = new int[1];
                int[] mask = new int[1];
                if (OS.XQueryPointer(xDisplay, xWindow, unused, unused, rootX, rootY, unused, unused, mask) == 0) {
                    return;
                }
                if (!this.hasLocation) {
                    rootX[0] = rootX[0] + 1;
                    rootY[0] = rootY[0] + 1;
                    int[] argList = new int[]{OS.XmNx, rootX[0], OS.XmNy, rootY[0]};
                    OS.XtSetValues(this.handle, argList, argList.length / 2);
                }
                OS.XUngrabPointer(xDisplay, 0);
                OS.XtManageChild(this.handle);
                int flags = 1792;
                if ((mask[0] & flags) == 0) {
                    OS._XmSetMenuTraversal(this.handle, true);
                }
            } else {
                this.sendEvent(23);
            }
        } else {
            OS.XtUnmanageChild(this.handle);
        }
    }

    void addAccelerators() {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            item.addAccelerators();
            ++i;
        }
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    static int checkStyle(int style) {
        return Menu.checkBits(style, 8, 2, 4, 0, 0, 0);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    void createHandle(int index) {
        int parentHandle;
        int xDisplay = 0;
        int shellHandle = 0;
        if (Display.DisplayDisposed) {
            int[] argc = new int[1];
            int xtContext = OS.XtCreateApplicationContext();
            xDisplay = OS.XtOpenDisplay(xtContext, null, null, null, 0, 0, argc, 0);
            shellHandle = OS.XtAppCreateShell(null, null, OS.topLevelShellWidgetClass(), xDisplay, null, 0);
        }
        if ((this.style & 2) != 0) {
            int parentHandle2 = this.parent.scrolledHandle;
            int[] argList = new int[]{OS.XmNancestorSensitive, 1};
            this.handle = OS.XmCreateMenuBar(parentHandle2, null, argList, argList.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            return;
        }
        byte[] buffer = new byte[1];
        int[] argList = new int[]{OS.XmNancestorSensitive, 1};
        if ((this.style & 8) != 0) {
            parentHandle = this.parent.dialogHandle();
            this.handle = OS.XmCreatePopupMenu(parentHandle, buffer, argList, argList.length / 2);
        } else {
            parentHandle = this.parent.scrolledHandle;
            this.handle = OS.XmCreatePulldownMenu(parentHandle, buffer, argList, argList.length / 2);
        }
        if (this.handle == 0) {
            this.error(2);
        }
        if (Display.DisplayDisposed) {
            if (shellHandle != 0) {
                OS.XtDestroyWidget(shellHandle);
            }
            if (xDisplay != 0) {
                int xtContext = OS.XtDisplayToApplicationContext(xDisplay);
                OS.XtDestroyApplicationContext(xtContext);
            }
        }
    }

    void createWidget(int index) {
        this.checkOrientation(this.parent);
        super.createWidget(index);
        this.parent.addMenu(this);
    }

    Rectangle getBounds() {
        this.checkWidget();
        if (!OS.XtIsManaged(this.handle)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int[] nArray = new int[8];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        nArray[4] = OS.XmNwidth;
        nArray[6] = OS.XmNheight;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int x = argList[1];
        int y = argList[3];
        if ((this.style & 2) != 0) {
            short[] root_x = new short[1];
            short[] root_y = new short[1];
            OS.XtTranslateCoords(this.handle, (short)x, (short)x, root_x, root_y);
            x = root_x[0];
            y = root_y[0];
        }
        return new Rectangle(x, y, argList[5], argList[7]);
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return this.defaultItem;
    }

    public boolean getEnabled() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNsensitive;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1] != 0;
    }

    public MenuItem getItem(int index) {
        Widget widget;
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNchildren;
        nArray[2] = OS.XmNnumChildren;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (argList[1] == 0) {
            this.error(8);
        }
        int[] handles = new int[argList[3]];
        OS.memmove(handles, argList[1], argList[3] * 4);
        int i = 0;
        int count = 0;
        while (i < argList[3]) {
            if (OS.XtIsManaged(handles[i])) {
                if (index == count) break;
                ++count;
            }
            ++i;
        }
        if (index != count) {
            this.error(6);
        }
        if (!((widget = this.display.getWidget(handles[i])) instanceof MenuItem)) {
            this.error(8);
        }
        return (MenuItem)widget;
    }

    public int getItemCount() {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNchildren;
        nArray[2] = OS.XmNnumChildren;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (argList[1] == 0 || argList[3] == 0) {
            return 0;
        }
        int[] handles = new int[argList[3]];
        OS.memmove(handles, argList[1], argList[3] * 4);
        int count = 0;
        int i = 0;
        while (i < argList[3]) {
            if (OS.XtIsManaged(handles[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNchildren;
        nArray[2] = OS.XmNnumChildren;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int ptr = argList[1];
        int count = argList[3];
        if (count == 0 || ptr == 0) {
            return new MenuItem[0];
        }
        int[] handles = new int[count];
        OS.memmove(handles, ptr, count * 4);
        MenuItem[] items = new MenuItem[count];
        int i = 0;
        int j = 0;
        while (i < count) {
            Widget item = this.display.getWidget(handles[i]);
            if (item != null) {
                items[j++] = (MenuItem)item;
            }
            ++i;
        }
        if (i == j) {
            return items;
        }
        MenuItem[] newItems = new MenuItem[j];
        System.arraycopy(items, 0, newItems, 0, j);
        return newItems;
    }

    String getNameText() {
        String result = "";
        MenuItem[] items = this.getItems();
        int length = items.length;
        if (length > 0) {
            int i = 0;
            while (i < length - 1) {
                result = String.valueOf(result) + items[i].getNameText() + ", ";
                ++i;
            }
            result = String.valueOf(result) + items[length - 1].getNameText();
        }
        return result;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.parent;
        }
        return null;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        Menu[] popups;
        this.checkWidget();
        if ((this.style & 8) != 0 && (popups = this.display.popups) != null) {
            int i = 0;
            while (i < popups.length) {
                if (popups[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        return OS.XtIsManaged(this.handle);
    }

    void hookEvents() {
        int windowProc = this.display.windowProc;
        OS.XtAddCallback(this.handle, OS.XmNhelpCallback, windowProc, 17);
        OS.XtAddCallback(this.handle, OS.XmNmapCallback, windowProc, 28);
        OS.XtAddCallback(this.handle, OS.XmNunmapCallback, windowProc, 29);
    }

    public int indexOf(MenuItem item) {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNchildren;
        nArray[2] = OS.XmNnumChildren;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int[] handles = new int[argList[3]];
        OS.memmove(handles, argList[1], handles.length * 4);
        int index = 0;
        int i = 0;
        while (i < handles.length) {
            if (OS.XtIsManaged(handles[i])) {
                if (handles[i] == item.handle) {
                    return index;
                }
                ++index;
            }
            ++i;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu parentMenu = this.getParentMenu();
        if (parentMenu == null) {
            return this.getEnabled();
        }
        return this.getEnabled() && parentMenu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void releaseChildren(boolean destroy) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.parent != null) {
            this.parent.removeMenu(this);
        }
        this.parent = null;
        this.defaultItem = null;
        this.cascade = null;
    }

    void removeAccelerators() {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            item.removeAccelerators();
            ++i;
        }
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, listener);
        this.eventTable.unhook(22, listener);
    }

    void sendHelpEvent(int callData) {
        if (this.hooks(28)) {
            this.postEvent(28);
            return;
        }
        this.parent.sendHelpEvent(callData);
    }

    public void setDefaultItem(MenuItem item) {
        this.checkWidget();
        if (item != null && item.isDisposed()) {
            this.error(5);
        }
        this.defaultItem = item;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNsensitive, enabled ? 1 : 0};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNx, x, OS.XmNy, y};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        this.hasLocation = true;
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (visible) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
            this._setVisible(false);
        }
    }

    boolean translateAccelerator(int accel, boolean doit) {
        if (!this.getEnabled()) {
            return false;
        }
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            if (item.translateAccelerator(accel, doit)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int XmNhelpCallback(int w, int client_data, int call_data) {
        this.sendHelpEvent(call_data);
        return 0;
    }

    int XmNmapCallback(int w, int client_data, int call_data) {
        if ((this.style & 8) != 0) {
            return 0;
        }
        this.sendEvent(22);
        return 0;
    }

    int XmNunmapCallback(int w, int client_data, int call_data) {
        this.sendEvent(23);
        return 0;
    }
}

