/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui;

import java.io.File;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.internal.ui.MIUIMessages;
import org.eclipse.cdt.debug.mi.ui.IMILaunchConfigurationComponent;
import org.eclipse.cdt.debug.mi.ui.MIUIUtils;
import org.eclipse.cdt.debug.ui.AbstractCDebuggerPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class GDBDebuggerPage
extends AbstractCDebuggerPage
implements Observer {
    private static final String DEFAULT_MI_PROTOCOL = MIUIMessages.getString("GDBDebuggerPage.12");
    protected final String[] protocolItems = new String[]{DEFAULT_MI_PROTOCOL, "mi1", "mi2", "mi3"};
    protected TabFolder fTabFolder;
    protected Text fGDBCommandText;
    protected Text fGDBInitText;
    protected Combo fProtocolCombo;
    private IMILaunchConfigurationComponent fSolibBlock;
    private boolean fIsInitializing = false;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        this.fTabFolder = new TabFolder(comp, 0);
        this.fTabFolder.setLayoutData((Object)new GridData(1808));
        this.createTabs(this.fTabFolder);
        this.fTabFolder.setSelection(0);
        this.setControl((Control)parent);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_PROTOCOL, "mi");
        if (this.fSolibBlock != null) {
            this.fSolibBlock.setDefaults(configuration);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean valid;
        boolean bl = valid = this.fGDBCommandText.getText().length() != 0;
        if (valid) {
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage(MIUIMessages.getString("GDBDebuggerPage.0"));
            this.setMessage(null);
        }
        return valid;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setInitializing(true);
        String gdbCommand = "gdb";
        String gdbInit = ".gdbinit";
        try {
            gdbCommand = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
        }
        catch (CoreException coreException) {}
        try {
            gdbInit = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
        }
        catch (CoreException coreException) {}
        String miVersion = MIPlugin.getMIVersion((ILaunchConfiguration)configuration);
        if (miVersion.compareTo("mi") == 0) {
            miVersion = DEFAULT_MI_PROTOCOL;
        }
        if (this.fSolibBlock != null) {
            this.fSolibBlock.initializeFrom(configuration);
        }
        this.fGDBCommandText.setText(gdbCommand);
        this.fGDBInitText.setText(gdbInit);
        int index = 0;
        if (miVersion.length() > 0) {
            int i = 0;
            while (i < this.protocolItems.length) {
                if (this.protocolItems[i].equals(miVersion)) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        this.fProtocolCombo.select(index);
        this.setInitializing(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String str = this.fGDBCommandText.getText();
        str.trim();
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, str);
        str = this.fGDBInitText.getText();
        str.trim();
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, str);
        str = this.fProtocolCombo.getText();
        if (str.compareTo(DEFAULT_MI_PROTOCOL) == 0) {
            str = "mi";
        }
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_PROTOCOL, str);
        if (this.fSolibBlock != null) {
            this.fSolibBlock.performApply(configuration);
        }
    }

    public String getName() {
        return MIUIMessages.getString("GDBDebuggerPage.1");
    }

    protected Shell getShell() {
        return super.getShell();
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public void update(Observable o, Object arg) {
        if (!this.isInitializing()) {
            this.updateLaunchConfigurationDialog();
        }
    }

    public IMILaunchConfigurationComponent createSolibBlock(Composite parent) {
        IMILaunchConfigurationComponent block = MIUIUtils.createGDBSolibBlock(true, true);
        block.createControl(parent);
        return block;
    }

    public void createTabs(TabFolder tabFolder) {
        this.createMainTab(tabFolder);
        this.createSolibTab(tabFolder);
    }

    public void createMainTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(MIUIMessages.getString("GDBDebuggerPage.2"));
        Composite comp = ControlFactory.createCompositeEx((Composite)tabFolder, (int)1, (int)1808);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        comp.setFont(tabFolder.getFont());
        tabItem.setControl((Control)comp);
        Composite subComp = ControlFactory.createCompositeEx((Composite)comp, (int)3, (int)768);
        ((GridLayout)subComp.getLayout()).makeColumnsEqualWidth = false;
        subComp.setFont(tabFolder.getFont());
        Label label = ControlFactory.createLabel((Composite)subComp, (String)MIUIMessages.getString("GDBDebuggerPage.3"));
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGDBCommandText = ControlFactory.createTextField((Composite)subComp, (int)2052);
        this.fGDBCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                if (!GDBDebuggerPage.this.isInitializing()) {
                    GDBDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
        Button button = this.createPushButton(subComp, MIUIMessages.getString("GDBDebuggerPage.4"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleGDBButtonSelected();
                GDBDebuggerPage.this.updateLaunchConfigurationDialog();
            }

            private void handleGDBButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(GDBDebuggerPage.this.getShell(), 0);
                dialog.setText(MIUIMessages.getString("GDBDebuggerPage.5"));
                String gdbCommand = GDBDebuggerPage.this.fGDBCommandText.getText().trim();
                int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                GDBDebuggerPage.this.fGDBCommandText.setText(res);
            }
        });
        label = ControlFactory.createLabel((Composite)subComp, (String)MIUIMessages.getString("GDBDebuggerPage.6"));
        gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGDBInitText = ControlFactory.createTextField((Composite)subComp, (int)2052);
        gd = new GridData(768);
        this.fGDBInitText.setLayoutData((Object)gd);
        this.fGDBInitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                if (!GDBDebuggerPage.this.isInitializing()) {
                    GDBDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
        button = this.createPushButton(subComp, MIUIMessages.getString("GDBDebuggerPage.7"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleGDBInitButtonSelected();
                GDBDebuggerPage.this.updateLaunchConfigurationDialog();
            }

            private void handleGDBInitButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(GDBDebuggerPage.this.getShell(), 0);
                dialog.setText(MIUIMessages.getString("GDBDebuggerPage.8"));
                String gdbCommand = GDBDebuggerPage.this.fGDBInitText.getText().trim();
                int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                GDBDebuggerPage.this.fGDBInitText.setText(res);
            }
        });
        label = ControlFactory.createLabel((Composite)subComp, (String)MIUIMessages.getString("GDBDebuggerPage.9"), (int)200, (int)-1, (int)64);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.widthHint = 200;
        label.setLayoutData((Object)gd);
        this.createProtocolCombo(subComp);
    }

    public void createSolibTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(MIUIMessages.getString("GDBDebuggerPage.10"));
        Composite comp = ControlFactory.createCompositeEx((Composite)this.fTabFolder, (int)1, (int)1808);
        comp.setFont(tabFolder.getFont());
        tabItem.setControl((Control)comp);
        this.fSolibBlock = this.createSolibBlock(comp);
        if (this.fSolibBlock instanceof Observable) {
            ((Observable)((Object)this.fSolibBlock)).addObserver(this);
        }
    }

    public void dispose() {
        if (this.fSolibBlock != null) {
            if (this.fSolibBlock instanceof Observable) {
                ((Observable)((Object)this.fSolibBlock)).deleteObserver(this);
            }
            this.fSolibBlock.dispose();
        }
        super.dispose();
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    protected boolean isInitializing() {
        return this.fIsInitializing;
    }

    private void setInitializing(boolean isInitializing) {
        this.fIsInitializing = isInitializing;
    }

    protected void createProtocolCombo(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(MIUIMessages.getString("GDBDebuggerPage.11"));
        this.fProtocolCombo = new Combo(parent, 12);
        this.fProtocolCombo.setItems(this.protocolItems);
        this.fProtocolCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (!GDBDebuggerPage.this.isInitializing()) {
                    GDBDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }

            public void widgetSelected(SelectionEvent e) {
                if (!GDBDebuggerPage.this.isInitializing()) {
                    GDBDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
    }
}

