/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.photran.internal.core.lexer.FixedFormLexerPhase2;
import org.eclipse.photran.internal.core.lexer.FreeFormLexerPhase1;
import org.eclipse.photran.internal.core.lexer.FreeFormLexerPhase2;
import org.eclipse.photran.internal.core.lexer.IAccumulatingLexer;
import org.eclipse.photran.internal.core.lexer.IncludeLoaderCallback;
import org.eclipse.photran.internal.core.lexer.LexerPhase3;
import org.eclipse.photran.internal.core.lexer.PreprocessingFreeFormLexerPhase1;

public abstract class SourceForm {
    public static final SourceForm UNPREPROCESSED_FREE_FORM = new SourceForm(){

        IAccumulatingLexer createLexer(InputStream in, String filename) throws IOException {
            return new LexerPhase3(new FreeFormLexerPhase2(new FreeFormLexerPhase1(in, filename)));
        }
    };
    public static final SourceForm FIXED_FORM = new SourceForm(){

        IAccumulatingLexer createLexer(InputStream in, String filename) throws IOException {
            return new LexerPhase3(new FixedFormLexerPhase2(in, filename));
        }
    };
    public static final SourceForm AUTO_DETECT_SOURCE_FORM = UNPREPROCESSED_FREE_FORM;

    private SourceForm() {
    }

    abstract IAccumulatingLexer createLexer(InputStream var1, String var2) throws IOException;

    public static SourceForm preprocessedFreeForm(final IncludeLoaderCallback callback) {
        return new SourceForm(){

            IAccumulatingLexer createLexer(InputStream in, String filename) throws IOException {
                return new LexerPhase3(new FreeFormLexerPhase2(new PreprocessingFreeFormLexerPhase1(in, filename, callback)));
            }
        };
    }

    /* synthetic */ SourceForm(SourceForm sourceForm) {
        this();
    }
}

