/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.PrintStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.photran.core.util.OffsetLength;
import org.eclipse.photran.internal.core.parser.ASTVisitor;
import org.eclipse.photran.internal.core.parser.AbstractParseTreeNode;
import org.eclipse.photran.internal.core.parser.GenericParseTreeVisitor;
import org.eclipse.photran.internal.core.parser.ParseTreeVisitor;
import org.eclipse.photran.internal.core.parser.ParserSymbol;
import org.eclipse.photran.internal.core.parser.Terminal;

public class Token
extends AbstractParseTreeNode
implements ParserSymbol {
    protected Terminal terminal = null;
    protected String whiteBefore = "";
    protected String text = "";
    protected String whiteAfter = "";
    protected String preprocessorDirective = null;
    protected IFile file = null;
    protected int line = -1;
    protected int col = -1;
    protected int fileOffset = -1;
    protected int streamOffset = -1;
    protected int length = -1;
    protected Object binding = null;
    protected Object scope = null;

    public Token(Terminal terminal, String whiteBefore, String tokenText, String whiteAfter) {
        this.terminal = terminal;
        this.whiteBefore = whiteBefore == null ? "" : whiteBefore;
        this.text = tokenText == null ? "" : tokenText;
        this.whiteAfter = whiteAfter == null ? "" : whiteAfter;
    }

    public Token(Terminal terminal, String tokenText) {
        this(terminal, null, tokenText, null);
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public void setTerminal(Terminal value) {
        this.terminal = value;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String value) {
        this.text = value == null ? "" : value;
    }

    public String getWhiteBefore() {
        return this.whiteBefore;
    }

    public void setWhiteBefore(String value) {
        this.whiteBefore = value == null ? "" : value;
    }

    public String getWhiteAfter() {
        return this.whiteAfter;
    }

    public void setWhiteAfter(String value) {
        this.whiteAfter = value == null ? "" : value;
    }

    public String getPreprocessorDirective() {
        return this.preprocessorDirective;
    }

    public void setPreprocessorDirective(String preprocessorDirective) {
        this.preprocessorDirective = preprocessorDirective;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public IFile getFile() {
        return this.file;
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public int getFileOffset() {
        return this.fileOffset;
    }

    public void setFileOffset(int fileOffset) {
        this.fileOffset = fileOffset;
    }

    public int getStreamOffset() {
        return this.streamOffset;
    }

    public void setStreamOffset(int streamOffset) {
        this.streamOffset = streamOffset;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public Object getBinding() {
        return this.binding;
    }

    public void setBinding(Object binding) {
        this.binding = binding;
    }

    public Object getScope() {
        return this.scope;
    }

    public void setScope(Object scope) {
        this.scope = scope;
    }

    public boolean containsFileOffset(OffsetLength other) {
        return OffsetLength.contains(this.fileOffset, this.length, other);
    }

    public boolean isOnOrAfterFileOffset(int targetOffset) {
        return this.fileOffset >= targetOffset;
    }

    public boolean containsStreamOffset(OffsetLength other) {
        return OffsetLength.contains(this.streamOffset, this.length, other);
    }

    public boolean isOnOrAfterStreamOffset(int targetOffset) {
        return this.streamOffset >= targetOffset;
    }

    public void visitTopDownUsing(ASTVisitor visitor) {
        visitor.visitToken(this);
    }

    public void visitBottomUpUsing(ASTVisitor visitor) {
        visitor.visitToken(this);
    }

    public void visitUsing(ParseTreeVisitor visitor) {
    }

    public void visitUsing(GenericParseTreeVisitor visitor) {
        visitor.visitToken(this);
    }

    public String toString(int numSpaces) {
        return String.valueOf(this.indent(numSpaces)) + this.getDescription() + "\n";
    }

    public String getDescription() {
        return String.valueOf(this.terminal.getDescription()) + ": \"" + this.text + "\"";
    }

    public String printOn(PrintStream out, String currentPreprocessorDirective) {
        if (this.preprocessorDirective != currentPreprocessorDirective) {
            if (this.preprocessorDirective != null) {
                out.print(this.whiteBefore);
                out.print(this.preprocessorDirective);
            }
            currentPreprocessorDirective = this.preprocessorDirective;
        }
        if (currentPreprocessorDirective == null && this.preprocessorDirective == null) {
            out.print(this.whiteBefore);
            out.print(this.text);
            out.print(this.whiteAfter);
        }
        return currentPreprocessorDirective;
    }
}

