/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.util.Iterator;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.GenericParseTreeVisitor;

public class TokenList {
    private Token[] array = new Token[4096];
    private int size = 0;

    public TokenList() {
    }

    public TokenList(ASTExecutableProgramNode ast) {
        this();
        ast.visitUsing(new GenericParseTreeVisitor(){

            public void visitToken(Token token) {
                TokenList.this.add(token);
            }
        });
    }

    public void add(Token token) {
        this.ensureCapacity();
        this.array[this.size++] = token;
    }

    private void ensureCapacity() {
        if (this.size == this.array.length) {
            this.expandArray();
        }
    }

    private void expandArray() {
        Token[] newTokenArray = new Token[this.array.length * 2];
        System.arraycopy(this.array, 0, newTokenArray, 0, this.array.length);
        this.array = newTokenArray;
    }

    public void add(int index, Token token) {
        if (index < 0 || index > this.size) {
            throw new IllegalArgumentException("Invalid index " + index);
        }
        this.ensureCapacity();
        int i = this.size;
        while (i >= index) {
            this.array[i + 1] = this.array[i];
            --i;
        }
        this.array[index] = token;
        ++this.size;
    }

    public boolean remove(Token tokenToRemove) {
        int index = this.find(tokenToRemove);
        return index < 0 ? false : this.remove(index);
    }

    public boolean remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("Invalid index " + index);
        }
        int i = index + 1;
        while (i < this.size) {
            this.array[i - 1] = this.array[i];
            ++i;
        }
        --this.size;
        return true;
    }

    public Token get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("Invalid index " + index);
        }
        return this.array[index];
    }

    public int find(Token token) {
        int i = 0;
        while (i < this.size) {
            if (this.array[i].equals(token)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Token findStreamOffsetLength(int offset, int length) {
        int low = 0;
        int high = this.size - 1;
        int mid = (high + low) / 2;
        while (low <= high) {
            int value = this.array[mid].getStreamOffset();
            if (offset > value) {
                low = mid + 1;
            } else if (offset < value) {
                high = mid - 1;
            } else {
                return this.array[mid].getLength() == length ? this.array[mid] : null;
            }
            mid = (high + low) / 2;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Token findFirstTokenOnLine(int line) {
        index = this.findIndexOfAnyTokenOnLine(line);
        if (index >= 0) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            --index;
lbl5:
            // 2 sources

            ** while (index > 0 && this.array[index - 1].getLine() == line)
        }
lbl6:
        // 1 sources

        return this.array[index];
    }

    private int findIndexOfAnyTokenOnLine(int line) {
        int low = 0;
        int high = this.size - 1;
        int mid = (high + low) / 2;
        while (low <= high) {
            int value = this.array[mid].getLine();
            if (line > value) {
                low = mid + 1;
            } else if (line < value) {
                high = mid - 1;
            } else {
                return mid;
            }
            mid = (high + low) / 2;
        }
        return -1;
    }

    public Iterator iterator() {
        return new Iterator(){
            int index = 0;

            public boolean hasNext() {
                return this.index < TokenList.this.size;
            }

            public Object next() {
                return this.index < TokenList.this.size ? TokenList.this.array[this.index++] : null;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

