/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.parser;

import java.util.ArrayList;
import org.eclipse.photran.internal.core.lexer.ILexer;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ErrorRecovery;
import org.eclipse.photran.internal.core.parser.Nonterminal;
import org.eclipse.photran.internal.core.parser.ParsingTable;
import org.eclipse.photran.internal.core.parser.Productions;

public class Parser {
    protected ILexer lexer;
    protected boolean doneParsing;
    protected boolean error;
    protected int currentState;
    protected Token lookaheadToken;
    protected ArrayList symbolStack;
    protected ArrayList stateStack;
    protected ArrayList valueStack;
    protected ErrorRecovery errorRecovery;
    protected Productions productions;
    protected ParsingTable parsingTable;

    public ASTExecutableProgramNode parse(ILexer lexicalAnalyzer) throws Exception {
        this.productions = Productions.getInstance();
        this.errorRecovery = new ErrorRecovery(this);
        this.lexer = lexicalAnalyzer;
        this.parsingTable = ParsingTable.getInstance();
        this.symbolStack = new ArrayList();
        this.stateStack = new ArrayList();
        this.valueStack = new ArrayList();
        this.productions.initialize();
        this.currentState = 0;
        this.stateStack.add(new Integer(this.currentState));
        this.readNextToken();
        this.doneParsing = false;
        this.error = false;
        while (!this.doneParsing) {
            this.parsingTable.processLookaheadFor(this);
        }
        this.productions.deinitialize();
        return this.error || this.valueStack.isEmpty() ? null : (ASTExecutableProgramNode)this.valueStack.get(this.valueStack.size() - 1);
    }

    void readNextToken() throws Exception {
        this.lookaheadToken = this.lexer.yylex();
    }

    void shiftAndGoToState(int state) throws Exception {
        this.symbolStack.add(this.lookaheadToken.getTerminal());
        this.stateStack.add(new Integer(state));
        this.valueStack.add(this.lookaheadToken);
        this.currentState = state;
        this.readNextToken();
    }

    void reduce(Nonterminal nonterminalToReduceTo, int symbolsToPop) {
        int i = 0;
        while (i < symbolsToPop) {
            this.symbolStack.remove(this.symbolStack.size() - 1);
            this.stateStack.remove(this.stateStack.size() - 1);
            ++i;
        }
        this.currentState = (Integer)this.stateStack.get(this.stateStack.size() - 1);
        this.symbolStack.add(nonterminalToReduceTo);
        this.stateStack.add(new Integer(this.parsingTable.getGoToFor(nonterminalToReduceTo, this)));
        this.currentState = (Integer)this.stateStack.get(this.stateStack.size() - 1);
    }

    void reduce(Nonterminal nonterminalToReduceTo, int symbolsToPop, Object nonterminalValue) {
        int i = 0;
        while (i < symbolsToPop) {
            this.symbolStack.remove(this.symbolStack.size() - 1);
            this.stateStack.remove(this.stateStack.size() - 1);
            ++i;
        }
        this.currentState = (Integer)this.stateStack.get(this.stateStack.size() - 1);
        this.symbolStack.add(nonterminalToReduceTo);
        this.valueStack.add(nonterminalValue);
        this.stateStack.add(new Integer(this.parsingTable.getGoToFor(nonterminalToReduceTo, this)));
        this.currentState = (Integer)this.stateStack.get(this.stateStack.size() - 1);
    }

    void accept() {
        this.doneParsing = true;
    }

    void syntaxError() throws Exception {
        throw new Exception(this.getErrorMessage());
    }

    Token getLookaheadToken() {
        return this.lookaheadToken;
    }

    ArrayList getSymbolStack() {
        return this.symbolStack;
    }

    ArrayList getStateStack() {
        return this.stateStack;
    }

    ArrayList getValueStack() {
        return this.valueStack;
    }

    Productions getProductions() {
        return this.productions;
    }

    protected String getErrorMessage() {
        return "Syntax error (" + this.lexer.getFilename() + ", line " + this.lexer.getLastTokenLine() + ", column " + this.lexer.getLastTokenCol() + ": Unexpected " + this.lookaheadToken.getTerminal().getDescription() + " \"" + this.lookaheadToken.getText() + "\"";
    }

    int getCurrentState() {
        return this.currentState;
    }
}

