/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.c.ICPointerType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;

public class CPointerType
implements ICPointerType,
ITypeContainer {
    public static final int IS_CONST = 1;
    public static final int IS_RESTRICT = 2;
    public static final int IS_VOLATILE = 4;
    IType nextType = null;
    private int qualifiers = 0;

    public CPointerType() {
    }

    public CPointerType(IType next, int qualifiers) {
        this.nextType = next;
        this.qualifiers = qualifiers;
    }

    public boolean isSameType(IType obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ITypedef) {
            return obj.isSameType(this);
        }
        if (obj instanceof ICPointerType) {
            ICPointerType pt;
            block10: {
                block9: {
                    block8: {
                        pt = (ICPointerType)obj;
                        try {
                            if (this.isConst() == pt.isConst()) break block8;
                            return false;
                        }
                        catch (DOMException dOMException) {
                            return false;
                        }
                    }
                    if (this.isRestrict() == pt.isRestrict()) break block9;
                    return false;
                }
                if (this.isVolatile() == pt.isVolatile()) break block10;
                return false;
            }
            return pt.getType().isSameType(this.nextType);
        }
        return false;
    }

    public boolean isRestrict() {
        return (this.qualifiers & 2) != 0;
    }

    public IType getType() {
        return this.nextType;
    }

    public void setType(IType type) {
        this.nextType = type;
    }

    public boolean isConst() {
        return (this.qualifiers & 1) != 0;
    }

    public boolean isVolatile() {
        return (this.qualifiers & 4) != 0;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public void setQualifiers(int qualifiers) {
        this.qualifiers = qualifiers;
    }
}

