/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.c.CASTVisitor;
import org.eclipse.cdt.core.dom.ast.c.ICScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTName;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;

public class CScope
implements ICScope {
    public static final int NAMESPACE_TYPE_TAG = 0;
    public static final int NAMESPACE_TYPE_OTHER = 1;
    private IASTNode physicalNode = null;
    private boolean isFullyCached = false;
    private CharArrayObjectMap[] bindings = new CharArrayObjectMap[]{CharArrayObjectMap.EMPTY_MAP, CharArrayObjectMap.EMPTY_MAP};
    static /* synthetic */ Class class$0;

    public CScope(IASTNode physical) {
        this.physicalNode = physical;
    }

    public IScope getParent() {
        return CVisitor.getContainingScope(this.physicalNode);
    }

    public IBinding[] find(String name) throws DOMException {
        return CVisitor.findBindings(this, name);
    }

    public IBinding getBinding(int namespaceType, char[] name) {
        IASTName n = (IASTName)this.bindings[namespaceType].get(name);
        return n != null ? n.resolveBinding() : null;
    }

    public void removeBinding(IBinding binding) {
        int type;
        int n = type = binding instanceof ICompositeType || binding instanceof IEnumeration ? 0 : 1;
        if (this.bindings[type] != CharArrayObjectMap.EMPTY_MAP) {
            this.bindings[type].remove(binding.getNameCharArray(), 0, binding.getNameCharArray().length);
        }
        this.isFullyCached = false;
    }

    public IASTNode getPhysicalNode() {
        return this.physicalNode;
    }

    public void addName(IASTName name) {
        char[] n;
        IASTName current;
        int type = this.getNamespaceType(name);
        if (this.bindings[type] == CharArrayObjectMap.EMPTY_MAP) {
            this.bindings[type] = new CharArrayObjectMap(1);
        }
        if ((current = (IASTName)this.bindings[type].get(n = name.toCharArray())) == null || ((CASTName)current).getOffset() > ((CASTName)name).getOffset()) {
            this.bindings[type].put(n, name);
        }
    }

    private int getNamespaceType(IASTName name) {
        ASTNodeProperty prop = name.getPropertyInParent();
        if (prop == IASTCompositeTypeSpecifier.TYPE_NAME || prop == IASTElaboratedTypeSpecifier.TYPE_NAME || prop == IASTEnumerationSpecifier.ENUMERATION_NAME || prop == CVisitor.STRING_LOOKUP_TAGS_PROPERTY) {
            return 0;
        }
        return 1;
    }

    public IBinding getBinding(IASTName name, boolean resolve) {
        char[] c = name.toCharArray();
        if (c.length == 0) {
            return null;
        }
        int type = this.getNamespaceType(name);
        Object o = this.bindings[type].get(name.toCharArray());
        if (o == null) {
            return null;
        }
        if (o instanceof IBinding) {
            return (IBinding)o;
        }
        if ((resolve || ((IASTName)o).getBinding() != null) && o != name) {
            return ((IASTName)o).resolveBinding();
        }
        return null;
    }

    public void setFullyCached(boolean b) {
        this.isFullyCached = b;
    }

    public boolean isFullyCached() {
        return this.isFullyCached;
    }

    public IASTName getScopeName() {
        if (this.physicalNode instanceof IASTCompositeTypeSpecifier) {
            return ((IASTCompositeTypeSpecifier)this.physicalNode).getName();
        }
        return null;
    }

    public void flushCache() {
        this.bindings[0].clear();
        this.bindings[1].clear();
        this.isFullyCached = false;
    }

    public void addBinding(IBinding binding) {
        int type = 1;
        if (binding instanceof ICompositeType || binding instanceof IEnumeration) {
            type = 0;
        }
        if (this.bindings[type] == CharArrayObjectMap.EMPTY_MAP) {
            this.bindings[type] = new CharArrayObjectMap(2);
        }
        this.bindings[type].put(binding.getNameCharArray(), binding);
    }

    protected static class CollectNamesAction
    extends CASTVisitor {
        private char[] name;
        private IASTName[] result = null;

        CollectNamesAction(char[] n) {
            this.name = n;
            this.shouldVisitNames = true;
        }

        public int visit(IASTName n) {
            ASTNodeProperty prop = n.getPropertyInParent();
            if ((prop == IASTElaboratedTypeSpecifier.TYPE_NAME || prop == IASTCompositeTypeSpecifier.TYPE_NAME || prop == IASTDeclarator.DECLARATOR_NAME) && CharArrayUtils.equals(n.toCharArray(), this.name)) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.result = (IASTName[])ArrayUtil.append(clazz, this.result, n);
            }
            return 3;
        }

        public int visit(IASTStatement statement) {
            if (statement instanceof IASTDeclarationStatement) {
                return 3;
            }
            return 1;
        }

        public IASTName[] getNames() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IASTName[])ArrayUtil.trim(clazz, this.result);
        }
    }
}

