/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPDelegate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.core.runtime.PlatformObject;

public class CPPTypedef
extends PlatformObject
implements ITypedef,
ITypeContainer,
ICPPInternalBinding {
    private IASTName[] declarations = null;
    private IType type = null;
    static /* synthetic */ Class class$0;

    public CPPTypedef(IASTName name) {
        this.declarations = new IASTName[]{name};
        if (name != null) {
            name.setBinding(this);
        }
    }

    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    public IASTNode getDefinition() {
        return this.declarations[0];
    }

    public boolean isSameType(IType o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ITypedef) {
            try {
                IType t = this.getType();
                if (t != null) {
                    return t.isSameType(((ITypedef)o).getType());
                }
                return false;
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        IType t = this.getType();
        if (t != null) {
            return t.isSameType(o);
        }
        return false;
    }

    public IType getType() {
        if (this.type == null) {
            this.type = CPPVisitor.createType((IASTDeclarator)this.declarations[0].getParent());
        }
        return this.type;
    }

    public void setType(IType t) {
        this.type = t;
    }

    public String getName() {
        return this.declarations[0].toString();
    }

    public char[] getNameCharArray() {
        return this.declarations[0].toCharArray();
    }

    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.declarations[0].getParent());
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    public ICPPDelegate createDelegate(IASTName name) {
        return new CPPTypedefDelegate(name, this);
    }

    public void addDefinition(IASTNode node) {
        this.addDeclaration(node);
    }

    public void addDeclaration(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTName name = (IASTName)node;
        if (this.declarations == null) {
            this.declarations = new IASTName[]{name};
        } else if (this.declarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)((Object)this.declarations[0])).getOffset()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declarations = (IASTName[])ArrayUtil.prepend(clazz, this.declarations, name);
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declarations = (IASTName[])ArrayUtil.append(clazz, this.declarations, name);
        }
    }

    public void removeDeclaration(IASTNode node) {
        if (this.declarations != null) {
            int i = 0;
            while (i < this.declarations.length) {
                if (node == this.declarations[i]) {
                    if (i == this.declarations.length - 1) {
                        this.declarations[i] = null;
                    } else {
                        System.arraycopy(this.declarations, i + 1, this.declarations, i, this.declarations.length - 1 - i);
                    }
                    return;
                }
                ++i;
            }
        }
    }

    public static class CPPTypedefDelegate
    extends CPPDelegate
    implements ITypedef,
    ITypeContainer {
        public CPPTypedefDelegate(IASTName name, ITypedef binding) {
            super(name, binding);
        }

        public IType getType() throws DOMException {
            return ((ITypedef)this.getBinding()).getType();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public boolean isSameType(IType type) {
            return ((ITypedef)this.getBinding()).isSameType(type);
        }

        public void setType(IType type) {
            ((ITypeContainer)((Object)this.getBinding())).setType(type);
        }
    }
}

