/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IIncludeFileEntry;
import org.eclipse.cdt.core.model.ILibraryEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IMacroFileEntry;
import org.eclipse.cdt.core.model.IOutputEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.model.IProjectEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.resources.IPathEntryVariableManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CoreModelMessages;
import org.eclipse.cdt.internal.core.model.PathEntry;
import org.eclipse.cdt.internal.core.model.PathEntryManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PathEntryUtil {
    static PathEntryManager manager = PathEntryManager.getDefault();
    static final IMarker[] NO_MARKERS = new IMarker[0];

    private PathEntryUtil() {
    }

    public static IPathEntry getExpandedPathEntry(IPathEntry entry, ICProject cproject) throws CModelException {
        switch (entry.getEntryKind()) {
            case 16: {
                IIncludeEntry includeEntry = (IIncludeEntry)entry;
                IPath refPath = includeEntry.getBaseReference();
                if (refPath == null || refPath.isEmpty()) break;
                IPath includePath = includeEntry.getIncludePath();
                if (refPath.isAbsolute()) {
                    ICProject refCProject;
                    IProject project;
                    IResource res = cproject.getCModel().getWorkspace().getRoot().findMember(refPath);
                    if (res == null || res.getType() != 4 || !CoreModel.hasCNature(project = (IProject)res) && !CoreModel.hasCCNature(project) || (refCProject = CoreModel.getDefault().create(project)) == null) break;
                    IPathEntry[] entries = manager.getResolvedPathEntries(refCProject);
                    int i = 0;
                    while (i < entries.length) {
                        IIncludeEntry refEntry;
                        if (entries[i].getEntryKind() == 16 && (refEntry = (IIncludeEntry)entries[i]).getIncludePath().equals((Object)includePath)) {
                            IPath newBasePath = refEntry.getBasePath();
                            if (!newBasePath.isAbsolute() && !includePath.isAbsolute()) {
                                IResource refRes;
                                if (!newBasePath.isEmpty()) {
                                    refRes = cproject.getCModel().getWorkspace().getRoot().findMember(newBasePath);
                                } else {
                                    IPath refResPath = refEntry.getPath();
                                    refRes = cproject.getCModel().getWorkspace().getRoot().findMember(refResPath);
                                }
                                if (refRes != null) {
                                    if (refRes.getType() == 1) {
                                        refRes = refRes.getParent();
                                    }
                                    newBasePath = refRes.getLocation().append(newBasePath);
                                }
                            }
                            return CoreModel.newIncludeEntry(includeEntry.getPath(), newBasePath, includePath);
                        }
                        ++i;
                    }
                } else {
                    IPathEntryContainer container = manager.getPathEntryContainer(refPath, cproject);
                    if (container == null) break;
                    IPathEntry[] entries = container.getPathEntries();
                    int i = 0;
                    while (i < entries.length) {
                        IIncludeEntry refEntry;
                        if (entries[i].getEntryKind() == 16 && (refEntry = (IIncludeEntry)entries[i]).getIncludePath().equals((Object)includePath)) {
                            IPath newBasePath = refEntry.getBasePath();
                            return CoreModel.newIncludeEntry(includeEntry.getPath(), newBasePath, includePath);
                        }
                        ++i;
                    }
                }
                break;
            }
            case 64: {
                IMacroEntry macroEntry = (IMacroEntry)entry;
                IPath refPath = macroEntry.getBaseReference();
                if (refPath == null || refPath.isEmpty()) break;
                String name = macroEntry.getMacroName();
                if (refPath.isAbsolute()) {
                    ICProject refCProject;
                    IProject project;
                    IResource res = cproject.getCModel().getWorkspace().getRoot().findMember(refPath);
                    if (res == null || res.getType() != 4 || !CoreModel.hasCNature(project = (IProject)res) && !CoreModel.hasCCNature(project) || (refCProject = CoreModel.getDefault().create(project)) == null) break;
                    IPathEntry[] entries = manager.getResolvedPathEntries(refCProject);
                    int i = 0;
                    while (i < entries.length) {
                        IMacroEntry refEntry;
                        if (entries[i].getEntryKind() == 64 && (refEntry = (IMacroEntry)entries[i]).getMacroName().equals(name)) {
                            String value = refEntry.getMacroValue();
                            return CoreModel.newMacroEntry(macroEntry.getPath(), name, value);
                        }
                        ++i;
                    }
                } else {
                    IPathEntryContainer container = manager.getPathEntryContainer(refPath, cproject);
                    if (container == null) break;
                    IPathEntry[] entries = container.getPathEntries();
                    int i = 0;
                    while (i < entries.length) {
                        IMacroEntry refEntry;
                        if (entries[i].getEntryKind() == 64 && (refEntry = (IMacroEntry)entries[i]).getMacroName().equals(name)) {
                            String value = refEntry.getMacroValue();
                            return CoreModel.newMacroEntry(macroEntry.getPath(), name, value);
                        }
                        ++i;
                    }
                }
                break;
            }
            case 1: {
                ILibraryEntry libEntry = (ILibraryEntry)entry;
                IPath refPath = libEntry.getBaseReference();
                if (refPath == null || refPath.isEmpty()) break;
                IPath libraryPath = libEntry.getLibraryPath();
                if (refPath.isAbsolute()) {
                    ICProject refCProject;
                    IProject project;
                    IResource res = cproject.getCModel().getWorkspace().getRoot().findMember(refPath);
                    if (res == null || res.getType() != 4 || !CoreModel.hasCNature(project = (IProject)res) && !CoreModel.hasCCNature(project) || (refCProject = CoreModel.getDefault().create(project)) == null) break;
                    IPathEntry[] entries = manager.getResolvedPathEntries(refCProject);
                    int i = 0;
                    while (i < entries.length) {
                        ILibraryEntry refEntry;
                        if (entries[i].getEntryKind() == 1 && (refEntry = (ILibraryEntry)entries[i]).getLibraryPath().equals((Object)libraryPath)) {
                            IPath newBasePath = refEntry.getBasePath();
                            if (!newBasePath.isAbsolute() && !libraryPath.isAbsolute()) {
                                IResource refRes;
                                if (!newBasePath.isEmpty()) {
                                    refRes = cproject.getCModel().getWorkspace().getRoot().findMember(newBasePath);
                                } else {
                                    IPath refResPath = refEntry.getPath();
                                    refRes = cproject.getCModel().getWorkspace().getRoot().findMember(refResPath);
                                }
                                if (refRes != null) {
                                    if (refRes.getType() == 1) {
                                        refRes = refRes.getParent();
                                    }
                                    newBasePath = refRes.getLocation().append(newBasePath);
                                }
                            }
                            return CoreModel.newLibraryEntry(entry.getPath(), newBasePath, refEntry.getLibraryPath(), refEntry.getSourceAttachmentPath(), refEntry.getSourceAttachmentRootPath(), refEntry.getSourceAttachmentPrefixMapping(), false);
                        }
                        ++i;
                    }
                } else {
                    IPathEntryContainer container = manager.getPathEntryContainer(refPath, cproject);
                    if (container == null) break;
                    IPathEntry[] entries = container.getPathEntries();
                    int i = 0;
                    while (i < entries.length) {
                        ILibraryEntry refEntry;
                        if (entries[i].getEntryKind() == 1 && (refEntry = (ILibraryEntry)entries[i]).getPath().equals((Object)libraryPath)) {
                            return CoreModel.newLibraryEntry(entry.getPath(), refEntry.getBasePath(), refEntry.getLibraryPath(), refEntry.getSourceAttachmentPath(), refEntry.getSourceAttachmentRootPath(), refEntry.getSourceAttachmentPrefixMapping(), false);
                        }
                        ++i;
                    }
                }
                break;
            }
        }
        return entry;
    }

    public static IPathEntry cloneEntryAndExpand(IPath rpath, IPathEntry entry) {
        IPath entryPath = entry.getPath();
        if (entryPath == null) {
            entryPath = Path.EMPTY;
        }
        IPath resourcePath = entryPath.isAbsolute() ? entryPath : rpath.append(entryPath);
        IPathEntryVariableManager varManager = CCorePlugin.getDefault().getPathEntryVariableManager();
        switch (entry.getEntryKind()) {
            case 16: {
                IIncludeEntry include = (IIncludeEntry)entry;
                IPath basePath = include.getBasePath();
                basePath = varManager.resolvePath(basePath);
                IPath includePath = include.getIncludePath();
                includePath = varManager.resolvePath(includePath);
                return CoreModel.newIncludeEntry(resourcePath, basePath, includePath, include.isSystemInclude(), include.getExclusionPatterns(), include.isExported());
            }
            case 256: {
                IIncludeFileEntry includeFile = (IIncludeFileEntry)entry;
                IPath basePath = includeFile.getBasePath();
                basePath = varManager.resolvePath(basePath);
                IPath includeFilePath = includeFile.getIncludeFilePath();
                includeFilePath = varManager.resolvePath(includeFilePath);
                return CoreModel.newIncludeFileEntry(resourcePath, basePath, (IPath)Path.EMPTY, includeFilePath, includeFile.getExclusionPatterns(), includeFile.isExported());
            }
            case 1: {
                ILibraryEntry library = (ILibraryEntry)entry;
                IPath basePath = library.getBasePath();
                basePath = varManager.resolvePath(basePath);
                IPath libraryPath = library.getLibraryPath();
                libraryPath = varManager.resolvePath(libraryPath);
                IPath sourceAttachmentPath = library.getSourceAttachmentPath();
                sourceAttachmentPath = varManager.resolvePath(sourceAttachmentPath);
                IPath sourceAttachmentRootPath = library.getSourceAttachmentRootPath();
                sourceAttachmentRootPath = varManager.resolvePath(sourceAttachmentRootPath);
                IPath sourceAttachmentPrefixMapping = library.getSourceAttachmentPrefixMapping();
                sourceAttachmentPrefixMapping = varManager.resolvePath(sourceAttachmentPrefixMapping);
                return CoreModel.newLibraryEntry(resourcePath, basePath, libraryPath, sourceAttachmentPath, sourceAttachmentRootPath, sourceAttachmentPrefixMapping, library.isExported());
            }
            case 64: {
                IMacroEntry macro = (IMacroEntry)entry;
                return CoreModel.newMacroEntry(resourcePath, macro.getMacroName(), macro.getMacroValue(), macro.getExclusionPatterns(), macro.isExported());
            }
            case 512: {
                IMacroFileEntry macroFile = (IMacroFileEntry)entry;
                IPath basePath = macroFile.getBasePath();
                basePath = varManager.resolvePath(basePath);
                IPath macroFilePath = macroFile.getMacroFilePath();
                macroFilePath = varManager.resolvePath(macroFilePath);
                return CoreModel.newMacroFileEntry(resourcePath, basePath, (IPath)Path.EMPTY, macroFilePath, macroFile.getExclusionPatterns(), macroFile.isExported());
            }
            case 128: {
                IOutputEntry out = (IOutputEntry)entry;
                return CoreModel.newOutputEntry(resourcePath, out.getExclusionPatterns());
            }
            case 4: {
                IProjectEntry projEntry = (IProjectEntry)entry;
                return CoreModel.newProjectEntry(projEntry.getPath(), projEntry.isExported());
            }
            case 8: {
                ISourceEntry source = (ISourceEntry)entry;
                return CoreModel.newSourceEntry(resourcePath, source.getExclusionPatterns());
            }
            case 32: {
                return CoreModel.newContainerEntry(entry.getPath(), entry.isExported());
            }
        }
        return entry;
    }

    public static ICModelStatus validatePathEntry(ICProject cProject, IPathEntry[] entries) {
        StringBuffer errMesg;
        int i;
        ICModelStatus[] cmodelStatus;
        int i2 = 0;
        while (i2 < entries.length) {
            IPathEntry entry = entries[i2];
            if (entry != null) {
                int j = 0;
                while (j < entries.length) {
                    IPathEntry otherEntry = entries[j];
                    if (otherEntry != null && entry != otherEntry && otherEntry.equals(entry)) {
                        StringBuffer errMesg2 = new StringBuffer(CCorePlugin.getResourceString("CoreModel.PathEntry.DuplicateEntry"));
                        return new CModelStatus(964, errMesg2.toString());
                    }
                    ++j;
                }
            }
            ++i2;
        }
        List dups = PathEntryUtil.checkForDuplication(Arrays.asList(entries), 8);
        if (dups.size() > 0) {
            cmodelStatus = new ICModelStatus[dups.size()];
            i = 0;
            while (i < dups.size()) {
                errMesg = new StringBuffer(CCorePlugin.getResourceString("CoreModel.PathEntry.DuplicateEntry"));
                cmodelStatus[i] = new CModelStatus(964, errMesg.toString());
                ++i;
            }
            return CModelStatus.newMultiStatus(964, cmodelStatus);
        }
        dups = PathEntryUtil.checkForDuplication(Arrays.asList(entries), 128);
        if (dups.size() > 0) {
            cmodelStatus = new ICModelStatus[dups.size()];
            i = 0;
            while (i < dups.size()) {
                errMesg = new StringBuffer(CCorePlugin.getResourceString("CoreModel.PathEntry.DuplicateEntry"));
                cmodelStatus[i] = new CModelStatus(977, errMesg.toString());
                ++i;
            }
            return CModelStatus.newMultiStatus(964, cmodelStatus);
        }
        int i3 = 0;
        while (i3 < entries.length) {
            IPathEntry entry = entries[i3];
            if (entry != null) {
                IPath entryPath = entry.getPath();
                int kind = entry.getEntryKind();
                if (kind == 8) {
                    int j = 0;
                    while (j < entries.length) {
                        IPathEntry otherEntry = entries[j];
                        if (otherEntry != null) {
                            int otherKind = otherEntry.getEntryKind();
                            IPath otherPath = otherEntry.getPath();
                            if (entry != otherEntry && otherKind == 8) {
                                char[][] exclusionPatterns = ((ISourceEntry)otherEntry).fullExclusionPatternChars();
                                if (otherPath.isPrefixOf(entryPath) && !otherPath.equals((Object)entryPath) && !CoreModelUtil.isExcluded(entryPath.append("*"), exclusionPatterns)) {
                                    String exclusionPattern = entryPath.removeFirstSegments(otherPath.segmentCount()).segment(0);
                                    if (CoreModelUtil.isExcluded(entryPath, exclusionPatterns)) {
                                        StringBuffer errMesg3 = new StringBuffer(CCorePlugin.getResourceString("CoreModel.PathEntry.NestedEntry"));
                                        return new CModelStatus(964, errMesg3.toString());
                                    }
                                    if (otherKind == 8) {
                                        exclusionPattern = String.valueOf(exclusionPattern) + '/';
                                        StringBuffer errMesg4 = new StringBuffer(CCorePlugin.getResourceString("CoreModel.PathEntry.NestedEntry"));
                                        return new CModelStatus(964, errMesg4.toString());
                                    }
                                    StringBuffer errMesg5 = new StringBuffer(CCorePlugin.getResourceString("CoreModel.PathEntry.NestedEntry"));
                                    return new CModelStatus(964, errMesg5.toString());
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i3;
        }
        return CModelStatus.VERIFIED_OK;
    }

    public static ICModelStatus validatePathEntry(ICProject cProject, IPathEntry entry, boolean checkSourceAttachment, boolean recurseInContainers) {
        IProject project = cProject.getProject();
        IPath path = entry.getPath();
        if (entry.getEntryKind() != 4 && entry.getEntryKind() != 32 && !PathEntryUtil.isValidWorkspacePath(project, path)) {
            return new CModelStatus(964, CoreModelMessages.getFormattedString("PathEntryManager.0", new Object[]{path.toOSString(), ((PathEntry)entry).getKindString()}));
        }
        switch (entry.getEntryKind()) {
            case 16: {
                IIncludeEntry include = (IIncludeEntry)entry;
                IPath includePath = include.getFullIncludePath();
                if (!PathEntryUtil.isValidExternalPath(includePath)) {
                    return new CModelStatus(964, CoreModelMessages.getFormattedString("PathEntryManager.2", includePath.toOSString()));
                }
                if (PathEntryUtil.isValidBasePath(include.getBasePath())) break;
                return new CModelStatus(964, CoreModelMessages.getFormattedString("PathEntryManager.1", includePath.toOSString()));
            }
            case 1: {
                IPath sourceAttach;
                ILibraryEntry library = (ILibraryEntry)entry;
                if (!(!checkSourceAttachment || (sourceAttach = library.getSourceAttachmentPath()) == null || sourceAttach.isAbsolute() || PathEntryUtil.isValidWorkspacePath(project, sourceAttach) && PathEntryUtil.isValidExternalPath(sourceAttach))) {
                    return new CModelStatus(964, CoreModelMessages.getFormattedString("PathEntryManager.3", sourceAttach.toOSString()));
                }
                IPath libraryPath = library.getFullLibraryPath();
                if (!PathEntryUtil.isValidExternalPath(libraryPath)) {
                    return new CModelStatus(964, CoreModelMessages.getFormattedString("PathEntryManager.4", libraryPath.toOSString()));
                }
                if (PathEntryUtil.isValidBasePath(library.getBasePath())) break;
                return new CModelStatus(964, CoreModelMessages.getFormattedString("PathEntryManager.7", libraryPath.toOSString()));
            }
            case 4: {
                IProjectEntry projEntry = (IProjectEntry)entry;
                path = projEntry.getPath();
                IProject reqProject = project.getWorkspace().getRoot().getProject(path.segment(0));
                if (!reqProject.isAccessible()) {
                    return new CModelStatus(964, CoreModelMessages.getString("PathEntryManager.5"));
                }
                if (CoreModel.hasCNature(reqProject) || CoreModel.hasCCNature(reqProject)) break;
                return new CModelStatus(964, CoreModelMessages.getString("PathEntryManager.6"));
            }
            case 32: {
                if (!recurseInContainers) break;
                try {
                    IPathEntryContainer cont = manager.getPathEntryContainer((IContainerEntry)entry, cProject);
                    IPathEntry[] contEntries = cont.getPathEntries();
                    int i = 0;
                    while (i < contEntries.length) {
                        ICModelStatus status = PathEntryUtil.validatePathEntry(cProject, contEntries[i], checkSourceAttachment, false);
                        if (!status.isOK()) {
                            return status;
                        }
                        ++i;
                    }
                    break;
                }
                catch (CModelException e) {
                    return new CModelStatus(e);
                }
            }
        }
        return CModelStatus.VERIFIED_OK;
    }

    private static boolean isValidWorkspacePath(IProject project, IPath path) {
        if (path == null) {
            return false;
        }
        IWorkspaceRoot workspaceRoot = project.getWorkspace().getRoot();
        IResource res = null;
        res = path.isAbsolute() ? workspaceRoot.findMember(path) : project.findMember(path);
        return res != null && res.isAccessible();
    }

    private static boolean isValidExternalPath(IPath path) {
        File file;
        if (path != null && (file = path.toFile()) != null) {
            return file.exists();
        }
        return false;
    }

    private static boolean isValidBasePath(IPath path) {
        IResource res;
        return path.isEmpty() || path.isAbsolute() || (res = ResourcesPlugin.getWorkspace().getRoot().findMember(path)) != null && res.isAccessible();
    }

    public static List checkForDuplication(List pathEntries, int type) {
        ArrayList<IPathEntry> duplicate = new ArrayList<IPathEntry>(pathEntries.size());
        int i = 0;
        while (i < pathEntries.size()) {
            IPathEntry pathEntry = (IPathEntry)pathEntries.get(i);
            if (pathEntry.getEntryKind() == type) {
                int j = 0;
                while (j < pathEntries.size()) {
                    IPathEntry otherEntry = (IPathEntry)pathEntries.get(j);
                    if (otherEntry.getEntryKind() == type && !pathEntry.equals(otherEntry) && !duplicate.contains(pathEntry) && pathEntry.getPath().equals((Object)otherEntry.getPath())) {
                        duplicate.add(otherEntry);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return duplicate;
    }

    public static void createPathEntryProblemMarker(IProject project, ICModelStatus status) {
        int severity = PathEntryUtil.code2Severity(status);
        try {
            IMarker marker = project.createMarker("org.eclipse.cdt.core.pathentry_problem");
            marker.setAttributes(new String[]{"message", "severity", "location", "pathEntryFileFormat"}, new Object[]{status.getMessage(), new Integer(severity), "pathentry", "false"});
        }
        catch (CoreException coreException) {}
    }

    public static void flushPathEntryProblemMarkers(IProject project) {
        IWorkspace workspace = project.getWorkspace();
        try {
            IMarker[] markers = PathEntryUtil.getPathEntryProblemMarkers(project);
            workspace.deleteMarkers(markers);
        }
        catch (CoreException coreException) {}
    }

    public static IMarker[] getPathEntryProblemMarkers(IProject project) {
        try {
            IMarker[] markers = project.findMarkers("org.eclipse.cdt.core.pathentry_problem", false, 0);
            if (markers != null) {
                return markers;
            }
        }
        catch (CoreException coreException) {}
        return NO_MARKERS;
    }

    public static boolean hasPathEntryProblemMarkersChange(IProject project, ICModelStatus[] status) {
        IMarker[] markers = PathEntryUtil.getPathEntryProblemMarkers(project);
        if (markers.length != status.length) {
            return true;
        }
        int i = 0;
        while (i < markers.length) {
            boolean found = false;
            String message = markers[i].getAttribute("message", "");
            int severity = markers[i].getAttribute("severity", 2);
            int j = 0;
            while (j < status.length) {
                String msg = status[j].getMessage();
                int cseverity = PathEntryUtil.code2Severity(status[j]);
                if (msg.equals(message) && severity == cseverity) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int code2Severity(ICModelStatus status) {
        int severity;
        switch (status.getCode()) {
            case 964: {
                severity = 1;
                break;
            }
            case 979: {
                severity = 1;
                break;
            }
            default: {
                severity = 2;
            }
        }
        return severity;
    }
}

