/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.extension.ExtensionDialect;
import org.eclipse.cdt.core.parser.extension.IASTFactoryExtension;
import org.eclipse.cdt.core.parser.extension.IParserExtension;
import org.eclipse.cdt.core.parser.extension.IParserExtensionFactory;
import org.eclipse.cdt.internal.core.parser.GCCParserExtension;
import org.eclipse.cdt.internal.core.parser.ast.GCCASTExtension;

public class ParserExtensionFactory
implements IParserExtensionFactory {
    private final ExtensionDialect dialect;

    public ParserExtensionFactory(ExtensionDialect dialect) {
        this.dialect = dialect;
    }

    public IParserExtension createParserExtension() throws ParserFactoryError {
        if (this.dialect == ExtensionDialect.GCC) {
            return new GCCParserExtension();
        }
        throw new ParserFactoryError(ParserFactoryError.Kind.BAD_DIALECT);
    }

    public IASTFactoryExtension createASTExtension(ParserMode mode) {
        if (this.dialect == ExtensionDialect.GCC) {
            return GCCASTExtension.createExtension(mode);
        }
        throw new ParserFactoryError(ParserFactoryError.Kind.BAD_DIALECT);
    }
}

