/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNode;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;

public class ASTSimpleTypeSpecifier
extends ASTNode
implements IASTSimpleTypeSpecifier {
    private final List refs;
    private ISymbol symbol;
    private final boolean isTypename;
    private final char[] name;

    public ASTSimpleTypeSpecifier(ISymbol s, boolean b, char[] string, List references) {
        this.symbol = s;
        this.isTypename = b;
        this.name = string;
        this.refs = references;
    }

    public IASTSimpleTypeSpecifier.Type getType() {
        if (this.symbol.getType() == ITypeInfo.t_int) {
            return IASTSimpleTypeSpecifier.Type.INT;
        }
        if (this.symbol.getType() == ITypeInfo.t_double) {
            return IASTSimpleTypeSpecifier.Type.DOUBLE;
        }
        if (this.symbol.getType() == ITypeInfo.t_float) {
            return IASTSimpleTypeSpecifier.Type.FLOAT;
        }
        if (this.symbol.getType() == ITypeInfo.t_bool) {
            return IASTSimpleTypeSpecifier.Type.BOOL;
        }
        if (this.symbol.getType() == ITypeInfo.t_type) {
            return IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME;
        }
        if (this.symbol.getType() == ITypeInfo.t_char) {
            return IASTSimpleTypeSpecifier.Type.CHAR;
        }
        if (this.symbol.getType() == ITypeInfo.t_void) {
            return IASTSimpleTypeSpecifier.Type.VOID;
        }
        if (this.symbol.getType() == ITypeInfo.t_wchar_t) {
            return IASTSimpleTypeSpecifier.Type.WCHAR_T;
        }
        if (this.symbol.getType() == ITypeInfo.t__Bool) {
            return IASTSimpleTypeSpecifier.Type._BOOL;
        }
        return IASTSimpleTypeSpecifier.Type.UNSPECIFIED;
    }

    public String getTypename() {
        return String.valueOf(this.name);
    }

    public boolean isLong() {
        return this.symbol.getTypeInfo().checkBit(16384);
    }

    public boolean isShort() {
        return this.symbol.getTypeInfo().checkBit(8192);
    }

    public boolean isSigned() {
        return this.symbol.getTypeInfo().checkBit(524288);
    }

    public boolean isUnsigned() {
        return this.symbol.getTypeInfo().checkBit(4096);
    }

    public boolean isTypename() {
        return this.isTypename;
    }

    public ISymbol getSymbol() {
        return this.symbol;
    }

    public List getReferences() {
        return this.refs == null ? Collections.EMPTY_LIST : this.refs;
    }

    public IASTTypeSpecifier getTypeSpecifier() {
        return (IASTTypeSpecifier)((Object)this.getSymbol().getTypeSymbol().getASTExtension().getPrimaryDeclaration());
    }

    public boolean isComplex() {
        return this.symbol.getTypeInfo().checkBit(65536);
    }

    public boolean isImaginary() {
        return this.symbol.getTypeInfo().checkBit(131072);
    }

    public void releaseReferences() {
        if (this.refs == null || this.refs.isEmpty()) {
            return;
        }
        this.refs.clear();
    }
}

