/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.quick.ASTDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.quick.IASTQScope;

public class ASTNamespaceDefinition
extends ASTDeclaration
implements IASTNamespaceDefinition,
IASTQScope {
    private final char[] name;
    private final ASTQualifiedNamedElement qualifiedNameElement;
    private final char[] fn;
    private List declarations = new ArrayList();
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTNamespaceDefinition(IASTScope scope, char[] name, int startOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, char[] filename) {
        super(scope);
        this.qualifiedNameElement = new ASTQualifiedNamedElement(scope, name);
        this.name = name;
        this.setStartingOffsetAndLineNumber(startOffset, startingLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameEndOffset);
        this.fn = filename;
    }

    public String getName() {
        return String.valueOf(this.name);
    }

    public Iterator getDeclarations() {
        return this.declarations.iterator();
    }

    public void addDeclaration(IASTDeclaration declaration) {
        this.declarations.add(declaration);
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedNameElement.getFullyQualifiedName();
    }

    public char[][] getFullyQualifiedNameCharArrays() {
        return this.qualifiedNameElement.getFullyQualifiedNameCharArrays();
    }

    public void acceptElement(ISourceElementRequestor requestor) {
    }

    public void enterScope(ISourceElementRequestor requestor) {
        try {
            requestor.enterNamespaceDefinition(this);
        }
        catch (Exception exception) {}
    }

    public void exitScope(ISourceElementRequestor requestor) {
        try {
            requestor.exitNamespaceDefinition(this);
        }
        catch (Exception exception) {}
    }

    public final int getStartingLine() {
        return this.startingLineNumber;
    }

    public final int getEndingLine() {
        return this.endingLineNumber;
    }

    public final int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public final void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public final void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public final int getStartingOffset() {
        return this.startingOffset;
    }

    public final int getEndingOffset() {
        return this.endingOffset;
    }

    public final int getNameOffset() {
        return this.nameStartOffset;
    }

    public final void setNameOffset(int o) {
        this.nameStartOffset = o;
    }

    public final int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public final void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.nameEndOffset = offset;
        this.nameLineNumber = lineNumber;
    }

    public char[] getNameCharArray() {
        return this.name;
    }
}

