/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ICodeReaderCache;
import org.eclipse.cdt.core.parser.IMacro;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectStyleMacro;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMInclude;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacro;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PDOMCodeReaderFactory
implements ICodeReaderFactory {
    private final PDOM pdom;
    private List workingCopies = new ArrayList(1);
    private Map fileCache = new HashMap();
    private Map macroCache = new HashMap();
    private List usedMacros = new ArrayList();
    private static final char[] EMPTY_CHARS = new char[0];

    public PDOMCodeReaderFactory(PDOM pdom) {
        this.pdom = pdom;
    }

    public PDOMCodeReaderFactory(PDOM pdom, IWorkingCopy workingCopy) {
        this(pdom);
        this.workingCopies.add(workingCopy);
    }

    public PDOMFile getCachedFile(String filename) throws CoreException {
        PDOMFile file = (PDOMFile)this.fileCache.get(filename);
        if (file == null) {
            file = this.pdom.addFile(filename);
            this.fileCache.put(filename, file);
        }
        return file;
    }

    public int getUniqueIdentifier() {
        return 0;
    }

    public CodeReader createCodeReaderForTranslationUnit(String path) {
        return ParserUtil.createReader(path, this.workingCopies != null ? this.workingCopies.iterator() : null);
    }

    public CodeReader createCodeReaderForTranslationUnit(ITranslationUnit tu) {
        return new CodeReader(tu.getResource().getLocation().toOSString(), tu.getContents());
    }

    private void fillMacros(PDOMFile file, IScanner scanner, Set visited) throws CoreException {
        Integer record = new Integer(file.getRecord());
        if (visited.contains(record)) {
            return;
        }
        visited.add(record);
        PDOMInclude include = file.getFirstInclude();
        while (include != null) {
            this.fillMacros(include.getIncludes(), scanner, visited);
            include = include.getNextInIncludes();
        }
        IMacro[] macros = (IMacro[])this.macroCache.get(record);
        if (macros == null) {
            ArrayList<IMacro> macroList = new ArrayList<IMacro>();
            PDOMMacro macro = file.getFirstMacro();
            while (macro != null) {
                macroList.add(macro.getMacro());
                macro = macro.getNextMacro();
            }
            macros = macroList.toArray(new IMacro[macroList.size()]);
            this.macroCache.put(record, macros);
        }
        int i = 0;
        while (i < macros.length) {
            scanner.addDefinition(macros[i]);
            ++i;
        }
        this.usedMacros.add(macros);
    }

    public CodeReader createCodeReaderForInclusion(IScanner scanner, String path) {
        Object file;
        block7: {
            file = new File(path);
            if (((File)file).exists()) break block7;
            return null;
        }
        try {
            try {
                path = ((File)file).getCanonicalPath();
            }
            catch (IOException iOException) {}
            file = (PDOMFile)this.fileCache.get(path);
            if (file == null && (file = this.pdom.getFile(path)) != null) {
                this.fileCache.put(path, file);
            }
            if (file != null) {
                this.fillMacros((PDOMFile)file, scanner, new HashSet());
                return new CodeReader(path, EMPTY_CHARS);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 0, "PDOM Exception", (Throwable)e)));
        }
        return ParserUtil.createReader(path, null);
    }

    public void clearMacros() {
        Iterator i = this.usedMacros.iterator();
        while (i.hasNext()) {
            IMacro[] macros = (IMacro[])i.next();
            int j = 0;
            while (j < macros.length) {
                if (macros[j] instanceof ObjectStyleMacro) {
                    ((ObjectStyleMacro)macros[j]).attachment = null;
                }
                ++j;
            }
        }
        this.usedMacros.clear();
    }

    public ICodeReaderCache getCodeReaderCache() {
        return null;
    }
}

