/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import org.eclipse.cdt.internal.core.pdom.db.Chunk;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.core.runtime.CoreException;

public class BTree {
    protected final Database db;
    protected final int rootPointer;
    protected static final int NUM_RECORDS = 15;
    protected static final int MEDIAN_RECORD = 7;
    protected static final int NUM_CHILDREN = 16;
    protected static final int OFFSET_CHILDREN = 60;

    public BTree(Database db, int rootPointer) {
        this.db = db;
        this.rootPointer = rootPointer;
    }

    protected int getRoot() throws CoreException {
        return this.db.getInt(this.rootPointer);
    }

    protected final void putRecord(Chunk chunk, int node, int index, int record) throws CoreException {
        chunk.putInt(node + index * 4, record);
    }

    protected final int getRecord(Chunk chunk, int node, int index) throws CoreException {
        return chunk.getInt(node + index * 4);
    }

    protected final void putChild(Chunk chunk, int node, int index, int child) throws CoreException {
        chunk.putInt(node + 60 + index * 4, child);
    }

    protected final int getChild(Chunk chunk, int node, int index) throws CoreException {
        return chunk.getInt(node + 60 + index * 4);
    }

    public int insert(int record, IBTreeComparator comparator) throws CoreException {
        int root = this.getRoot();
        if (root == 0) {
            this.firstInsert(record);
            return record;
        }
        return this.insert(null, 0, 0, root, record, comparator);
    }

    private int insert(Chunk pChunk, int parent, int iParent, int node, int record, IBTreeComparator comparator) throws CoreException {
        int child;
        Chunk chunk = this.db.getChunk(node);
        if (this.getRecord(chunk, node, 14) != 0) {
            int median = this.getRecord(chunk, node, 7);
            if (median == record) {
                return median;
            }
            int newnode = this.allocateNode();
            Chunk newchunk = this.db.getChunk(newnode);
            int i = 0;
            while (i < 7) {
                this.putRecord(newchunk, newnode, i, this.getRecord(chunk, node, 8 + i));
                this.putRecord(chunk, node, 8 + i, 0);
                this.putChild(newchunk, newnode, i, this.getChild(chunk, node, 8 + i));
                this.putChild(chunk, node, 8 + i, 0);
                ++i;
            }
            this.putChild(newchunk, newnode, 7, this.getChild(chunk, node, 15));
            this.putChild(chunk, node, 15, 0);
            if (parent == 0) {
                parent = this.allocateNode();
                pChunk = this.db.getChunk(parent);
                this.db.putInt(this.rootPointer, parent);
                this.putChild(pChunk, parent, 0, node);
            } else {
                i = 13;
                while (i >= iParent) {
                    int r = this.getRecord(pChunk, parent, i);
                    if (r != 0) {
                        this.putRecord(pChunk, parent, i + 1, r);
                        this.putChild(pChunk, parent, i + 2, this.getChild(pChunk, parent, i + 1));
                    }
                    --i;
                }
            }
            this.putRecord(pChunk, parent, iParent, median);
            this.putChild(pChunk, parent, iParent + 1, newnode);
            this.putRecord(chunk, node, 7, 0);
            if (comparator.compare(record, median) > 0) {
                node = newnode;
                chunk = newchunk;
            }
        }
        int i = 0;
        while (i < 15) {
            int record1 = this.getRecord(chunk, node, i);
            if (record1 == 0) break;
            int compare = comparator.compare(record1, record);
            if (compare == 0) {
                return record;
            }
            if (compare > 0) break;
            ++i;
        }
        if ((child = this.getChild(chunk, node, i)) != 0) {
            return this.insert(chunk, node, i, child, record, comparator);
        }
        int j = 13;
        while (j >= i) {
            int r = this.getRecord(chunk, node, j);
            if (r != 0) {
                this.putRecord(chunk, node, j + 1, r);
            }
            --j;
        }
        this.putRecord(chunk, node, i, record);
        return record;
    }

    private void firstInsert(int record) throws CoreException {
        int root = this.allocateNode();
        this.db.putInt(this.rootPointer, root);
        this.putRecord(this.db.getChunk(root), root, 0, record);
    }

    private int allocateNode() throws CoreException {
        return this.db.malloc(124);
    }

    public void delete(int record) {
    }

    public void accept(IBTreeVisitor visitor) throws CoreException {
        this.accept(this.db.getInt(this.rootPointer), visitor, false);
    }

    private boolean accept(int node, IBTreeVisitor visitor, boolean found) throws CoreException {
        int child;
        if (node == 0) {
            return visitor.visit(0);
        }
        Chunk chunk = this.db.getChunk(node);
        if (found && (child = this.getChild(chunk, node, 0)) != 0 && !this.accept(child, visitor, true)) {
            return false;
        }
        int i = 0;
        while (i < 15) {
            int record = this.getRecord(chunk, node, i);
            if (record == 0) break;
            if (found) {
                if (!visitor.visit(record)) {
                    return false;
                }
                if (!this.accept(this.getChild(chunk, node, i + 1), visitor, true)) {
                    return false;
                }
            } else {
                int compare = visitor.compare(record);
                if (compare > 0) {
                    if (!this.accept(this.getChild(chunk, node, i), visitor, false)) {
                        return false;
                    }
                    if (!visitor.visit(record)) {
                        return false;
                    }
                    if (!this.accept(this.getChild(chunk, node, i + 1), visitor, true)) {
                        return false;
                    }
                    found = true;
                } else if (compare == 0) {
                    if (!visitor.visit(record)) {
                        return false;
                    }
                    if (!this.accept(this.getChild(chunk, node, i + 1), visitor, true)) {
                        return false;
                    }
                    found = true;
                }
            }
            ++i;
        }
        if (!found) {
            return this.accept(this.getChild(chunk, node, i), visitor, false);
        }
        return true;
    }
}

