/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

public abstract class PDOMNamedNode
extends PDOMNode {
    private static final int NAME = 8;
    protected static final int RECORD_SIZE = 12;

    public PDOMNamedNode(PDOM pdom, int record) {
        super(pdom, record);
    }

    public PDOMNamedNode(PDOM pdom, PDOMNode parent, char[] name) throws CoreException {
        super(pdom, parent);
        Database db = pdom.getDB();
        db.putInt(this.record + 8, name != null ? db.newString(name).getRecord() : 0);
        if (parent != null) {
            parent.addChild(this);
        }
    }

    protected int getRecordSize() {
        return 12;
    }

    public IString getDBName() throws CoreException {
        Database db = this.pdom.getDB();
        int namerec = db.getInt(this.record + 8);
        return db.getString(namerec);
    }

    public char[] getNameCharArray() throws CoreException {
        return this.getDBName().getChars();
    }

    public boolean hasName(char[] name) throws CoreException {
        return this.getDBName().equals(name);
    }

    public IBTreeComparator getIndexComparator() {
        return new IBTreeComparator(){

            public int compare(int record1, int record2) throws CoreException {
                Database db = PDOMNamedNode.this.pdom.getDB();
                int string1 = db.getInt(record1 + 8);
                int string2 = db.getInt(record2 + 8);
                return db.getString(string1).compare(db.getString(string2));
            }
        };
    }

    public static abstract class NodeFinder
    implements IBTreeVisitor {
        protected final PDOM pdom;
        protected final char[] name;

        protected NodeFinder(PDOM pdom, char[] name) {
            this.pdom = pdom;
            this.name = name;
        }

        public int compare(int record) throws CoreException {
            Database db = this.pdom.getDB();
            int namerec = db.getInt(record + 8);
            return db.getString(namerec).compare(this.name);
        }
    }
}

