/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.gnu.c.GCCLanguage;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCEnumeration;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCEnumerator;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCField;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCFunction;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCStructure;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCTypedef;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCVariable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;

public class PDOMCLinkage
extends PDOMLinkage {
    public static final int CVARIABLE = 3;
    public static final int CFUNCTION = 4;
    public static final int CSTRUCTURE = 5;
    public static final int CFIELD = 6;
    public static final int CENUMERATION = 7;
    public static final int CENUMERATOR = 8;
    public static final int CTYPEDEF = 9;

    public PDOMCLinkage(PDOM pdom, int record) {
        super(pdom, record);
    }

    public PDOMCLinkage(PDOM pdom) throws CoreException {
        super(pdom, "org.eclipse.cdt.core.gcc", "C".toCharArray());
    }

    public int getNodeType() {
        return 0;
    }

    public ILanguage getLanguage() {
        return new GCCLanguage();
    }

    public PDOMNode getParent(IBinding binding) throws CoreException {
        IBinding scopeBinding;
        PDOMBinding scopePDOMBinding;
        IScope scope = binding.getScope();
        if (scope == null) {
            return null;
        }
        IASTNode scopeNode = scope.getPhysicalNode();
        if (scopeNode instanceof IASTCompoundStatement) {
            return null;
        }
        if (scopeNode instanceof IASTTranslationUnit) {
            return this;
        }
        IASTName scopeName = scope.getScopeName();
        if (scopeName != null && (scopePDOMBinding = this.adaptBinding(scopeBinding = scopeName.resolveBinding())) != null) {
            return scopePDOMBinding;
        }
        return null;
    }

    public PDOMBinding addName(IASTName name, PDOMFile file) throws CoreException {
        if (name == null) {
            return null;
        }
        char[] namechars = name.toCharArray();
        if (namechars == null || name.toCharArray().length == 0) {
            return null;
        }
        IBinding binding = name.resolveBinding();
        if (binding == null || binding instanceof IProblemBinding) {
            return null;
        }
        if (binding instanceof IParameter) {
            return null;
        }
        PDOMBinding pdomBinding = this.adaptBinding(binding);
        if (pdomBinding == null) {
            PDOMNode parent = this.getParent(binding);
            if (parent == null) {
                return null;
            }
            if (binding instanceof IParameter) {
                return null;
            }
            if (binding instanceof IField) {
                if (parent instanceof PDOMMemberOwner) {
                    pdomBinding = new PDOMCField(this.pdom, (PDOMMemberOwner)parent, name);
                }
            } else if (binding instanceof IVariable) {
                pdomBinding = new PDOMCVariable(this.pdom, parent, name);
            } else if (binding instanceof IFunction) {
                pdomBinding = new PDOMCFunction(this.pdom, parent, name);
            } else if (binding instanceof ICompositeType) {
                pdomBinding = new PDOMCStructure(this.pdom, parent, name);
            } else if (binding instanceof IEnumeration) {
                pdomBinding = new PDOMCEnumeration(this.pdom, parent, name);
            } else if (binding instanceof IEnumerator) {
                IEnumeration enumeration = (IEnumeration)((IEnumerator)binding).getType();
                PDOMBinding pdomEnumeration = this.adaptBinding(enumeration);
                if (pdomEnumeration instanceof PDOMCEnumeration) {
                    pdomBinding = new PDOMCEnumerator(this.pdom, parent, name, (PDOMCEnumeration)pdomEnumeration);
                }
            } else if (binding instanceof ITypedef) {
                pdomBinding = new PDOMCTypedef(this.pdom, parent, name, (ITypedef)binding);
            }
        }
        if (pdomBinding != null) {
            new PDOMName(this.pdom, name, file, pdomBinding);
        }
        return pdomBinding;
    }

    protected int getBindingType(IBinding binding) {
        if (binding instanceof IField) {
            return 6;
        }
        if (binding instanceof IVariable) {
            return 3;
        }
        if (binding instanceof IFunction) {
            return 4;
        }
        if (binding instanceof ICompositeType) {
            return 5;
        }
        if (binding instanceof IEnumeration) {
            return 7;
        }
        if (binding instanceof IEnumerator) {
            return 8;
        }
        if (binding instanceof ITypedef) {
            return 9;
        }
        return 0;
    }

    public PDOMBinding adaptBinding(IBinding binding) throws CoreException {
        if (binding instanceof PDOMBinding) {
            return (PDOMBinding)binding;
        }
        PDOMNode parent = this.getParent(binding);
        if (parent == this) {
            FindBinding visitor = new FindBinding(this.pdom, binding.getNameCharArray(), this.getBindingType(binding));
            this.getIndex().accept(visitor);
            return visitor.pdomBinding;
        }
        if (parent instanceof PDOMMemberOwner) {
            FindBinding2 visitor = new FindBinding2(binding.getNameCharArray(), this.getBindingType(binding));
            PDOMMemberOwner owner = (PDOMMemberOwner)parent;
            try {
                owner.accept(visitor);
            }
            catch (CoreException e) {
                if (e.getStatus().equals(Status.OK_STATUS)) {
                    return visitor.getBinding();
                }
                throw e;
            }
        }
        return null;
    }

    public PDOMNode getNode(int record) throws CoreException {
        if (record == 0) {
            return null;
        }
        switch (PDOMNode.getNodeType(this.pdom, record)) {
            case 3: {
                return new PDOMCVariable(this.pdom, record);
            }
            case 4: {
                return new PDOMCFunction(this.pdom, record);
            }
            case 5: {
                return new PDOMCStructure(this.pdom, record);
            }
            case 6: {
                return new PDOMCField(this.pdom, record);
            }
            case 7: {
                return new PDOMCEnumeration(this.pdom, record);
            }
            case 8: {
                return new PDOMCEnumerator(this.pdom, record);
            }
            case 9: {
                return new PDOMCTypedef(this.pdom, record);
            }
        }
        return super.getNode(record);
    }

    public IBinding resolveBinding(IASTName name) throws CoreException {
        IASTNode parent = name.getParent();
        if (parent instanceof IASTIdExpression) {
            IASTNode eParent = parent.getParent();
            if (eParent instanceof IASTFunctionCallExpression) {
                FindBinding visitor = new FindBinding(this.pdom, name.toCharArray(), 4);
                this.getIndex().accept(visitor);
                return visitor.pdomBinding;
            }
            FindBinding visitor = new FindBinding(this.pdom, name.toCharArray(), 3);
            this.getIndex().accept(visitor);
            return visitor.pdomBinding;
        }
        if (parent instanceof ICASTElaboratedTypeSpecifier) {
            FindBinding visitor = new FindBinding(this.pdom, name.toCharArray(), 5);
            this.getIndex().accept(visitor);
            return visitor.pdomBinding;
        }
        return null;
    }

    public PDOMNode addType(PDOMNode parent, IType type) throws CoreException {
        return null;
    }

    private static final class FindBinding
    extends PDOMNamedNode.NodeFinder {
        PDOMBinding pdomBinding;
        final int desiredType;

        public FindBinding(PDOM pdom, char[] name, int desiredType) {
            super(pdom, name);
            this.desiredType = desiredType;
        }

        public boolean visit(int record) throws CoreException {
            if (record == 0) {
                return true;
            }
            PDOMBinding tBinding = this.pdom.getBinding(record);
            if (!tBinding.hasName(this.name)) {
                return false;
            }
            if (tBinding.getNodeType() != this.desiredType) {
                return true;
            }
            this.pdomBinding = tBinding;
            return false;
        }
    }

    private static class FindBinding2
    implements IPDOMVisitor {
        private PDOMBinding binding;
        private final char[] name;
        private final int[] desiredType;

        public FindBinding2(char[] name, int desiredType) {
            this(name, new int[]{desiredType});
        }

        public FindBinding2(char[] name, int[] desiredType) {
            this.name = name;
            this.desiredType = desiredType;
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            PDOMBinding tBinding;
            if (node instanceof PDOMBinding && (tBinding = (PDOMBinding)node).hasName(this.name)) {
                int nodeType = tBinding.getNodeType();
                int i = 0;
                while (i < this.desiredType.length) {
                    if (nodeType == this.desiredType[i]) {
                        this.binding = tBinding;
                        throw new CoreException(Status.OK_STATUS);
                    }
                    ++i;
                }
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public PDOMBinding getBinding() {
            return this.binding;
        }
    }
}

