/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildIOType;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildResource;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildStep;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildDescription;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildResource;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildStep;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DbgUtil;

public class BuildIOType
implements IBuildIOType {
    private BuildStep fStep;
    private List fResources = new ArrayList();
    private boolean fIsInput;
    private boolean fIsPrimary;
    private String fLinkId;
    private IBuildObject fIoType;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected BuildIOType(BuildStep action, boolean input, boolean primary, IBuildObject ioType) {
        this.fStep = action;
        this.fIsInput = input;
        this.fIsPrimary = primary;
        if (ioType != null) {
            if (input) {
                if (!(ioType instanceof IInputType)) throw new IllegalArgumentException("wrong arg");
                this.fLinkId = ((IInputType)ioType).getBuildVariable();
            } else {
                if (!(ioType instanceof IOutputType)) throw new IllegalArgumentException("wrong arg");
                this.fLinkId = ((IOutputType)ioType).getBuildVariable();
            }
            this.fIoType = ioType;
        }
        ((BuildDescription)this.fStep.getBuildDescription()).typeCreated(this);
    }

    public IBuildResource[] getResources() {
        return this.fResources.toArray(new BuildResource[this.fResources.size()]);
    }

    public IBuildStep getStep() {
        return this.fStep;
    }

    public void addResource(BuildResource rc) {
        this.fResources.add(rc);
        rc.addToArg(this);
        if (DbgUtil.DEBUG) {
            DbgUtil.trace("resource " + DbgUtil.resourceName(rc) + " added as " + (this.fIsInput ? "input" : "output") + " to the action " + DbgUtil.stepName(this.fStep));
        }
        ((BuildDescription)this.fStep.getBuildDescription()).resourceAddedToType(this, rc);
    }

    public void removeResource(BuildResource rc) {
        this.fResources.remove(rc);
        rc.removeFromArg(this);
        if (DbgUtil.DEBUG) {
            DbgUtil.trace("resource " + DbgUtil.resourceName(rc) + " removed as " + (this.fIsInput ? "input" : "output") + " from the action " + DbgUtil.stepName(this.fStep));
        }
        ((BuildDescription)this.fStep.getBuildDescription()).resourceRemovedFromType(this, rc);
    }

    public boolean isInput() {
        return this.fIsInput;
    }

    public boolean isPrimary() {
        return this.fIsPrimary;
    }

    public String getLinkId() {
        IInputType type;
        BuildDescription.ToolAndType tt;
        IBuildResource[] rcs;
        if (!this.fIsInput && this.fStep.getTool() != null && this.fStep.getTool().getCustomBuildStep() && (rcs = this.getResources()).length != 0 && (tt = ((BuildDescription)this.fStep.getBuildDescription()).getToolAndType((BuildResource)rcs[0], false)) != null && (type = tt.fTool.getPrimaryInputType()) != null) {
            this.fLinkId = type.getBuildVariable();
        }
        return this.fLinkId;
    }

    public IBuildObject getIoType() {
        return this.fIoType;
    }

    BuildResource[] remove() {
        BuildResource[] rcs = (BuildResource[])this.getResources();
        int i = 0;
        while (i < rcs.length) {
            this.removeResource(rcs[i]);
            ++i;
        }
        this.fStep = null;
        return rcs;
    }
}

