/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.internal.enablement.OptionEnablementExpression;

public class BooleanExpressionApplicabilityCalculator
implements IOptionApplicability {
    private OptionEnablementExpression[] fExpressions;

    public BooleanExpressionApplicabilityCalculator(IManagedConfigElement optionElement) {
        this(optionElement.getChildren("enablement"));
    }

    public BooleanExpressionApplicabilityCalculator(IManagedConfigElement[] enablementElements) {
        this.fExpressions = new OptionEnablementExpression[enablementElements.length];
        int i = 0;
        while (i < enablementElements.length) {
            this.fExpressions[i] = new OptionEnablementExpression(enablementElements[i]);
            ++i;
        }
    }

    public boolean isOptionVisible(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        return this.evaluate(configuration, holder, option, 1);
    }

    public boolean isOptionEnabled(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        return this.evaluate(configuration, holder, option, 2);
    }

    public boolean isOptionUsedInCommandLine(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        return this.evaluate(configuration, holder, option, 4);
    }

    public boolean evaluate(IBuildObject configuration, IHoldsOptions holder, IOption option, int flags) {
        int i = 0;
        while (i < this.fExpressions.length) {
            if (!this.fExpressions[i].evaluate(configuration, holder, option, flags)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean performAdjustment(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        boolean adjusted = false;
        int i = 0;
        while (i < this.fExpressions.length) {
            if (this.fExpressions[i].performAdjustment(configuration, holder, option)) {
                adjusted = true;
            }
            ++i;
        }
        return adjusted;
    }
}

