/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.envvar;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IProjectEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.internal.envvar.DefaultContextInfo;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvVarOperationProcessor;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.IContextInfo;
import org.eclipse.cdt.managedbuilder.internal.envvar.StoredBuildPathEnvironmentContainer;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.DefaultMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.EnvironmentMacroSupplier;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroSupplier;

public class ExternalExtensionEnvironmentSupplier
implements IEnvironmentVariableSupplier {
    private static final String[] fNonOverloadableVariables = new String[]{EnvVarOperationProcessor.normalizeName("CWD"), EnvVarOperationProcessor.normalizeName("PWD")};

    public IBuildEnvironmentVariable getVariable(String name, Object context) {
        if (context == null) {
            return null;
        }
        if ((name = this.getValidName(name)) == null) {
            return null;
        }
        if (context instanceof IConfiguration) {
            IConfiguration cfg = (IConfiguration)context;
            IConfigurationEnvironmentVariableSupplier supplier = cfg.getEnvironmentVariableSupplier();
            if (supplier == null) {
                return null;
            }
            return supplier.getVariable(name, cfg, new ExtensionEnvVarProvider(context));
        }
        if (context instanceof IManagedProject) {
            IManagedProject project = (IManagedProject)context;
            IProjectEnvironmentVariableSupplier supplier = project.getProjectType().getEnvironmentVariableSupplier();
            if (supplier == null) {
                return null;
            }
            return supplier.getVariable(name, project, new ExtensionEnvVarProvider(context));
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(Object context) {
        if (context == null) {
            return null;
        }
        IBuildEnvironmentVariable[] variables = null;
        if (context instanceof IConfiguration) {
            IConfiguration cfg = (IConfiguration)context;
            IConfigurationEnvironmentVariableSupplier supplier = cfg.getEnvironmentVariableSupplier();
            if (supplier == null) {
                return null;
            }
            variables = supplier.getVariables(cfg, new ExtensionEnvVarProvider(context));
        } else if (context instanceof IManagedProject) {
            IManagedProject project = (IManagedProject)context;
            IProjectEnvironmentVariableSupplier supplier = project.getProjectType().getEnvironmentVariableSupplier();
            if (supplier == null) {
                return null;
            }
            variables = supplier.getVariables(project, new ExtensionEnvVarProvider(context));
        }
        return this.filterVariables(variables);
    }

    protected IEnvironmentVariableSupplier[] filterValidSuppliers(IEnvironmentVariableSupplier[] suppliers) {
        if (suppliers == null) {
            return null;
        }
        int i = 0;
        int j = 0;
        i = 0;
        while (i < suppliers.length) {
            if (suppliers[i] == this) break;
            ++i;
        }
        if (i >= suppliers.length) {
            return null;
        }
        int startNum = i + 1;
        IEnvironmentVariableSupplier[] validSuppliers = new IEnvironmentVariableSupplier[suppliers.length - startNum];
        i = startNum;
        j = 0;
        while (i < suppliers.length) {
            validSuppliers[j] = suppliers[i];
            ++i;
            ++j;
        }
        return validSuppliers;
    }

    protected String getValidName(String name) {
        if ((name = EnvVarOperationProcessor.normalizeName(name)) == null) {
            return null;
        }
        if (fNonOverloadableVariables != null) {
            int i = 0;
            while (i < fNonOverloadableVariables.length) {
                if (name.equals(fNonOverloadableVariables[i])) {
                    return null;
                }
                ++i;
            }
        }
        return name;
    }

    protected IBuildEnvironmentVariable[] filterVariables(IBuildEnvironmentVariable[] variables) {
        return EnvVarOperationProcessor.filterVariables(variables, fNonOverloadableVariables);
    }

    protected IBuildMacroSupplier[] filterValidMacroSuppliers(IBuildMacroSupplier[] suppliers) {
        if (suppliers == null) {
            return null;
        }
        int i = 0;
        int j = 0;
        i = 0;
        while (i < suppliers.length) {
            if (suppliers[i] instanceof EnvironmentMacroSupplier) break;
            ++i;
        }
        if (i >= suppliers.length) {
            return suppliers;
        }
        int startNum = i + 1;
        IBuildMacroSupplier[] validSuppliers = new IBuildMacroSupplier[suppliers.length - startNum];
        i = startNum;
        j = 0;
        while (i < suppliers.length) {
            validSuppliers[j] = suppliers[i];
            ++i;
            ++j;
        }
        return validSuppliers;
    }

    private class ExtensionEnvVarProvider
    extends EnvironmentVariableProvider {
        private IContextInfo fStartInfo;
        private Object fStartLevel;
        private boolean fStartInitialized;
        private int fStartType;
        private Object fStartData;
        private IMacroContextInfo fStartMacroContextInfo;
        private boolean fStartMacroInfoInitialized;

        public ExtensionEnvVarProvider(Object level) {
            this.fStartLevel = level;
            this.fStartType = this.getMacroContextTypeFromContext(level);
            this.fStartData = level;
        }

        public IBuildEnvironmentVariable getVariable(String variableName, Object level, boolean includeParentLevels, boolean resolveMacros) {
            if (ExternalExtensionEnvironmentSupplier.this.getValidName(variableName) == null) {
                return null;
            }
            return super.getVariable(variableName, level, includeParentLevels, resolveMacros);
        }

        public IBuildEnvironmentVariable[] getVariables(Object level, boolean includeParentLevels, boolean resolveMacros) {
            return ExternalExtensionEnvironmentSupplier.this.filterVariables(super.getVariables(level, includeParentLevels, resolveMacros));
        }

        public IContextInfo getContextInfo(Object level) {
            IContextInfo startInfo = this.getStartInfo();
            if (level == this.fStartLevel) {
                return startInfo;
            }
            IContextInfo info = super.getContextInfo(level);
            if (info == null) {
                return null;
            }
            if (this.checkParentContextRelation(startInfo, info)) {
                return info;
            }
            return null;
        }

        protected IContextInfo getStartInfo() {
            if (this.fStartInfo == null && !this.fStartInitialized) {
                IContextInfo info = super.getContextInfo(this.fStartLevel);
                if (info != null) {
                    IEnvironmentVariableSupplier[] suppliers = info.getSuppliers();
                    this.fStartInfo = (suppliers = ExternalExtensionEnvironmentSupplier.this.filterValidSuppliers(suppliers)) != null ? new DefaultContextInfo(this.fStartLevel, suppliers) : info.getNext();
                    this.fStartInitialized = true;
                }
                this.fStartInitialized = true;
            }
            return this.fStartInfo;
        }

        public IMacroSubstitutor getMacroSubstitutor(IMacroContextInfo info, String inexistentMacroValue, String listDelimiter) {
            return super.getMacroSubstitutor(this.getSubstitutorMacroContextInfo(info), inexistentMacroValue, listDelimiter);
        }

        protected IMacroContextInfo getSubstitutorMacroContextInfo(IMacroContextInfo info) {
            IMacroContextInfo startInfo = this.getStartMacroContextInfo();
            if (info == null) {
                return null;
            }
            if (info.getContextType() == this.fStartType && info.getContextData() == this.fStartData) {
                return startInfo;
            }
            if (BuildMacroProvider.getDefault().checkParentContextRelation(startInfo, info)) {
                return info;
            }
            return null;
        }

        protected IMacroContextInfo getStartMacroContextInfo() {
            if (this.fStartMacroContextInfo == null && !this.fStartMacroInfoInitialized) {
                IMacroContextInfo info = this.getMacroContextInfoForContext(this.fStartLevel);
                if (info != null) {
                    this.fStartMacroContextInfo = new DefaultMacroContextInfo(this, this.fStartType, this.fStartData, info){
                        final /* synthetic */ ExtensionEnvVarProvider this$1;
                        private final /* synthetic */ IMacroContextInfo val$info;
                        {
                            this.this$1 = extensionEnvVarProvider;
                            this.val$info = iMacroContextInfo;
                            super($anonymous0, $anonymous1);
                        }

                        protected IBuildMacroSupplier[] getSuppliers(int type, Object data) {
                            IBuildMacroSupplier[] suppliers = this.val$info.getSuppliers();
                            return ExtensionEnvVarProvider.access$0(this.this$1).filterValidMacroSuppliers(suppliers);
                        }

                        public IMacroContextInfo getNext() {
                            return this.val$info.getNext();
                        }
                    };
                    this.fStartInitialized = true;
                }
                this.fStartInitialized = true;
            }
            return this.fStartMacroContextInfo;
        }

        protected StoredBuildPathEnvironmentContainer getStoredBuildPathVariables(int buildPathType) {
            return null;
        }

        protected StoredBuildPathEnvironmentContainer getStoredIncludeBuildPathVariables() {
            return null;
        }

        protected StoredBuildPathEnvironmentContainer getStoredLibraryBuildPathVariables() {
            return null;
        }

        static /* synthetic */ ExternalExtensionEnvironmentSupplier access$0(ExtensionEnvVarProvider extensionEnvVarProvider) {
            return extensionEnvVarProvider.ExternalExtensionEnvironmentSupplier.this;
        }
    }
}

