/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.macros;

import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacro;
import org.eclipse.cdt.managedbuilder.internal.macros.MacroResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StorableBuildMacro
extends BuildMacro {
    public static final String STRING_MACRO_ELEMENT_NAME = "stringMacro";
    public static final String STRINGLIST_MACRO_ELEMENT_NAME = "stringListMacro";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String TYPE = "type";
    public static final String VALUE_ELEMENT_NAME = "value";
    public static final String VALUE_ELEMENT_VALUE = "name";
    public static final String TYPE_TEXT = "VALUE_TEXT";
    public static final String TYPE_TEXT_LIST = "VALUE_TEXT_LIST";
    public static final String TYPE_PATH_FILE = "VALUE_PATH_FILE";
    public static final String TYPE_PATH_FILE_LIST = "VALUE_PATH_FILE_LIST";
    public static final String TYPE_PATH_DIR = "VALUE_PATH_DIR";
    public static final String TYPE_PATH_DIR_LIST = "VALUE_PATH_DIR_LIST";
    public static final String TYPE_PATH_ANY = "VALUE_PATH_ANY";
    public static final String TYPE_PATH_ANY_LIST = "VALUE_PATH_ANY_LIST";

    public StorableBuildMacro(String name, int type, String value) {
        super(name, type, value);
    }

    public StorableBuildMacro(String name, int type, String[] value) {
        super(name, type, value);
    }

    public StorableBuildMacro(Element element) {
        this.load(element);
    }

    private void load(Element element) {
        this.fName = element.getAttribute("name");
        this.fType = this.typeStringToInt(element.getAttribute(TYPE));
        if (!MacroResolver.isStringListMacro(this.fType)) {
            this.fStringValue = element.getAttribute("value");
        } else {
            NodeList nodeList = element.getChildNodes();
            ArrayList<String> values = new ArrayList<String>();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node.getNodeName().equals("value")) {
                    values.add(((Element)node).getAttribute("name"));
                }
                ++i;
            }
            this.fStringListValue = values.toArray(new String[values.size()]);
        }
    }

    private int typeStringToInt(String typeString) {
        int type = TYPE_TEXT_LIST.equals(typeString) ? 2 : (TYPE_PATH_FILE.equals(typeString) ? 3 : (TYPE_PATH_FILE_LIST.equals(typeString) ? 4 : (TYPE_PATH_DIR.equals(typeString) ? 5 : (TYPE_PATH_DIR_LIST.equals(typeString) ? 6 : (TYPE_PATH_ANY.equals(typeString) ? 7 : (TYPE_PATH_ANY_LIST.equals(typeString) ? 8 : 1))))));
        return type;
    }

    private String typeIntToString(int type) {
        String stringType;
        switch (type) {
            case 2: {
                stringType = TYPE_TEXT_LIST;
                break;
            }
            case 3: {
                stringType = TYPE_PATH_FILE;
                break;
            }
            case 4: {
                stringType = TYPE_PATH_FILE_LIST;
                break;
            }
            case 5: {
                stringType = TYPE_PATH_DIR;
                break;
            }
            case 6: {
                stringType = TYPE_PATH_DIR_LIST;
                break;
            }
            case 7: {
                stringType = TYPE_PATH_ANY;
                break;
            }
            case 8: {
                stringType = TYPE_PATH_ANY_LIST;
                break;
            }
            default: {
                stringType = TYPE_TEXT;
            }
        }
        return stringType;
    }

    public void serialize(Document doc, Element element) {
        if (this.fName != null) {
            element.setAttribute("name", this.fName);
        }
        element.setAttribute(TYPE, this.typeIntToString(this.fType));
        if (!MacroResolver.isStringListMacro(this.fType)) {
            if (this.fStringValue != null) {
                element.setAttribute("value", this.fStringValue);
            }
        } else if (this.fStringListValue != null && this.fStringListValue.length > 0) {
            int i = 0;
            while (i < this.fStringListValue.length) {
                Element valEl = doc.createElement("value");
                element.appendChild(valEl);
                if (this.fStringListValue[i] != null) {
                    valEl.setAttribute("name", this.fStringListValue[i]);
                }
                ++i;
            }
        }
    }
}

