/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.model;

import java.util.LinkedList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.model.FortranElement;
import org.eclipse.photran.internal.core.model.FortranModelBuilder;
import org.eclipse.photran.internal.core.parser.ASTBlockDataSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTComponentDeclListNode;
import org.eclipse.photran.internal.core.parser.ASTComponentDefStmtNode;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeDefNode;
import org.eclipse.photran.internal.core.parser.ASTExternalNameListNode;
import org.eclipse.photran.internal.core.parser.ASTExternalStmtNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTInterfaceBlockNode;
import org.eclipse.photran.internal.core.parser.ASTIntrinsicListNode;
import org.eclipse.photran.internal.core.parser.ASTIntrinsicStmtNode;
import org.eclipse.photran.internal.core.parser.ASTMainProgramNode;
import org.eclipse.photran.internal.core.parser.ASTModuleNode;
import org.eclipse.photran.internal.core.parser.ASTStmtFunctionStmtNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTVisitor;
import org.eclipse.photran.internal.core.parser.GenericParseTreeVisitor;
import org.eclipse.photran.internal.core.parser.ParseTreeNode;

public final class FortranModelBuildingVisitor
extends GenericParseTreeVisitor {
    private TranslationUnit translationUnit;
    private FortranModelBuilder modelBuilder;
    private ElementMappingVisitor elementMappingVisitor;
    private LinkedList parentParseTreeNodeStack = new LinkedList();
    private LinkedList parentElementStack = new LinkedList();

    public FortranModelBuildingVisitor(TranslationUnit translationUnit, FortranModelBuilder modelBuilder) {
        this.translationUnit = translationUnit;
        this.modelBuilder = modelBuilder;
        this.elementMappingVisitor = new ElementMappingVisitor();
    }

    private Parent getCurrentParent() {
        if (this.parentElementStack.isEmpty()) {
            return this.translationUnit;
        }
        return (Parent)this.parentElementStack.getLast();
    }

    private boolean isCurrentParent(ParseTreeNode node) {
        if (this.parentParseTreeNodeStack.isEmpty()) {
            return false;
        }
        return node == (ParseTreeNode)this.parentParseTreeNodeStack.getLast();
    }

    private void addToModel(ParseTreeNode parseTreeNode, FortranElement element) {
        try {
            this.modelBuilder.addF90Element(element);
            this.beginAddingChildrenFor(parseTreeNode, element);
        }
        catch (CModelException cModelException) {}
    }

    private void beginAddingChildrenFor(ParseTreeNode parseTreeNode, FortranElement element) {
        this.parentParseTreeNodeStack.addLast(parseTreeNode);
        this.parentElementStack.addLast(element);
    }

    private void doneAddingChildrenFor(ParseTreeNode node) {
        if (this.isCurrentParent(node)) {
            this.parentParseTreeNodeStack.removeLast();
            this.parentElementStack.removeLast();
        }
    }

    public void preparingToVisitChildrenOf(ParseTreeNode node) {
        node.visitOnlyThisNodeUsing((ASTVisitor)this.elementMappingVisitor);
    }

    public void doneVisitingChildrenOf(ParseTreeNode node) {
        this.doneAddingChildrenFor(node);
    }

    private class ElementMappingVisitor
    extends ASTVisitor {
        private ElementMappingVisitor() {
        }

        public void visitASTMainProgramNode(ASTMainProgramNode node) {
            Token token = node.getASTProgramStmt() == null ? null : node.getASTProgramStmt().getASTProgramName().getASTTident();
            FortranModelBuildingVisitor.this.addToModel((ParseTreeNode)node, new FortranElement.MainProgram(FortranModelBuildingVisitor.this.getCurrentParent(), token));
        }

        public void visitASTModuleNode(ASTModuleNode node) {
            Token token = node.getASTModuleStmt().getASTModuleName().getASTTident();
            FortranModelBuildingVisitor.this.addToModel((ParseTreeNode)node, new FortranElement.Module(FortranModelBuildingVisitor.this.getCurrentParent(), token));
        }

        public void visitASTFunctionSubprogramNode(ASTFunctionSubprogramNode node) {
            Token token = node.getASTFunctionStmt().getASTFunctionName().getASTTident();
            FortranModelBuildingVisitor.this.addToModel((ParseTreeNode)node, new FortranElement.Function(FortranModelBuildingVisitor.this.getCurrentParent(), token));
        }

        public void visitASTSubroutineSubprogramNode(ASTSubroutineSubprogramNode node) {
            Token token = node.getASTSubroutineStmt().getASTSubroutineName().getASTTident();
            FortranModelBuildingVisitor.this.addToModel((ParseTreeNode)node, new FortranElement.Subroutine(FortranModelBuildingVisitor.this.getCurrentParent(), token));
        }

        public void visitASTBlockDataSubprogramNode(ASTBlockDataSubprogramNode node) {
            Token token = node.getASTBlockDataStmt().getASTBlockDataName() == null ? null : node.getASTBlockDataStmt().getASTBlockDataName().getASTTident();
            FortranModelBuildingVisitor.this.addToModel((ParseTreeNode)node, new FortranElement.BlockData(FortranModelBuildingVisitor.this.getCurrentParent(), token));
        }

        public void visitASTDerivedTypeDefNode(ASTDerivedTypeDefNode node) {
            Token token = node.getASTDerivedTypeStmt().getASTTypeName().getASTTident();
            FortranModelBuildingVisitor.this.addToModel((ParseTreeNode)node, new FortranElement.DerivedType(FortranModelBuildingVisitor.this.getCurrentParent(), token));
        }

        public void visitASTComponentDefStmtNode(ASTComponentDefStmtNode node) {
            ASTComponentDeclListNode list = node.getASTComponentDeclList();
            int i = 0;
            while (i < list.count()) {
                FortranModelBuildingVisitor.this.addToModel((ParseTreeNode)node, new FortranElement.Variable(FortranModelBuildingVisitor.this.getCurrentParent(), list.getASTComponentDecl(i).getASTComponentName().getASTTident()));
                ++i;
            }
        }

        public void visitASTExternalStmtNode(ASTExternalStmtNode node) {
            ASTExternalNameListNode list = node.getASTExternalNameList();
            int i = 0;
            while (i < list.count()) {
                FortranModelBuildingVisitor.this.addToModel((ParseTreeNode)node, new FortranElement.Variable(FortranModelBuildingVisitor.this.getCurrentParent(), list.getASTExternalName(i).getASTTident()));
                ++i;
            }
        }

        public void visitASTInterfaceBlockNode(ASTInterfaceBlockNode node) {
            Token token = node.getASTInterfaceStmt().getASTGenericName() == null ? null : node.getASTInterfaceStmt().getASTGenericName().getASTTident();
            FortranModelBuildingVisitor.this.addToModel((ParseTreeNode)node, new FortranElement.Variable(FortranModelBuildingVisitor.this.getCurrentParent(), token));
        }

        public void visitASTIntrinsicStmtNode(ASTIntrinsicStmtNode node) {
            ASTIntrinsicListNode list = node.getASTIntrinsicList();
            int i = 0;
            while (i < list.count()) {
                FortranModelBuildingVisitor.this.addToModel((ParseTreeNode)node, new FortranElement.Variable(FortranModelBuildingVisitor.this.getCurrentParent(), list.getASTIntrinsicProcedureName(i).getASTTident()));
                ++i;
            }
        }

        public void visitASTStmtFunctionStmtNode(ASTStmtFunctionStmtNode node) {
            FortranModelBuildingVisitor.this.addToModel((ParseTreeNode)node, new FortranElement.Variable(FortranModelBuildingVisitor.this.getCurrentParent(), node.getASTName().getASTTident()));
        }
    }
}

