/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ptp.debug.internal.ui.PDebugImage;
import org.eclipse.ptp.debug.internal.ui.dialogs.ArrayVariableDialog;
import org.eclipse.ptp.debug.internal.ui.views.PTabFolder;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class AddVariableAction
extends Action {
    protected PTabFolder folder = null;
    public static final String name = "Add Variable";

    public AddVariableAction(PTabFolder folder) {
        super(name, 1);
        this.setImageDescriptor(PDebugImage.ID_ICON_ADD_VAR_NORMAL);
        this.setToolTipText(name);
        this.folder = folder;
    }

    public Shell getShell() {
        return this.folder.getViewSite().getShell();
    }

    public void run() {
        final IStackFrame[] stackFrame = new IStackFrame[1];
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    stackFrame[0] = AddVariableAction.this.getStackFrame();
                }
                catch (CoreException e) {
                    PTPDebugUIPlugin.errorDialog(AddVariableAction.this.getShell(), "Error", e.getStatus());
                }
            }
        });
        try {
            this.openDialog(stackFrame[0]);
        }
        catch (DebugException e) {
            PTPDebugUIPlugin.errorDialog(this.getShell(), "Error", e.getStatus());
        }
    }

    protected IStackFrame getStackFrame() throws CoreException {
        Object obj;
        ISelection selection;
        IDebugView adapter;
        IWorkbenchWindow activeWindow = PTPDebugUIPlugin.getActiveWorkbenchWindow();
        if (activeWindow == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, "No active window found", null));
        }
        IWorkbenchPage page = activeWindow.getActivePage();
        if (page == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, "No active page found", null));
        }
        IViewPart part = page.findView("org.eclipse.debug.ui.DebugView");
        if (part != null && (adapter = (IDebugView)part.getAdapter(IDebugView.class)) != null && (selection = adapter.getViewer().getSelection()) instanceof StructuredSelection && (obj = ((StructuredSelection)selection).getFirstElement()) instanceof IStackFrame) {
            return (IStackFrame)obj;
        }
        throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 150, "No stack frame found", null));
    }

    protected void openDialog(IStackFrame frame) throws DebugException {
        IVariable variable;
        ArrayVariableDialog dialog;
        if (frame != null && (dialog = new ArrayVariableDialog(this.getShell(), frame)).open() == 0 && (variable = dialog.getSelectedVariable()) != null) {
            this.folder.createTabItem(variable.getName(), variable);
        }
    }
}

