/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.ui.views.variable;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.internal.ui.PJobVariableManager;
import org.eclipse.ptp.debug.internal.ui.views.variable.PVariableMessages;
import org.eclipse.ptp.debug.internal.ui.views.variable.PVariableView;
import org.eclipse.ptp.debug.ui.PTPDebugUIPlugin;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PVariableDialog
extends Dialog {
    public static final int NEW_MODE = 0;
    public static final int EDIT_MODE = 1;
    protected Text varText = null;
    protected Table setTable = null;
    protected Table varTable = null;
    protected Button checkBtn = null;
    protected PVariableView view = null;
    protected int mode = 0;

    public PVariableDialog(PVariableView view) {
        this(view, 0);
    }

    public PVariableDialog(PVariableView view, int mode) {
        super(view.getSite().getShell());
        this.view = view;
        this.mode = mode;
    }

    public void configureShell(Shell newShell) {
        newShell.setText(PVariableMessages.getString("PVariablesDialog.title"));
        super.configureShell(newShell);
    }

    public Button getOkButton() {
        return this.getButton(0);
    }

    private void createOthersSection(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.verticalSpacing = 25;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1808));
        this.checkBtn = new Button(comp, 32);
        this.checkBtn.setText(PVariableMessages.getString("PVariablesDialog.checkBtn"));
        this.checkBtn.setSelection(true);
    }

    private void createVarSection(Composite parent) {
        Group aGroup = new Group(parent, 2048);
        aGroup.setText(PVariableMessages.getString("PVariablesDialog.varSection"));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        aGroup.setLayout((Layout)layout);
        aGroup.setLayoutData((Object)new GridData(1808));
        new Label((Composite)aGroup, 0).setText(PVariableMessages.getString("PVariablesDialog.availVar"));
        this.varTable = new Table((Composite)aGroup, 68388);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 200;
        this.varTable.setLayoutData((Object)gd);
        this.varTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((TableItem)e.item).getChecked()) {
                    PVariableDialog.this.varText.setText("");
                }
                PVariableDialog.this.updateButtons();
            }
        });
        Composite comp2 = new Composite((Composite)aGroup, 0);
        comp2.setLayout((Layout)new GridLayout(2, false));
        comp2.setLayoutData((Object)new GridData(1808));
        new Label(comp2, 0).setText(PVariableMessages.getString("PVariablesDialog.custVar"));
        this.varText = new Text(comp2, 2048);
        this.varText.setLayoutData((Object)new GridData(768));
        this.varText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (PVariableDialog.this.varText.getText().length() > 0) {
                    TableItem[] items = PVariableDialog.this.varTable.getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].setChecked(false);
                        ++i;
                    }
                }
                PVariableDialog.this.updateButtons();
            }
        });
        this.varText.setFocus();
    }

    private void createSetSection(Composite parent) {
        Group aGroup = new Group(parent, 2048);
        aGroup.setText(PVariableMessages.getString("PVariablesDialog.setSection"));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        aGroup.setLayout((Layout)layout);
        aGroup.setLayoutData((Object)new GridData(1808));
        this.setTable = new Table((Composite)aGroup, 68384);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 100;
        this.setTable.setLayoutData((Object)gd);
        this.setTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                if (item.getChecked()) {
                    if (item.getText().equals("Root")) {
                        PVariableDialog.this.setCheckTableItems(false);
                    } else {
                        PVariableDialog.this.setTable.getItem(0).setChecked(false);
                    }
                }
                PVariableDialog.this.updateButtons();
            }
        });
    }

    private void setCheckTableItems(boolean checked) {
        TableItem[] items = this.setTable.getItems();
        int i = 1;
        while (i < items.length) {
            items[i].setChecked(checked);
            ++i;
        }
    }

    private boolean anyTableItemChecked(Table table) {
        TableItem[] items = table.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void updateButtons() {
        boolean enabled = true;
        if (this.getSelectedVariables().length == 0) {
            enabled = false;
        }
        if (this.getSelectedSets().length == 0) {
            enabled = false;
        }
        this.getOkButton().setEnabled(enabled);
    }

    protected void initContent() {
        ISelection selection;
        PJobVariableManager.JobVariable jVar = null;
        if (this.mode == 1 && !(selection = this.view.getSelection()).isEmpty() && selection instanceof IStructuredSelection) {
            jVar = (PJobVariableManager.JobVariable)((IStructuredSelection)selection).getFirstElement();
            this.varText.setText(jVar.getVar());
            this.checkBtn.setSelection(jVar.isEnable());
        }
        String[] sets = this.view.getUIManager().getSets(this.view.getUIManager().getCurrentJobId());
        TableItem item = null;
        int i = 0;
        while (i < sets.length) {
            item = new TableItem(this.setTable, 0);
            item.setText(sets[i]);
            if (jVar != null) {
                String[] selectedSets = jVar.getSets();
                int j = 0;
                while (j < selectedSets.length) {
                    item.setChecked(selectedSets[j].equals(sets[i]));
                    ++j;
                }
            }
            ++i;
        }
        String[] vars = this.getAvailableVariables();
        int i2 = 0;
        while (i2 < vars.length) {
            item = new TableItem(this.varTable, 0);
            item.setText(vars[i2]);
            if (jVar != null) {
                item.setChecked(jVar.getVar().equals(vars[i2]));
            }
            ++i2;
        }
    }

    protected String[] getAvailableVariables() {
        ISelection selection = this.view.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
        if (selection.isEmpty()) {
            return new String[0];
        }
        if (selection instanceof IStructuredSelection) {
            Object target = ((IStructuredSelection)selection).getFirstElement();
            try {
                IThread[] threads;
                if (target instanceof IStackFrame) {
                    return this.getVariables((IStackFrame)target);
                }
                if (target instanceof IThread) {
                    return this.getVariables(((IThread)target).getTopStackFrame());
                }
                if (target instanceof IPDebugTarget && (threads = ((IPDebugTarget)target).getThreads()).length > 0) {
                    return this.getVariables(threads[0].getTopStackFrame());
                }
            }
            catch (DebugException debugException) {
                return new String[0];
            }
        }
        return new String[0];
    }

    private String[] getVariables(IStackFrame frame) throws DebugException {
        if (frame == null) {
            return new String[0];
        }
        IVariable[] vars = frame.getVariables();
        String[] varTexts = new String[vars.length];
        int j = 0;
        while (j < vars.length) {
            varTexts[j] = vars[j].getName();
            ++j;
        }
        return varTexts;
    }

    protected void createVerticalSpan(Composite parent, int space) {
        Label label = new Label(parent, 0);
        GridData gd = new GridData(1808);
        gd.verticalSpan = space;
        label.setLayoutData((Object)gd);
    }

    public Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        switch (this.mode) {
            case 0: {
                this.getOkButton().setText("Create");
                break;
            }
            case 1: {
                this.getOkButton().setText("Edit");
            }
        }
        this.updateButtons();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createVarSection(composite);
        this.createVerticalSpan(composite, 2);
        this.createSetSection(composite);
        this.createOthersSection(composite);
        this.initContent();
        return composite;
    }

    protected String[] getSelectedSets() {
        ArrayList<String> sets = new ArrayList<String>();
        TableItem[] items = this.setTable.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                sets.add(items[i].getText());
            }
            ++i;
        }
        return sets.toArray(new String[0]);
    }

    protected String[] getSelectedAvailableVariables() {
        ArrayList<String> vars = new ArrayList<String>();
        TableItem[] items = this.varTable.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                vars.add(items[i].getText());
            }
            ++i;
        }
        return vars.toArray(new String[0]);
    }

    protected String[] getSelectedVariables() {
        String[] vars = this.getSelectedAvailableVariables();
        if (vars.length == 0 && this.varText.getText().length() > 0) {
            return new String[]{this.varText.getText()};
        }
        return vars;
    }

    protected void okPressed() {
        PJobVariableManager jobMgr = this.view.getUIManager().getJobVariableManager();
        IPJob job = this.view.getUIManager().getCurrentJob();
        String[] vars = this.getSelectedVariables();
        String[] sets = this.getSelectedSets();
        boolean checked = this.checkBtn.getSelection();
        switch (this.mode) {
            case 0: {
                int i = 0;
                while (i < vars.length) {
                    if (jobMgr.isContainVariable(job, vars[i])) {
                        PTPDebugUIPlugin.errorDialog("Duplicate variable", (IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, "Variable (" + vars[i] + ") is added already.", null));
                        return;
                    }
                    ++i;
                }
                i = 0;
                while (i < vars.length) {
                    jobMgr.addJobVariable(job, vars[i], sets, checked);
                    ++i;
                }
                break;
            }
            case 1: {
                ISelection selection = this.view.getSelection();
                if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) break;
                PJobVariableManager.JobVariable varInfo = (PJobVariableManager.JobVariable)((IStructuredSelection)selection).getFirstElement();
                jobMgr.removeJobVariable(job.getIDString(), varInfo.getVar());
                int i = 0;
                while (i < vars.length) {
                    jobMgr.addJobVariable(job, vars[i], sets, checked);
                    ++i;
                }
                break;
            }
        }
        super.okPressed();
    }
}

