/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.ptp.core.IModelListener;
import org.eclipse.ptp.core.IModelPresentation;
import org.eclipse.ptp.core.IPJob;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.events.IModelErrorEvent;
import org.eclipse.ptp.core.events.IModelEvent;
import org.eclipse.ptp.core.events.IModelRuntimeNotifierEvent;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.launch.PTPLaunchPlugin;

public class RuntimeProcess
implements IProcess,
IModelListener {
    private IPLaunch launch = null;
    private IPJob job = null;
    private Map fAttributes;
    private int fExitValue = -1;
    private boolean fTerminated = false;
    private IModelPresentation modelPresentation = null;

    public RuntimeProcess(IPLaunch launch, IPJob job, Map attributes) {
        this.launch = launch;
        this.job = job;
        this.initializeAttributes(attributes);
        this.fTerminated = job.isAllStop();
        launch.addProcess((IProcess)this);
        this.getModelPresentation().addModelListener((IModelListener)this);
        this.fireCreationEvent();
    }

    private IModelPresentation getModelPresentation() {
        if (this.modelPresentation == null) {
            this.modelPresentation = PTPCorePlugin.getDefault().getModelPresentation();
        }
        return this.modelPresentation;
    }

    private void initializeAttributes(Map attributes) {
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                this.setAttribute(key, (String)attributes.get(key));
            }
        }
    }

    public String getLabel() {
        return this.job.getName();
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    public void setAttribute(String key, String value) {
        Object origVal;
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap(5);
        }
        if ((origVal = this.fAttributes.get(key)) != null && origVal.equals(value)) {
            return;
        }
        this.fAttributes.put(key, value);
    }

    public String getAttribute(String key) {
        if (this.fAttributes == null) {
            return null;
        }
        return (String)this.fAttributes.get(key);
    }

    public int getExitValue() throws DebugException {
        if (this.isTerminated()) {
            return this.fExitValue;
        }
        throw new DebugException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), 4, "Exit value not available", null));
    }

    protected void terminated() {
        this.fTerminated = true;
        this.fExitValue = 0;
        this.getModelPresentation().removeModelListener((IModelListener)this);
        this.fireTerminateEvent();
    }

    public boolean canTerminate() {
        return !this.fTerminated;
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        if (!this.isTerminated()) {
            try {
                this.getModelPresentation().abortJob(this.job.getIDString());
            }
            catch (CoreException e) {
                throw new DebugException(e.getStatus());
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IProcess.class)) {
            return this;
        }
        if (adapter.equals(ILaunch.class)) {
            return this.getLaunch();
        }
        return null;
    }

    public void modelEvent(IModelEvent event) {
        if (event instanceof IModelErrorEvent) {
            this.terminated();
        } else if (event instanceof IModelRuntimeNotifierEvent) {
            IModelRuntimeNotifierEvent runtimeEvent = (IModelRuntimeNotifierEvent)event;
            switch (runtimeEvent.getStatus()) {
                case 3: {
                    this.terminated();
                    break;
                }
                case 2: {
                    this.terminated();
                }
            }
        }
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    protected void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }
}

