/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.launcher.AssertionVMArg;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchDescription;
import org.eclipse.jdt.internal.junit.launcher.TestKindRegistry;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class JUnitLaunchShortcut
implements ILaunchShortcut {
    static /* synthetic */ Class class$0;

    public void launch(IEditorPart editor, String mode) {
        IJavaElement element = null;
        IEditorInput input = editor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((element = (IJavaElement)input.getAdapter((Class)clazz)) != null) {
            this.searchAndLaunch(new Object[]{element}, mode);
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode);
        }
    }

    protected void searchAndLaunch(Object[] search, String mode) {
        try {
            if (search != null) {
                if (search.length == 0) {
                    MessageDialog.openInformation((Shell)JUnitPlugin.getActiveWorkbenchShell(), (String)JUnitMessages.LaunchTestAction_dialog_title, (String)JUnitMessages.LaunchTestAction_message_notests);
                    return;
                }
                if (search[0] instanceof IJavaElement) {
                    IJavaElement element = (IJavaElement)search[0];
                    if (element.getElementType() < 5) {
                        this.launch(mode, this.describeContainerLaunch(element));
                        return;
                    }
                    if (element.getElementType() == 9) {
                        this.launch(mode, this.describeMethodLaunch((IMethod)element));
                        return;
                    }
                }
                this.launchType(search, mode);
            }
        }
        catch (LaunchCancelledByUserException launchCancelledByUserException) {}
    }

    protected void launchType(Object[] search, String mode) {
        IType[] types = null;
        try {
            types = TestSearchEngine.findTests(search);
        }
        catch (InterruptedException e) {
            JUnitPlugin.log(e);
            return;
        }
        catch (InvocationTargetException e) {
            JUnitPlugin.log(e);
            return;
        }
        IType type = null;
        if (types.length == 0) {
            MessageDialog.openInformation((Shell)JUnitPlugin.getActiveWorkbenchShell(), (String)JUnitMessages.LaunchTestAction_dialog_title, (String)JUnitMessages.LaunchTestAction_message_notests);
        } else {
            type = types.length > 1 ? this.chooseType(types, mode) : types[0];
        }
        if (type != null) {
            try {
                this.launch(mode, this.describeTypeLaunch(type));
            }
            catch (LaunchCancelledByUserException launchCancelledByUserException) {}
        }
    }

    private void launch(String mode, JUnitLaunchDescription description) throws LaunchCancelledByUserException {
        ILaunchConfiguration config = this.findOrCreateLaunchConfiguration(mode, this, description);
        if (config != null) {
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    public JUnitLaunchDescription describeContainerLaunch(IJavaElement container) {
        JUnitLaunchDescription description = new JUnitLaunchDescription(container, this.getContainerLabel(container));
        description.setContainer(container.getHandleIdentifier());
        description.setTestKind(TestKindRegistry.getContainerTestKindId(container));
        return description;
    }

    protected String getContainerLabel(IJavaElement container) {
        String name = JavaElementLabels.getTextLabel((Object)container, (long)JavaElementLabels.ALL_FULLY_QUALIFIED);
        return name.substring(name.lastIndexOf(47) + 1);
    }

    public JUnitLaunchDescription describeTypeLaunch(IType type) {
        JUnitLaunchDescription description = new JUnitLaunchDescription((IJavaElement)type, type.getElementName());
        description.setMainType(type);
        description.setTestKind(TestKindRegistry.getContainerTestKindId((IJavaElement)type));
        return description;
    }

    public JUnitLaunchDescription describeMethodLaunch(IMethod method) {
        IType declaringType = method.getDeclaringType();
        String name = String.valueOf(declaringType.getElementName()) + "." + method.getElementName();
        JUnitLaunchDescription description = new JUnitLaunchDescription((IJavaElement)method, name);
        description.setMainType(declaringType);
        description.setTestName(method.getElementName());
        description.setTestKind(TestKindRegistry.getContainerTestKindId((IJavaElement)method));
        return description;
    }

    public ILaunchConfiguration findOrCreateLaunchConfiguration(String mode, JUnitLaunchShortcut registry, JUnitLaunchDescription description) throws LaunchCancelledByUserException {
        ILaunchConfiguration config = registry.findLaunchConfiguration(mode, description);
        if (config == null) {
            config = registry.createConfiguration(description);
        }
        return config;
    }

    protected IType chooseType(IType[] types, String mode) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(JUnitPlugin.getActiveWorkbenchShell(), (ILabelProvider)new JavaElementLabelProvider(2048));
        dialog.setElements((Object[])types);
        dialog.setTitle(JUnitMessages.LaunchTestAction_dialog_title2);
        if (mode.equals("debug")) {
            dialog.setMessage(JUnitMessages.LaunchTestAction_message_selectTestToRun);
        } else {
            dialog.setMessage(JUnitMessages.LaunchTestAction_message_selectTestToDebug);
        }
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected ILaunchConfiguration chooseConfiguration(List configList, String mode) throws LaunchCancelledByUserException {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(JUnitPlugin.getActiveWorkbenchShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(JUnitMessages.LaunchTestAction_message_selectConfiguration);
        if (mode.equals("debug")) {
            dialog.setMessage(JUnitMessages.LaunchTestAction_message_selectDebugConfiguration);
        } else {
            dialog.setMessage(JUnitMessages.LaunchTestAction_message_selectRunConfiguration);
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        throw new LaunchCancelledByUserException();
    }

    public ILaunchConfiguration createConfiguration(JUnitLaunchDescription description) {
        String mainType = description.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME);
        String testName = description.getAttribute("org.eclipse.jdt.junit.TESTNAME");
        ILaunchConfiguration config = this.createConfiguration(description.getProject(), description.getName(), mainType, description.getContainer(), testName);
        try {
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            String testKind = description.getAttribute("org.eclipse.jdt.junit.TEST_KIND");
            wc.setAttribute("org.eclipse.jdt.junit.TEST_KIND", testKind);
            config = wc.doSave();
        }
        catch (CoreException ce) {
            JUnitPlugin.log(ce);
        }
        return config;
    }

    protected ILaunchConfiguration createConfiguration(IJavaProject project, String name, String mainType, String container, String testName) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationWorkingCopy wc = this.newWorkingCopy(name);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainType);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getElementName());
            wc.setAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", false);
            wc.setAttribute("org.eclipse.jdt.junit.CONTAINER", container);
            if (testName.length() > 0) {
                wc.setAttribute("org.eclipse.jdt.junit.TESTNAME", testName);
            }
            AssertionVMArg.setArgDefault(wc);
            config = wc.doSave();
        }
        catch (CoreException ce) {
            JUnitPlugin.log(ce);
        }
        return config;
    }

    protected ILaunchConfigurationWorkingCopy newWorkingCopy(String name) throws CoreException {
        ILaunchConfigurationType configType = this.getJUnitLaunchConfigType();
        return configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(name));
    }

    protected ILaunchConfigurationType getJUnitLaunchConfigType() {
        ILaunchManager lm = this.getLaunchManager();
        return lm.getLaunchConfigurationType("org.eclipse.jdt.junit.launchconfig");
    }

    public ILaunchConfiguration findLaunchConfiguration(String mode, JUnitLaunchDescription description) throws LaunchCancelledByUserException {
        ILaunchConfigurationType configType = this.getJUnitLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (description.attributesMatch(config)) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JUnitPlugin.log(e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return null;
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    public class LaunchCancelledByUserException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

