/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.internal.ui;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.ptp.debug.external.internal.ui.ControlFactory;
import org.eclipse.ptp.debug.external.internal.ui.ExternalDebugUIMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SDMPage
extends AbstractLaunchConfigurationTab
implements Observer {
    protected Text fExePathText;
    protected Button fExePathButton = null;
    protected Text fCWDText;
    protected Button fCWDButton = null;
    protected static final String EMPTY_STRING = "";
    private boolean fIsInitializing = false;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        Composite subComp = ControlFactory.createCompositeEx(comp, 2, 768);
        ((GridLayout)subComp.getLayout()).makeColumnsEqualWidth = false;
        this.fExePathButton = this.createCheckButton(subComp, ExternalDebugUIMessages.getString("SDMDebuggerPage.2"));
        this.fExePathButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SDMPage.this.handleExePathButtonSelected();
                if (!SDMPage.this.isInitializing()) {
                    SDMPage.this.updateLaunchConfigurationDialog();
                }
            }

            public void widgetSelected(SelectionEvent e) {
                SDMPage.this.handleExePathButtonSelected();
                if (!SDMPage.this.isInitializing()) {
                    SDMPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.fExePathText = ControlFactory.createTextField(subComp, 2052);
        this.fExePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                if (!SDMPage.this.isInitializing()) {
                    SDMPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.fCWDButton = this.createCheckButton(subComp, ExternalDebugUIMessages.getString("SDMDebuggerPage.3"));
        this.fCWDButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SDMPage.this.handleCWDButtonSelected();
                if (!SDMPage.this.isInitializing()) {
                    SDMPage.this.updateLaunchConfigurationDialog();
                }
            }

            public void widgetSelected(SelectionEvent e) {
                SDMPage.this.handleCWDButtonSelected();
                if (!SDMPage.this.isInitializing()) {
                    SDMPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.fCWDText = ControlFactory.createTextField(subComp, 2052);
        this.fCWDText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                if (!SDMPage.this.isInitializing()) {
                    SDMPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.setControl((Control)parent);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", null);
        configuration.setAttribute("org.eclipse.ptp.launch.DEBUGGER_WORKING_DIR", null);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setInitializing(true);
        try {
            String exe = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", null);
            if (exe == null) {
                this.fExePathText.setText(EMPTY_STRING);
                this.fExePathButton.setSelection(false);
            } else {
                this.fExePathText.setText(exe);
                this.fExePathButton.setSelection(true);
            }
            this.handleExePathButtonSelected();
            String cwd = configuration.getAttribute("org.eclipse.ptp.launch.DEBUGGER_WORKING_DIR", null);
            if (cwd == null) {
                this.fCWDText.setText(EMPTY_STRING);
                this.fCWDButton.setSelection(false);
            } else {
                this.fCWDText.setText(cwd);
                this.fCWDButton.setSelection(true);
            }
            this.handleCWDButtonSelected();
        }
        catch (CoreException coreException) {
            this.setErrorMessage("Exception occurred reading configuration");
        }
        this.setInitializing(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String exe = null;
        if (this.fExePathButton.getSelection()) {
            exe = this.getFieldContent(this.fExePathText.getText());
        }
        configuration.setAttribute("org.eclipse.ptp.launch.DEBUGGER_EXECUTABLE_PATH", exe);
        String cwd = null;
        if (this.fCWDButton.getSelection()) {
            cwd = this.getFieldContent(this.fCWDText.getText());
        }
        configuration.setAttribute("org.eclipse.ptp.launch.DEBUGGER_WORKING_DIR", cwd);
    }

    public String getName() {
        return ExternalDebugUIMessages.getString("SDMDebuggerPage.1");
    }

    protected Shell getShell() {
        return super.getShell();
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public void update(Observable o, Object arg) {
        if (!this.isInitializing()) {
            this.updateLaunchConfigurationDialog();
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    protected boolean isInitializing() {
        return this.fIsInitializing;
    }

    private void setInitializing(boolean isInitializing) {
        this.fIsInitializing = isInitializing;
    }

    protected void handleExePathButtonSelected() {
        if (this.fExePathButton.getSelection()) {
            this.fExePathText.setEnabled(true);
        } else {
            this.fExePathText.setEnabled(false);
        }
    }

    protected void handleCWDButtonSelected() {
        if (this.fCWDButton.getSelection()) {
            this.fCWDText.setEnabled(true);
        } else {
            this.fCWDText.setEnabled(false);
        }
    }

    protected String getFieldContent(String text) {
        if (text.trim().length() == 0 || text.equals(EMPTY_STRING)) {
            return null;
        }
        return text;
    }
}

