/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.FileRevisionEditorInput;
import org.eclipse.team.internal.ui.history.GenericHistoryDropAdapter;
import org.eclipse.team.internal.ui.history.GenericHistoryViewDefaultPage;
import org.eclipse.team.internal.ui.history.LocalHistoryPageSource;
import org.eclipse.team.internal.ui.history.WorkbenchHistoryPageSite;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageSite;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;

public class GenericHistoryView
extends ViewPart
implements IHistoryView {
    private PageBook book;
    private Action refreshAction;
    private Action linkWithEditorAction;
    private Action pinAction;
    private PageContainer defaultPageContainer;
    PageContainer currentPageContainer;
    DropTarget dropTarget;
    GenericHistoryDropAdapter dropAdapter;
    private Object lastSelectedElement;
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                GenericHistoryView.this.editorActivated((IEditorPart)part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            if (part == GenericHistoryView.this) {
                GenericHistoryView.this.editorActivated(GenericHistoryView.this.getViewSite().getPage().getActiveEditor());
            }
        }

        public void partOpened(IWorkbenchPart part) {
            if (part == GenericHistoryView.this) {
                GenericHistoryView.this.editorActivated(GenericHistoryView.this.getViewSite().getPage().getActiveEditor());
            }
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }
    };
    private IPartListener2 partListener2 = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref.getPart(true) == GenericHistoryView.this) {
                GenericHistoryView.this.editorActivated(GenericHistoryView.this.getViewSite().getPage().getActiveEditor());
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }
    };
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structSelection = (IStructuredSelection)selection;
                GenericHistoryView.this.lastSelectedElement = structSelection.getFirstElement();
                if (!GenericHistoryView.this.isLinkingEnabled() || !GenericHistoryView.this.checkIfPageIsVisible()) {
                    return;
                }
                if (GenericHistoryView.this.lastSelectedElement != null) {
                    Object resource;
                    Object object = GenericHistoryView.this.lastSelectedElement;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((resource = Utils.getAdapter(object, clazz)) != null) {
                        GenericHistoryView.this.itemDropped((IResource)resource, false);
                    } else {
                        GenericHistoryView.this.itemDropped(GenericHistoryView.this.lastSelectedElement, false);
                    }
                    GenericHistoryView.this.lastSelectedElement = null;
                }
            }
        }
    };
    private boolean linkingEnabled;
    private boolean viewPinned;
    public static final String VIEW_ID = "org.eclipse.team.ui.GenericHistoryView";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    void refreshGlobalActionHandlers() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.clearGlobalActionHandlers();
        Map newActionHandlers = this.currentPageContainer.getSubBars().getGlobalActionHandlers();
        if (newActionHandlers != null) {
            Set keys = newActionHandlers.entrySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                bars.setGlobalActionHandler((String)entry.getKey(), (IAction)entry.getValue());
            }
        }
        bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
    }

    public void createPartControl(Composite parent) {
        this.book = new PageBook(parent, 0);
        this.linkingEnabled = TeamUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_generichistory_view_linking");
        this.defaultPageContainer = this.createDefaultPage(this.book);
        this.configureToolbars(this.getViewSite().getActionBars());
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        this.initDragAndDrop();
        this.showPageRec(this.defaultPageContainer);
        this.getSite().getPage().addPartListener(this.partListener);
        this.getSite().getPage().addPartListener(this.partListener2);
        this.getSite().getPage().addSelectionListener(this.selectionListener);
    }

    private void configureToolbars(IActionBars actionBars) {
        this.pinAction = new Action(TeamUIMessages.GenericHistoryView_PinCurrentHistory, TeamUIPlugin.getImageDescriptor("elcl16/pin.gif")){

            public void run() {
                if (this.isChecked()) {
                    GenericHistoryView.this.linkWithEditorAction.setChecked(false);
                    GenericHistoryView.this.linkWithEditorAction.setEnabled(false);
                    GenericHistoryView.this.setLinkingEnabled(false);
                } else {
                    GenericHistoryView.this.linkWithEditorAction.setEnabled(true);
                }
                GenericHistoryView.this.setViewPinned(this.isChecked());
            }
        };
        this.pinAction.setChecked(this.isViewPinned());
        this.pinAction.setToolTipText(TeamUIMessages.GenericHistoryView_0);
        this.refreshAction = new Action(TeamUIMessages.GenericHistoryView_Refresh, TeamUIPlugin.getImageDescriptor("elcl16/refresh.gif")){

            public void run() {
                ((IHistoryPage)GenericHistoryView.this.currentPageContainer.getPage()).refresh();
            }
        };
        this.refreshAction.setToolTipText(TeamUIMessages.GenericHistoryView_RefreshTooltip);
        this.refreshAction.setEnabled(true);
        this.linkWithEditorAction = new Action(TeamUIMessages.GenericHistoryView_LinkWithEditor, TeamUIPlugin.getImageDescriptor("elcl16/synced.gif")){

            public void run() {
                GenericHistoryView.this.setLinkingEnabled(GenericHistoryView.this.isViewPinned() ? false : this.isChecked());
            }
        };
        this.linkWithEditorAction.setChecked(this.isLinkingEnabled());
        this.linkWithEditorAction.setToolTipText(TeamUIMessages.GenericHistoryView_LinkWithTooltip);
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.add((IContributionItem)new Separator("historyView"));
        tbm.appendToGroup("historyView", (IAction)this.refreshAction);
        tbm.appendToGroup("historyView", (IAction)this.linkWithEditorAction);
        tbm.appendToGroup("historyView", (IAction)this.pinAction);
        tbm.update(false);
    }

    boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    public void setLinkingEnabled(boolean enabled) {
        this.linkingEnabled = enabled;
        TeamUIPlugin.getPlugin().getPreferenceStore().setValue("pref_generichistory_view_linking", enabled);
        if (enabled) {
            this.editorActivated(this.getSite().getPage().getActiveEditor());
        }
    }

    void setViewPinned(boolean pinned) {
        this.viewPinned = pinned;
    }

    void initDragAndDrop() {
        int ops = 7;
        Transfer[] transfers = new Transfer[]{ResourceTransfer.getInstance(), PluginTransfer.getInstance()};
        this.dropTarget = new DropTarget((Control)this.book, ops);
        this.dropTarget.setTransfer(transfers);
        this.dropAdapter = new GenericHistoryDropAdapter(this);
        this.dropTarget.addDropListener((DropTargetListener)this.dropAdapter);
    }

    public void setFocus() {
        if (this.isLinkingEnabled() && this.lastSelectedElement != null) {
            if (this.lastSelectedElement instanceof IEditorPart) {
                this.editorActivated((IEditorPart)this.lastSelectedElement);
            } else {
                Object resource;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = Utils.getAdapter(this.lastSelectedElement, clazz)) != null) {
                    this.itemDropped((IResource)resource, false);
                } else {
                    this.itemDropped(this.lastSelectedElement, false);
                }
            }
            this.lastSelectedElement = null;
        }
        if (this.currentPageContainer.page instanceof IPage) {
            this.currentPageContainer.page.setFocus();
        }
    }

    protected void showPageRec(PageContainer pageContainer) {
        if (this.currentPageContainer == pageContainer) {
            return;
        }
        if (this.currentPageContainer != null && pageContainer != null && this.currentPageContainer == pageContainer) {
            this.currentPageContainer = pageContainer;
            return;
        }
        if (this.currentPageContainer != null) {
            this.currentPageContainer.getSubBars().deactivate();
            this.currentPageContainer.getPage().dispose();
            this.currentPageContainer.getSubBars().dispose();
        }
        this.currentPageContainer = pageContainer;
        Control pageControl = this.currentPageContainer.getPage().getControl();
        if (pageControl != null && !pageControl.isDisposed()) {
            this.book.showPage(pageControl);
            this.currentPageContainer.getSubBars().activate();
            this.refreshGlobalActionHandlers();
            this.getViewSite().getActionBars().updateActionBars();
        }
    }

    protected PageSite initPage(IPageBookViewPage page) {
        try {
            PageSite site = new PageSite(this.getViewSite());
            page.init((IPageSite)site);
            return site;
        }
        catch (PartInitException e) {
            TeamUIPlugin.log((CoreException)((Object)e));
            return null;
        }
    }

    public IHistoryPage itemDropped(Object object, boolean refresh) {
        if (!this.getSite().getPage().isPartVisible((IWorkbenchPart)this)) {
            return null;
        }
        IResource resource = Utils.getResource(object);
        if (resource != null) {
            IHistoryPage existingPage = this.checkForExistingPage(object, resource.getName(), refresh);
            if (existingPage != null) {
                return existingPage;
            }
            IHistoryPage pinnedPage = this.checkForPinnedView(object, resource.getName(), refresh);
            if (pinnedPage != null) {
                return pinnedPage;
            }
            RepositoryProvider teamProvider = RepositoryProvider.getProvider((IProject)resource.getProject());
            Object tempPageSource = null;
            if (teamProvider == null) {
                tempPageSource = new LocalHistoryPageSource();
            } else {
                IFileHistoryProvider fileHistory = teamProvider.getFileHistoryProvider();
                if (fileHistory != null) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.team.ui.history.IHistoryPageSource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    tempPageSource = Utils.getAdapter(fileHistory, clazz, true);
                }
                if (tempPageSource == null) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.team.ui.history.IHistoryPageSource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    tempPageSource = Utils.getAdapter(teamProvider, clazz, true);
                }
            }
            if (tempPageSource instanceof IHistoryPageSource) {
                IHistoryPageSource pageSource = (IHistoryPageSource)tempPageSource;
                if (this.currentPageContainer.getPage() instanceof IHistoryPage) {
                    PageContainer tempPageContainer = this.currentPageContainer;
                    if (!((IHistoryPage)tempPageContainer.getPage()).isValidInput(resource)) {
                        tempPageContainer = this.createPage(pageSource, resource);
                    }
                    if (tempPageContainer != null) {
                        if (((IHistoryPage)tempPageContainer.getPage()).setInput(resource)) {
                            this.setContentDescription(resource.getName());
                            this.showPageRec(tempPageContainer);
                            return (IHistoryPage)tempPageContainer.getPage();
                        }
                    } else {
                        this.showPageRec(this.defaultPageContainer);
                    }
                }
            }
        } else if (object != null) {
            IHistoryPageSource historyPageSource;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.team.ui.history.IHistoryPageSource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((historyPageSource = (IHistoryPageSource)Utils.getAdapter(object, clazz)) == null) {
                return null;
            }
            if (this.currentPageContainer.getPage() instanceof IHistoryPage) {
                PageContainer tempPageContainer = this.currentPageContainer;
                if (!((IHistoryPage)tempPageContainer.getPage()).isValidInput(object)) {
                    tempPageContainer = this.createPage(historyPageSource, object);
                }
                if (tempPageContainer != null) {
                    IHistoryPage existingPage = this.checkForExistingPage(object, ((IHistoryPage)tempPageContainer.getPage()).getName(), refresh);
                    if (existingPage != null) {
                        return existingPage;
                    }
                    IHistoryPage pinnedPage = this.checkForPinnedView(object, ((IHistoryPage)tempPageContainer.getPage()).getName(), refresh);
                    if (pinnedPage != null) {
                        return pinnedPage;
                    }
                    if (((IHistoryPage)tempPageContainer.getPage()).setInput(object)) {
                        this.setContentDescription(((IHistoryPage)tempPageContainer.getPage()).getName());
                        this.showPageRec(tempPageContainer);
                        return (IHistoryPage)tempPageContainer.getPage();
                    }
                } else {
                    this.showPageRec(this.defaultPageContainer);
                }
            }
        }
        return null;
    }

    private IHistoryPage checkForPinnedView(Object object, String objectName, boolean refresh) {
        if (this.isViewPinned()) {
            try {
                IViewPart view = null;
                String id = VIEW_ID + System.currentTimeMillis();
                IHistoryPage page = this.searchHistoryViewsForObject(object, refresh);
                if (page != null) {
                    return page;
                }
                GenericHistoryView historyView = this.findUnpinnedHistoryView();
                if (historyView != null) {
                    this.getSite().getPage().activate((IWorkbenchPart)historyView);
                    return historyView.itemDropped(object, refresh);
                }
                view = this.getSite().getPage().showView(VIEW_ID, id, 3);
                this.getSite().getPage().activate((IWorkbenchPart)view);
                if (view instanceof GenericHistoryView) {
                    return ((GenericHistoryView)view).itemDropped(object, refresh);
                }
            }
            catch (PartInitException partInitException) {}
        }
        return null;
    }

    private IHistoryPage checkForExistingPage(Object object, String objectName, boolean refresh) {
        if (this.currentPageContainer != null && ((IHistoryPage)this.currentPageContainer.getPage()).getInput() != null && ((IHistoryPage)this.currentPageContainer.getPage()).getInput().equals(object)) {
            IHistoryPage tempPage = (IHistoryPage)this.currentPageContainer.getPage();
            if (refresh) {
                tempPage.refresh();
            }
            return tempPage;
        }
        return this.searchHistoryViewsForObject(object, refresh);
    }

    private IHistoryPage searchHistoryViewsForObject(Object object, boolean refresh) {
        IWorkbenchPage page = this.getSite().getPage();
        IViewReference[] historyViews = page.getViewReferences();
        int i = 0;
        while (i < historyViews.length) {
            Object input;
            IHistoryPage historyPage;
            IViewPart historyView;
            if (historyViews[i].getId().equals(VIEW_ID) && (historyView = historyViews[i].getView(true)) != null && (historyPage = ((IHistoryView)historyView).getHistoryPage()) != null && (input = historyPage.getInput()) != null && input.equals(object)) {
                this.getSite().getPage().bringToTop((IWorkbenchPart)historyView);
                return ((GenericHistoryView)historyView).itemDropped(object, refresh);
            }
            ++i;
        }
        return null;
    }

    private GenericHistoryView findUnpinnedHistoryView() {
        IWorkbenchPage page = this.getSite().getPage();
        IViewReference[] historyViews = page.getViewReferences();
        int i = 0;
        while (i < historyViews.length) {
            IViewPart historyView;
            if (historyViews[i].getId().equals(VIEW_ID) && !((GenericHistoryView)(historyView = historyViews[i].getView(false))).isViewPinned()) {
                return (GenericHistoryView)historyView;
            }
            ++i;
        }
        return null;
    }

    boolean isViewPinned() {
        return this.viewPinned;
    }

    private PageContainer createPage(IHistoryPageSource participant, Object object) {
        Page page = participant.createPage(object);
        PageSite site = this.initPage((IPageBookViewPage)page);
        ((IHistoryPage)page).setSite(new WorkbenchHistoryPageSite((IWorkbenchPart)this, page.getSite()));
        page.createControl((Composite)this.book);
        PageContainer container = new PageContainer(page);
        container.setSubBars((SubActionBars)site.getActionBars());
        return container;
    }

    protected PageContainer createDefaultPage(PageBook book) {
        GenericHistoryViewDefaultPage page = new GenericHistoryViewDefaultPage();
        PageSite site = this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        PageContainer container = new PageContainer(page);
        container.setSubBars((SubActionBars)site.getActionBars());
        return container;
    }

    protected void editorActivated(IEditorPart editor) {
        if (editor != null && !this.checkIfPageIsVisible()) {
            this.lastSelectedElement = editor;
        }
        if (editor == null || !this.isLinkingEnabled() || !this.checkIfPageIsVisible() || this.isViewPinned()) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        if (input instanceof FileRevisionEditorInput) {
            Object fileRev;
            FileRevisionEditorInput fileRevisionEditorInput = (FileRevisionEditorInput)input;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.team.core.history.IFileRevision");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((fileRev = fileRevisionEditorInput.getAdapter(clazz)) != null) {
                this.itemDropped(fileRev, false);
            }
        } else {
            Object pageSource;
            Class<?> clazz;
            IFile file = ResourceUtil.getFile((IEditorInput)input);
            if (file != null) {
                this.itemDropped(file, false);
            }
            if ((clazz = class$1) == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.team.ui.history.IHistoryPageSource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((pageSource = Utils.getAdapter(input, clazz)) != null) {
                this.itemDropped(input, false);
            }
        }
    }

    private boolean checkIfPageIsVisible() {
        return this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this);
    }

    public void dispose() {
        super.dispose();
        if (this.dropTarget != null && !this.dropTarget.isDisposed()) {
            this.dropTarget.removeDropListener((DropTargetListener)this.dropAdapter);
        }
        this.currentPageContainer.getPage().dispose();
        this.defaultPageContainer.getPage().dispose();
        this.currentPageContainer = null;
        this.defaultPageContainer = null;
        this.getSite().getPage().removePartListener(this.partListener);
        this.getSite().getPage().removePartListener(this.partListener2);
        this.getSite().getPage().removeSelectionListener(this.selectionListener);
    }

    public IHistoryPage showHistoryFor(Object object) {
        return this.itemDropped(object, true);
    }

    public IHistoryPage getHistoryPage() {
        if (this.currentPageContainer != null && this.currentPageContainer.getPage() != null) {
            return (IHistoryPage)this.currentPageContainer.getPage();
        }
        return (IHistoryPage)this.defaultPageContainer.getPage();
    }

    public void updateContentDescription(String description) {
        this.setContentDescription(description);
    }

    class PageContainer {
        private Page page;
        private SubActionBars subBars;

        public PageContainer(Page page) {
            this.page = page;
        }

        public Page getPage() {
            return this.page;
        }

        public void setPage(Page page) {
            this.page = page;
        }

        public SubActionBars getSubBars() {
            return this.subBars;
        }

        public void setSubBars(SubActionBars subBars) {
            this.subBars = subBars;
        }
    }
}

