/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.photran.internal.core.lexer.DynamicIntArray;
import org.eclipse.photran.internal.core.lexer.OffsetLineReader;
import org.eclipse.photran.internal.core.lexer.PreLexerLine;

class FixedFormLexerPrepass {
    static final int inStart = 0;
    static final int inHollerith = 1;
    static final int inDblQuote = 2;
    static final int inDblQuoteEnd = 3;
    static final int inQuote = 4;
    static final int inQuoteEnd = 5;
    private int state = 0;
    int hollerithLength = -2;
    private int actLinePos = 0;
    private PreLexerLine actLine = null;
    private OffsetLineReader in;
    private DynamicIntArray lineMapping = new DynamicIntArray(1000);
    private DynamicIntArray columnMapping = new DynamicIntArray(1000);
    private DynamicIntArray offsetMapping = new DynamicIntArray(1000);
    private int EOFLinePos = 0;
    private int EOFColPos = 0;
    private int EOFOffsetPos = 0;

    public FixedFormLexerPrepass(Reader in) {
        this.in = new OffsetLineReader(in);
    }

    public FixedFormLexerPrepass(InputStream in) {
        this(new InputStreamReader(in));
    }

    public int getLine(int absCharPos) {
        if (absCharPos < 0) {
            return 0;
        }
        int lastCharPos = this.lineMapping.length() - 1;
        return this.lineMapping.get(Math.min(absCharPos, lastCharPos));
    }

    public int getColumn(int absCharPos) {
        if (absCharPos < 0) {
            return 0;
        }
        int lastCharPos = this.lineMapping.length() - 1;
        return this.columnMapping.get(Math.min(absCharPos, lastCharPos));
    }

    public int getOffset(int absCharPos) {
        if (absCharPos < 0) {
            return absCharPos;
        }
        int lastCharPos = this.lineMapping.length() - 1;
        return this.offsetMapping.get(Math.min(absCharPos, lastCharPos));
    }

    public int read() throws Exception {
        int c = this.internalRead();
        return c;
    }

    private void markPosition(int line, int col, int offset) {
        this.offsetMapping.pushBack(offset);
        this.lineMapping.pushBack(line);
        this.columnMapping.pushBack(col);
    }

    private int internalRead() throws Exception {
        while (true) {
            if (this.actLine == null) {
                this.actLine = this.getNextNonCommentLine();
                if (this.actLine == null) {
                    this.markPosition(this.EOFLinePos, this.EOFColPos, this.EOFOffsetPos);
                    return -1;
                }
                this.actLinePos = 0;
            } else if (this.actLinePos == this.actLine.length() || this.actLinePos == 72) {
                PreLexerLine prevLine = this.actLine;
                this.actLine = this.getNextNonCommentLine();
                if (this.actLine == null) {
                    this.hollerithLength = -2;
                    this.state = 0;
                    this.markPosition(prevLine.linePos, this.actLinePos, prevLine.offset + this.actLinePos + 1);
                    return 10;
                }
                if (this.actLine.type == 1) {
                    this.actLinePos = 6;
                } else {
                    this.actLinePos = 0;
                    this.hollerithLength = -2;
                    this.state = 0;
                    this.markPosition(prevLine.linePos, prevLine.length(), prevLine.offset + prevLine.length());
                    return 10;
                }
            }
            this.actLinePos = this.getNextSigPos(this.actLine, this.actLinePos);
            if (this.actLinePos >= 0) break;
            this.actLinePos = this.actLine.length();
        }
        this.markPosition(this.actLine.linePos, this.actLinePos, this.actLine.offset + this.actLinePos);
        return this.actLine.charAt(this.actLinePos++);
    }

    private PreLexerLine getNextNonCommentLine() {
        PreLexerLine line;
        do {
            if ((line = this.getNextLine()) != null) continue;
            return null;
        } while (line.type == 0);
        return line;
    }

    private PreLexerLine getNextLine() {
        String line;
        int actOffset;
        block3: {
            try {
                actOffset = this.in.getOffset();
                line = this.in.readLine();
                if (line != null) break block3;
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        this.EOFLinePos = this.in.getLineNumber() - 1;
        this.EOFColPos = line.length();
        this.EOFOffsetPos = actOffset;
        PreLexerLine pll = new PreLexerLine(line, this.in.getLineNumber() - 1, actOffset);
        return pll;
    }

    private int getNextSigPos(PreLexerLine line, int startPos) {
        int charPos = startPos;
        while (charPos < line.length()) {
            char c = line.charAt(charPos);
            if (line.type == 3) {
                return charPos;
            }
            if (line.type != 1 || charPos > 5) {
                if (this.state == 0) {
                    if (c != ' ' && c != '\t') {
                        if (c == '!') {
                            return -1;
                        }
                        if (charPos > 4 || Character.isDigit(c)) {
                            if (c == '\'') {
                                this.hollerithLength = -1;
                                this.state = 4;
                            } else if (c == '\"') {
                                this.hollerithLength = -1;
                                this.state = 2;
                            } else if (c == 'h' || c == 'H') {
                                if (this.hollerithLength > 0) {
                                    this.state = 1;
                                } else if (this.hollerithLength < 0) {
                                    this.hollerithLength = -2;
                                }
                            } else {
                                this.hollerithLength = this.hollerithLength != -2 && Character.isDigit(c) ? (this.hollerithLength == -1 ? Character.digit(c, 10) : this.hollerithLength * 10 + Character.digit(c, 10)) : (Character.isLetter(c) || c == '_' ? -2 : (charPos == 0 ? -2 : -1));
                            }
                            return charPos;
                        }
                    }
                } else {
                    if (this.state == 4) {
                        if (c == '\'') {
                            this.state = 5;
                        }
                        return charPos;
                    }
                    if (this.state == 5) {
                        if (c == '\'') {
                            this.state = 4;
                            return charPos;
                        }
                        this.state = 0;
                        --charPos;
                    } else {
                        if (this.state == 2) {
                            if (c == '\"') {
                                this.state = 5;
                            }
                            return charPos;
                        }
                        if (this.state == 3) {
                            if (c == '\"') {
                                this.state = 2;
                                return charPos;
                            }
                            this.state = 0;
                            --charPos;
                        } else {
                            if (this.state == 1) {
                                --this.hollerithLength;
                                if (this.hollerithLength == 0) {
                                    this.state = 0;
                                }
                                return charPos;
                            }
                            throw new RuntimeException("Undefined state in FixedFormPreLexer");
                        }
                    }
                }
            }
            ++charPos;
        }
        return -1;
    }
}

