/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.photran.internal.core.properties.SearchPathProperties;

public class IncludeLoaderCallback {
    protected IProject project;

    public IncludeLoaderCallback(IProject project) {
        this.project = project;
    }

    public InputStream getIncludedFileAsStream(String fileToInclude) throws FileNotFoundException {
        String[] paths = SearchPathProperties.parseString(SearchPathProperties.getProperty(this.project, "FortranIncludePaths"));
        int i = 0;
        while (i < paths.length) {
            IResource result = ResourcesPlugin.getWorkspace().getRoot().findMember(String.valueOf(paths[i]) + File.separatorChar + fileToInclude);
            if (result != null && result instanceof IFile) {
                try {
                    return ((IFile)result).getContents();
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        throw new FileNotFoundException(fileToInclude);
    }

    public String onUnableToLoad(String message, String filename) {
        return message;
    }
}

