/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.parser;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTVisitor;
import org.eclipse.photran.internal.core.parser.AbstractParseTreeNode;
import org.eclipse.photran.internal.core.parser.GenericParseTreeVisitor;
import org.eclipse.photran.internal.core.parser.Nonterminal;
import org.eclipse.photran.internal.core.parser.ParseTreeVisitor;
import org.eclipse.photran.internal.core.parser.Production;

public class ParseTreeNode
extends AbstractParseTreeNode {
    public static final AbstractParseTreeNode EMPTY = new EmptyNode();
    private Nonterminal nonterminal;
    private Production production;
    private AbstractParseTreeNode[] childArray;
    private int numChildren;

    public ParseTreeNode(Nonterminal nonterminal, Production production) {
        this.nonterminal = nonterminal;
        this.production = production;
        this.childArray = null;
        this.numChildren = 0;
    }

    public Nonterminal getNonterminal() {
        return this.nonterminal;
    }

    public Production getProduction() {
        return this.production;
    }

    public void addChild(AbstractParseTreeNode child) {
        if (child == null) {
            child = EMPTY;
        }
        this.ensureCapacity();
        this.childArray[this.numChildren++] = child;
        child.parent = this;
    }

    private void ensureCapacity() {
        if (this.childArray == null) {
            this.childArray = new AbstractParseTreeNode[16];
        } else if (this.numChildren >= this.childArray.length) {
            this.expandArray();
        }
    }

    private void expandArray() {
        AbstractParseTreeNode[] newChildArray = new AbstractParseTreeNode[Math.min(this.childArray.length * 2, 1024)];
        System.arraycopy(this.childArray, 0, newChildArray, 0, this.childArray.length);
        this.childArray = newChildArray;
    }

    public void addErrorChild(LinkedList child) {
        if (child == null) {
            return;
        }
        Iterator it = child.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Token)) continue;
            this.addChild((Token)o);
        }
    }

    public void addChild(int index, AbstractParseTreeNode nodeToAdd) {
        if (index < 0 || index > this.numChildren) {
            throw new IllegalArgumentException("Invalid index " + index);
        }
        this.ensureCapacity();
        int i = this.numChildren;
        while (i >= index) {
            this.childArray[i + 1] = this.childArray[i];
            --i;
        }
        this.childArray[index] = nodeToAdd;
        ++this.numChildren;
    }

    public int findChild(AbstractParseTreeNode child) {
        if (this.childArray == null) {
            return -1;
        }
        int i = 0;
        while (i < this.numChildren) {
            if (this.childArray[i].equals(child)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean removeChild(AbstractParseTreeNode childToRemove) {
        int index = this.findChild(childToRemove);
        return index < 0 ? false : this.removeChild(index);
    }

    public boolean removeChild(int index) {
        if (index < 0 || index >= this.numChildren) {
            throw new IllegalArgumentException("Invalid index " + index);
        }
        if (this.childArray == null) {
            return false;
        }
        int i = index + 1;
        while (i < this.numChildren) {
            this.childArray[i - 1] = this.childArray[i];
            ++i;
        }
        --this.numChildren;
        return true;
    }

    private AbstractParseTreeNode privateGetChild(int index) {
        if (index < 0 || index >= this.numChildren) {
            throw new IllegalArgumentException("Invalid index " + index);
        }
        if (this.childArray == null) {
            return null;
        }
        AbstractParseTreeNode result = this.childArray[index];
        return result == EMPTY ? null : result;
    }

    public ParseTreeNode getChild(int index) {
        AbstractParseTreeNode result = this.privateGetChild(index);
        if (result == null || result instanceof ParseTreeNode) {
            return (ParseTreeNode)result;
        }
        throw new IllegalArgumentException("The child at index " + index + " is a " + result.getClass().getName() + ", not a ParseTreeNode");
    }

    public ParseTreeNode getChild(String name) {
        int index = this.production.getNamedIndex(name);
        return index < 0 ? null : this.getChild(index);
    }

    public Token getChildToken(int index) {
        AbstractParseTreeNode result = this.privateGetChild(index);
        if (result == null || result instanceof Token) {
            return (Token)result;
        }
        throw new IllegalArgumentException("The child at index " + index + " is a " + result.getClass().getName() + ", not a Token");
    }

    public Token getChildToken(String name) {
        int index = this.production.getNamedIndex(name);
        return index < 0 ? null : this.getChildToken(index);
    }

    public int getNumberOfChildren() {
        return this.numChildren;
    }

    public void visitTopDownUsing(ASTVisitor visitor) {
        this.visitThisNodeUsing(visitor);
        if (this.childArray != null) {
            int i = 0;
            while (i < this.numChildren) {
                this.childArray[i].visitTopDownUsing(visitor);
                ++i;
            }
        }
    }

    public void visitBottomUpUsing(ASTVisitor visitor) {
        if (this.childArray != null) {
            int i = 0;
            while (i < this.numChildren) {
                this.childArray[i].visitBottomUpUsing(visitor);
                ++i;
            }
        }
        this.visitThisNodeUsing(visitor);
    }

    public void visitOnlyThisNodeUsing(ASTVisitor visitor) {
        this.visitThisNodeUsing(visitor);
    }

    protected void visitThisNodeUsing(ASTVisitor visitor) {
    }

    public void visitUsing(ParseTreeVisitor visitor) {
        this.nonterminal.visitParseTreeNodeUsing(this, visitor);
        visitor.preparingToVisitChildrenOf(this);
        if (this.childArray != null) {
            int i = 0;
            while (i < this.numChildren) {
                this.childArray[i].visitUsing(visitor);
                ++i;
            }
        }
        visitor.doneVisitingChildrenOf(this);
    }

    public void visitUsing(GenericParseTreeVisitor visitor) {
        visitor.visitParseTreeNode(this);
        visitor.preparingToVisitChildrenOf(this);
        if (this.childArray != null) {
            int i = 0;
            while (i < this.numChildren) {
                this.childArray[i].visitUsing(visitor);
                ++i;
            }
        }
        visitor.doneVisitingChildrenOf(this);
    }

    public String toString(int numSpaces) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.indent(numSpaces));
        sb.append(this.nonterminal.getDescription());
        sb.append("\n");
        if (this.childArray != null) {
            int i = 0;
            while (i < this.numChildren) {
                sb.append(this.childArray[i].toString(numSpaces + 4));
                ++i;
            }
        }
        return sb.toString();
    }

    public String printOn(PrintStream out, String currentPreprocessorDirective) {
        if (this.childArray != null) {
            int i = 0;
            while (i < this.numChildren) {
                currentPreprocessorDirective = this.childArray[i].printOn(out, currentPreprocessorDirective);
                ++i;
            }
        }
        return currentPreprocessorDirective;
    }

    private static final class EmptyNode
    extends AbstractParseTreeNode {
        private EmptyNode() {
        }

        public void visitBottomUpUsing(ASTVisitor visitor) {
        }

        public void visitTopDownUsing(ASTVisitor visitor) {
        }

        public void visitUsing(ParseTreeVisitor visitor) {
        }

        public void visitUsing(GenericParseTreeVisitor visitor) {
        }

        public String toString(int numSpaces) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.indent(numSpaces));
            sb.append("(empty node)");
            sb.append("\n");
            return sb.toString();
        }

        public String printOn(PrintStream out, String currentPreprocessorDirective) {
            return currentPreprocessorDirective;
        }
    }
}

