/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.properties;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;

public class SearchPathProperties {
    public static final String MODULE_PATHS_PROPERTY_NAME = "FortranModulePaths";
    public static final String INCLUDE_PATHS_PROPERTY_NAME = "FortranIncludePaths";

    public static String getProperty(IProject project, String propertyName) {
        try {
            String result = project.getPersistentProperty(new QualifiedName("", propertyName));
            if (result == null) {
                result = SearchPathProperties.getPropertyDefault(project, propertyName);
            }
            return result;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static String getPropertyDefault(IProject project, String propertyName) {
        return String.valueOf(project.getFullPath().toOSString()) + File.pathSeparator;
    }

    public static void setProperty(IProject project, String propertyName, String value) {
        try {
            project.setPersistentProperty(new QualifiedName("", propertyName), value);
        }
        catch (CoreException coreException) {}
    }

    public static String createList(String[] items) {
        StringBuffer path = new StringBuffer("");
        int i = 0;
        while (i < items.length) {
            path.append(items[i]);
            path.append(File.pathSeparator);
            ++i;
        }
        return path.toString();
    }

    public static String[] parseString(String stringList) {
        StringTokenizer st = new StringTokenizer(stringList, String.valueOf(File.pathSeparator) + "\n\r");
        ArrayList<String> v = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v.toArray(new String[v.size()]);
    }
}

