/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.ptp.debug.core.PCDIDebugModel;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDISignal;
import org.eclipse.ptp.debug.core.model.IPSignal;
import org.eclipse.ptp.debug.internal.core.model.PDebugTarget;
import org.eclipse.ptp.debug.internal.core.model.PSignal;

public class PSignalManager
implements IAdaptable {
    private PDebugTarget fDebugTarget;
    private IPSignal[] fSignals = null;
    private boolean fIsDisposed = false;

    public PSignalManager(PDebugTarget target) {
        this.fDebugTarget = target;
    }

    public IPSignal[] getSignals() throws DebugException {
        if (!this.isDisposed() && this.fSignals == null) {
            try {
                IPCDISignal[] cdiSignals = this.getDebugTarget().getCDITarget().getSignals();
                ArrayList<PSignal> list = new ArrayList<PSignal>(cdiSignals.length);
                int i = 0;
                while (i < cdiSignals.length) {
                    list.add(new PSignal(this.getDebugTarget(), cdiSignals[i]));
                    ++i;
                }
                this.fSignals = list.toArray(new IPSignal[list.size()]);
            }
            catch (PCDIException e) {
                this.throwDebugException(e.getMessage(), 5010, (Throwable)((Object)e));
            }
        }
        return this.fSignals != null ? this.fSignals : new IPSignal[]{};
    }

    public void dispose() {
        if (this.fSignals != null) {
            int i = 0;
            while (i < this.fSignals.length) {
                ((PSignal)this.fSignals[i]).dispose();
                ++i;
            }
        }
        this.fSignals = null;
        this.fIsDisposed = true;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(PSignalManager.class)) {
            return this;
        }
        if (adapter.equals(PDebugTarget.class)) {
            return this.getDebugTarget();
        }
        return null;
    }

    public void signalChanged(IPCDISignal cdiSignal) {
        PSignal signal = this.find(cdiSignal);
        if (signal != null) {
            signal.fireChangeEvent(256);
        }
    }

    private PSignal find(IPCDISignal cdiSignal) {
        try {
            IPSignal[] signals = this.getSignals();
            int i = 0;
            while (i < signals.length) {
                if (signals[i].getName().equals(cdiSignal.getName())) {
                    return (PSignal)signals[i];
                }
                ++i;
            }
        }
        catch (DebugException debugException) {}
        return null;
    }

    protected boolean isDisposed() {
        return this.fIsDisposed;
    }

    protected void throwDebugException(String message, int code, Throwable exception) throws DebugException {
        throw new DebugException((IStatus)new Status(4, PCDIDebugModel.getPluginIdentifier(), code, message, exception));
    }

    protected PDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }
}

