/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.model.ICModule;
import org.eclipse.cdt.debug.core.model.IDebuggerProcessSupport;
import org.eclipse.cdt.debug.core.model.IDisassembly;
import org.eclipse.cdt.debug.core.model.IPersistableRegisterGroup;
import org.eclipse.cdt.debug.core.model.IRegisterDescriptor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionListener;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.cdi.IPCDIBreakpointHit;
import org.eclipse.ptp.debug.core.cdi.IPCDIEndSteppingRange;
import org.eclipse.ptp.debug.core.cdi.IPCDIErrorInfo;
import org.eclipse.ptp.debug.core.cdi.IPCDISession;
import org.eclipse.ptp.debug.core.cdi.IPCDISessionConfiguration;
import org.eclipse.ptp.debug.core.cdi.IPCDISessionObject;
import org.eclipse.ptp.debug.core.cdi.IPCDISharedLibraryEvent;
import org.eclipse.ptp.debug.core.cdi.IPCDISignalReceived;
import org.eclipse.ptp.debug.core.cdi.IPCDIWatchpointScope;
import org.eclipse.ptp.debug.core.cdi.IPCDIWatchpointTrigger;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIChangedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDICreatedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIDestroyedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIDisconnectedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEventListener;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIExitedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIRestartedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIResumedEvent;
import org.eclipse.ptp.debug.core.cdi.event.IPCDISuspendedEvent;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIGlobalVariableDescriptor;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIObject;
import org.eclipse.ptp.debug.core.cdi.model.IPCDISignal;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITarget;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITargetConfiguration;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIThread;
import org.eclipse.ptp.debug.core.launch.IPLaunch;
import org.eclipse.ptp.debug.core.model.IExecFileInfo;
import org.eclipse.ptp.debug.core.model.IGlobalVariableDescriptor;
import org.eclipse.ptp.debug.core.model.IPBreakpoint;
import org.eclipse.ptp.debug.core.model.IPDebugElement;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.core.model.IPGlobalVariable;
import org.eclipse.ptp.debug.core.model.IPGlobalVariableManager;
import org.eclipse.ptp.debug.core.model.IPLineBreakpoint;
import org.eclipse.ptp.debug.core.model.IPSignal;
import org.eclipse.ptp.debug.core.model.PDebugElementState;
import org.eclipse.ptp.debug.core.sourcelookup.IPSourceLocator;
import org.eclipse.ptp.debug.core.sourcelookup.ISourceLookupChangeListener;
import org.eclipse.ptp.debug.internal.core.PGlobalVariableManager;
import org.eclipse.ptp.debug.internal.core.PSignalManager;
import org.eclipse.ptp.debug.internal.core.PTPMemoryBlockRetrievalExtension;
import org.eclipse.ptp.debug.internal.core.model.CoreModelMessages;
import org.eclipse.ptp.debug.internal.core.model.PDebugElement;
import org.eclipse.ptp.debug.internal.core.model.PExpression;
import org.eclipse.ptp.debug.internal.core.model.PThread;
import org.eclipse.ptp.debug.internal.core.model.PVariableFactory;
import org.eclipse.ptp.debug.internal.core.sourcelookup.PSourceLookupParticipant;
import org.eclipse.ptp.debug.internal.core.sourcelookup.PSourceManager;

public class PDebugTarget
extends PDebugElement
implements IPDebugTarget,
IPCDIEventListener,
ILaunchListener,
IExpressionListener,
ISourceLookupChangeListener {
    private final String PROCESS_NAME = "Process ";
    private ArrayList fThreads;
    private IProcess fDebuggeeProcess = null;
    private IPCDITarget fCDITarget;
    private IPLaunch fLaunch;
    private IPCDITargetConfiguration fConfig;
    private PGlobalVariableManager fGlobalVariableManager;
    private PSignalManager fSignalManager;
    private IBinaryParser.IBinaryObject fBinaryFile;
    private Boolean fIsLittleEndian = null;
    private Preferences fPreferences = null;
    private IAddressFactory fAddressFactory;
    private PTPMemoryBlockRetrievalExtension fMemoryBlockRetrieval;

    public PDebugTarget(IPLaunch launch, IPCDITarget cdiTarget, IProcess debuggeeProcess, IBinaryParser.IBinaryObject file, boolean allowsTerminate, boolean allowsDisconnect) {
        super(null);
        this.fLaunch = launch;
        this.fCDITarget = cdiTarget;
        this.setDebugTarget(this);
        this.setProcess(debuggeeProcess);
        this.setExecFile(file);
        this.initializePreferences();
        this.setConfiguration(cdiTarget.getConfiguration());
        this.setThreadList(new ArrayList(5));
        if (this.fCDITarget.isTerminated()) {
            this.setState(PDebugElementState.TERMINATED);
        } else {
            if (this.fCDITarget.isSuspended()) {
                this.setState(PDebugElementState.SUSPENDED);
            } else {
                this.setState(PDebugElementState.UNDEFINED);
            }
            this.setGlobalVariableManager(new PGlobalVariableManager(this));
            this.setMemoryBlockRetrieval(new PTPMemoryBlockRetrievalExtension(this));
            this.setSignalManager(new PSignalManager(this));
            this.initialize();
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
            DebugPlugin.getDefault().getExpressionManager().addExpressionListener((IExpressionListener)this);
            this.getCDISession().getEventManager().addEventListener(this);
        }
    }

    public int getTargetID() {
        return this.fCDITarget.getTargetID();
    }

    public BitList getTask() {
        return this.fCDITarget.getTask();
    }

    private PTPMemoryBlockRetrievalExtension getMemoryBlockRetrieval() {
        return this.fMemoryBlockRetrieval;
    }

    private void setMemoryBlockRetrieval(PTPMemoryBlockRetrievalExtension memoryBlockRetrieval) {
        this.fMemoryBlockRetrieval = memoryBlockRetrieval;
    }

    protected void initialize() {
        this.initializeSourceLookupPath();
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(1);
        debugEvents.add(this.createCreateEvent());
        this.initializeThreads(debugEvents);
        this.initializeSourceManager();
        this.initializeMemoryBlocks();
        this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
    }

    protected void initializeThreads(List debugEvents) {
        IPCDIThread[] cdiThreads = new IPCDIThread[]{};
        try {
            if (this.isSuspended()) {
                cdiThreads = this.getCDITarget().getThreads();
            }
        }
        catch (PCDIException pCDIException) {}
        DebugEvent suspendEvent = null;
        int i = 0;
        while (i < cdiThreads.length) {
            PThread thread = this.createThread(cdiThreads[i]);
            debugEvents.add(thread.createCreateEvent());
            try {
                if (cdiThreads[i].equals(this.getCDITarget().getCurrentThread()) && thread.isSuspended()) {
                    suspendEvent = thread.createSuspendEvent(16);
                }
            }
            catch (PCDIException pCDIException) {}
            ++i;
        }
        if (suspendEvent != null) {
            debugEvents.add(suspendEvent);
        }
    }

    protected void initializeMemoryBlocks() {
        this.getMemoryBlockRetrieval().initialize();
    }

    protected void initializeSourceManager() {
        ISourceLocator locator = this.getLaunch().getSourceLocator();
        if (locator instanceof IAdaptable) {
            IResourceChangeListener listener;
            PSourceManager sm;
            IPSourceLocator clocator = (IPSourceLocator)((IAdaptable)locator).getAdapter(IPSourceLocator.class);
            if (clocator instanceof IAdaptable && (sm = (PSourceManager)((IAdaptable)clocator).getAdapter(PSourceManager.class)) != null) {
                sm.setDebugTarget(this);
            }
            if ((listener = (IResourceChangeListener)((IAdaptable)locator).getAdapter(IResourceChangeListener.class)) != null) {
                ResourcesPlugin.getWorkspace().addResourceChangeListener(listener);
            }
        }
    }

    protected void initializeSourceLookupPath() {
        ISourceLocator locator = this.getLaunch().getSourceLocator();
        if (locator instanceof ISourceLookupDirector) {
            ISourceLookupParticipant[] participants = ((ISourceLookupDirector)locator).getParticipants();
            int i = 0;
            while (i < participants.length) {
                if (participants[i] instanceof PSourceLookupParticipant) {
                    ((PSourceLookupParticipant)participants[i]).addSourceLookupChangeListener(this);
                }
                ++i;
            }
            this.setSourceLookupPath(((ISourceLookupDirector)locator).getSourceContainers());
        }
    }

    public IProcess getProcess() {
        return this.fDebuggeeProcess;
    }

    protected void setProcess(IProcess debuggeeProcess) {
        this.fDebuggeeProcess = debuggeeProcess;
    }

    public IThread[] getThreads() {
        ArrayList threads = this.getThreadList();
        return threads.toArray(new IThread[threads.size()]);
    }

    public boolean hasThreads() throws DebugException {
        return this.getThreadList().size() > 0;
    }

    public String getName() throws DebugException {
        return "Process " + this.getTargetID();
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (!this.getConfiguration().supportsBreakpoints()) {
            return false;
        }
        return breakpoint instanceof IPBreakpoint;
    }

    public void launchRemoved(ILaunch launch) {
        if (!this.isAvailable()) {
            return;
        }
        if (launch.equals(this.getLaunch())) {
            this.disconnected();
        }
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public boolean canTerminate() {
        return this.supportsTerminate() && this.isAvailable();
    }

    public boolean isTerminated() {
        return this.getState().equals(PDebugElementState.TERMINATED);
    }

    public void terminate() throws DebugException {
        if (!this.canTerminate()) {
            return;
        }
        this.changeState(PDebugElementState.TERMINATING);
        try {
            this.getCDITarget().terminate();
        }
        catch (PCDIException e) {
            this.restoreOldState();
            PDebugTarget.targetRequestFailed(e.getMessage(), null);
        }
    }

    public boolean canResume() {
        return this.getConfiguration().supportsResume() && this.isSuspended();
    }

    public boolean canSuspend() {
        if (!this.getConfiguration().supportsSuspend()) {
            return false;
        }
        if (this.getState().equals(PDebugElementState.RESUMED)) {
            IThread[] threads = this.getThreads();
            int i = 0;
            while (i < threads.length) {
                if (threads[i].isSuspended()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean isSuspended() {
        return this.getState().equals(PDebugElementState.SUSPENDED);
    }

    public void resume() throws DebugException {
        if (!this.canResume()) {
            return;
        }
        this.changeState(PDebugElementState.RESUMING);
        try {
            this.getCDITarget().resume(false);
        }
        catch (PCDIException e) {
            this.restoreOldState();
            PDebugTarget.targetRequestFailed(e.getMessage(), null);
        }
    }

    public void suspend() throws DebugException {
        if (!this.canSuspend()) {
            return;
        }
        this.changeState(PDebugElementState.SUSPENDING);
        try {
            this.getCDITarget().suspend();
        }
        catch (CDIException e) {
            this.restoreOldState();
            PDebugTarget.targetRequestFailed(e.getMessage(), null);
        }
    }

    protected boolean isSuspending() {
        return this.getState().equals(PDebugElementState.SUSPENDING);
    }

    protected void suspendThreads(IPCDISuspendedEvent event) {
        for (PThread thread : this.getThreadList()) {
            IPCDIThread suspensionThread = null;
            try {
                suspensionThread = this.getCDITarget().getCurrentThread();
            }
            catch (PCDIException pCDIException) {}
            thread.suspendByTarget(event.getReason(), suspensionThread);
        }
    }

    protected synchronized List refreshThreads() {
        ArrayList<PThread> newThreads = new ArrayList<PThread>(5);
        ArrayList<PThread> list = new ArrayList<PThread>(5);
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(5);
        List oldList = (List)this.getThreadList().clone();
        IPCDIThread[] cdiThreads = new IPCDIThread[]{};
        IPCDIThread currentCDIThread = null;
        try {
            cdiThreads = this.getCDITarget().getThreads();
            currentCDIThread = this.getCDITarget().getCurrentThread();
        }
        catch (PCDIException pCDIException) {}
        int i = 0;
        while (i < cdiThreads.length) {
            PThread thread = this.findThread(oldList, cdiThreads[i]);
            if (thread == null) {
                thread = new PThread(this, cdiThreads[i]);
                newThreads.add(thread);
            } else {
                oldList.remove(thread);
            }
            thread.setCurrent(cdiThreads[i].equals(currentCDIThread));
            list.add(thread);
            ++i;
        }
        for (PThread thread : oldList) {
            thread.terminated();
            debugEvents.add(thread.createTerminateEvent());
        }
        this.setThreadList(list);
        Iterator it = newThreads.iterator();
        while (it.hasNext()) {
            debugEvents.add(((PThread)it.next()).createCreateEvent());
        }
        if (debugEvents.size() > 0) {
            this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
        }
        return newThreads;
    }

    protected synchronized void resumeThreads(List debugEvents, int detail) {
        Iterator it = this.getThreadList().iterator();
        while (it.hasNext()) {
            ((PThread)it.next()).resumedByTarget(detail, debugEvents);
        }
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    protected boolean supportsDisconnect() {
        return false;
    }

    protected boolean supportsTerminate() {
        return this.getConfiguration().supportsTerminate();
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
        if (this.isDisconnecting()) {
            return;
        }
        this.changeState(PDebugElementState.DISCONNECTING);
        try {
            this.getCDITarget().disconnect();
        }
        catch (PCDIException e) {
            this.restoreOldState();
            PDebugTarget.targetRequestFailed(e.getMessage(), null);
        }
    }

    public boolean isDisconnected() {
        return this.getState().equals(PDebugElementState.DISCONNECTED);
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    protected ArrayList getThreadList() {
        return this.fThreads;
    }

    private void setThreadList(ArrayList threads) {
        this.fThreads = threads;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPDebugElement.class)) {
            return this;
        }
        if (adapter.equals(PDebugElement.class)) {
            return this;
        }
        if (adapter.equals(IDebugTarget.class)) {
            return this;
        }
        if (adapter.equals(IPDebugTarget.class)) {
            return this;
        }
        if (adapter.equals(PDebugTarget.class)) {
            return this;
        }
        if (adapter.equals(IPCDITarget.class)) {
            return this.fCDITarget;
        }
        if (adapter.equals(IDebuggerProcessSupport.class)) {
            return this;
        }
        if (adapter.equals(IExecFileInfo.class)) {
            return this;
        }
        if (adapter.equals(IPGlobalVariableManager.class)) {
            return this.getGlobalVariableManager();
        }
        if (adapter.equals(IPCDISession.class)) {
            return this.getCDISession();
        }
        if (adapter.equals(IMemoryBlockRetrievalExtension.class)) {
            return this.getMemoryBlockRetrieval();
        }
        if (adapter.equals(IMemoryBlockRetrieval.class)) {
            return this.getMemoryBlockRetrieval();
        }
        return super.getAdapter(adapter);
    }

    public void handleDebugEvents(IPCDIEvent[] events) {
        int i = 0;
        while (i < events.length) {
            IPCDIEvent event = events[i];
            if (!event.containTask(this.getTargetID())) {
                return;
            }
            IPCDIObject source = event.getSource(this.getTargetID());
            if (source == null && event instanceof IPCDIDestroyedEvent) {
                this.handleTerminatedEvent((IPCDIDestroyedEvent)event, source);
            } else if (source != null && source.getTarget().equals(this.getCDITarget())) {
                if (event instanceof IPCDICreatedEvent) {
                    if (source instanceof IPCDIThread) {
                        this.handleThreadCreatedEvent((IPCDICreatedEvent)event, source);
                    }
                } else if (event instanceof IPCDISuspendedEvent) {
                    if (source instanceof IPCDITarget) {
                        this.handleSuspendedEvent((IPCDISuspendedEvent)event, source);
                    }
                } else if (event instanceof IPCDIResumedEvent) {
                    if (source instanceof IPCDITarget) {
                        this.handleResumedEvent((IPCDIResumedEvent)event, source);
                    }
                } else if (event instanceof IPCDIExitedEvent) {
                    if (source instanceof IPCDITarget) {
                        this.handleExitedEvent((IPCDIExitedEvent)event, source);
                    }
                } else if (event instanceof IPCDIDestroyedEvent) {
                    if (source instanceof IPCDIThread) {
                        this.handleThreadTerminatedEvent((IPCDIDestroyedEvent)event, source);
                    }
                } else if (event instanceof IPCDIDisconnectedEvent) {
                    if (source instanceof IPCDITarget) {
                        this.handleDisconnectedEvent((IPCDIDisconnectedEvent)event, source);
                    }
                } else if (event instanceof IPCDIChangedEvent) {
                    if (source instanceof IPCDITarget) {
                        this.handleChangedEvent((IPCDIChangedEvent)event, source);
                    }
                    if (source instanceof IPCDISignal) {
                        this.getSignalManager().signalChanged((IPCDISignal)source);
                    }
                } else if (event instanceof IPCDIRestartedEvent && source instanceof IPCDITarget) {
                    this.handleRestartedEvent((IPCDIRestartedEvent)event, source);
                }
            }
            ++i;
        }
    }

    public boolean canRestart() {
        return false;
    }

    public void restart() throws DebugException {
        if (!this.canRestart()) {
            return;
        }
        this.changeState(PDebugElementState.RESTARTING);
        try {
            this.getCDITarget().restart();
        }
        catch (PCDIException e) {
            this.restoreOldState();
            PDebugTarget.targetRequestFailed(e.getMessage(), e);
        }
    }

    public boolean isAvailable() {
        return !this.isTerminated() && !this.isTerminating() && !this.isDisconnected() && !this.isDisconnecting();
    }

    protected boolean isTerminating() {
        return this.getState().equals(PDebugElementState.TERMINATING);
    }

    public void terminated() {
        if (!this.isTerminated()) {
            if (!this.isDisconnected()) {
                this.setState(PDebugElementState.TERMINATED);
            }
            this.cleanup();
            this.fireTerminateEvent();
        }
    }

    protected boolean isDisconnecting() {
        return this.getState().equals(PDebugElementState.DISCONNECTING);
    }

    protected void disconnected() {
        if (!this.isDisconnected()) {
            this.setState(PDebugElementState.DISCONNECTED);
            this.cleanup();
            this.fireTerminateEvent();
        }
    }

    public void cleanup() {
        this.resetStatus();
        this.removeAllThreads();
        this.getCDISession().getEventManager().removeEventListener(this);
        DebugPlugin.getDefault().getExpressionManager().removeExpressionListener((IExpressionListener)this);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
        this.saveGlobalVariables();
        this.disposeMemoryBlockRetrieval();
        this.disposeGlobalVariableManager();
        this.disposeSourceManager();
        this.disposeSourceLookupPath();
        this.removeAllExpressions();
        this.disposePreferences();
    }

    protected void saveMemoryBlocks() {
        this.getMemoryBlockRetrieval().save();
    }

    protected void disposeMemoryBlockRetrieval() {
        this.getMemoryBlockRetrieval().dispose();
    }

    protected void removeAllThreads() {
        ArrayList threads = this.getThreadList();
        this.setThreadList(new ArrayList(0));
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(threads.size());
        for (PThread thread : threads) {
            thread.terminated();
            debugEvents.add(thread.createTerminateEvent());
        }
        this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
    }

    protected void removeAllExpressions() {
        IExpressionManager em = DebugPlugin.getDefault().getExpressionManager();
        IExpression[] expressions = em.getExpressions();
        int i = 0;
        while (i < expressions.length) {
            if (expressions[i] instanceof PExpression && expressions[i].getDebugTarget().equals(this)) {
                em.removeExpression(expressions[i]);
            }
            ++i;
        }
    }

    protected PThread createThread(IPCDIThread cdiThread) {
        PThread thread = new PThread(this, cdiThread);
        this.getThreadList().add(thread);
        return thread;
    }

    private void handleSuspendedEvent(IPCDISuspendedEvent event, IPCDIObject source) {
        PThread thread;
        this.setState(PDebugElementState.SUSPENDED);
        IPCDISessionObject reason = event.getReason();
        this.setCurrentStateInfo(reason);
        this.skipBreakpoints(false);
        List newThreads = this.refreshThreads();
        if (source instanceof IPCDITarget) {
            this.suspendThreads(event);
        } else if (source instanceof IPCDIThread && (thread = this.findThread((IPCDIThread)source)) != null && newThreads.contains(thread)) {
            IPCDIEvent[] evts = new IPCDIEvent[]{event};
            thread.handleDebugEvents(evts);
        }
        if (reason instanceof IPCDIEndSteppingRange) {
            this.handleEndSteppingRange((IPCDIEndSteppingRange)reason);
        } else if (reason instanceof IPCDIBreakpointHit) {
            this.handleBreakpointHit((IPCDIBreakpointHit)reason);
        } else if (reason instanceof IPCDISignalReceived) {
            this.handleSuspendedBySignal((IPCDISignalReceived)reason);
        } else if (reason instanceof IPCDIWatchpointTrigger) {
            this.handleWatchpointTrigger((IPCDIWatchpointTrigger)reason);
        } else if (reason instanceof IPCDIWatchpointScope) {
            this.handleWatchpointScope((IPCDIWatchpointScope)reason);
        } else if (reason instanceof IPCDIErrorInfo) {
            this.handleErrorInfo((IPCDIErrorInfo)reason);
        } else if (reason instanceof IPCDISharedLibraryEvent) {
            this.handleSuspendedBySolibEvent((IPCDISharedLibraryEvent)reason);
        } else {
            this.fireSuspendEvent(0);
        }
    }

    private void handleResumedEvent(IPCDIResumedEvent event, IPCDIObject source) {
        this.setState(PDebugElementState.RESUMED);
        this.setCurrentStateInfo(null);
        this.resetStatus();
        ArrayList<DebugEvent> debugEvents = new ArrayList<DebugEvent>(10);
        int detail = 0;
        switch (event.getType()) {
            case 0: {
                detail = 32;
                break;
            }
            case 2: 
            case 4: {
                detail = 1;
                break;
            }
            case 1: 
            case 3: {
                detail = 2;
                break;
            }
            case 5: {
                detail = 4;
            }
        }
        debugEvents.add(this.createResumeEvent(detail));
        this.resumeThreads(debugEvents, detail);
        this.fireEventSet(debugEvents.toArray(new DebugEvent[debugEvents.size()]));
    }

    private void handleEndSteppingRange(IPCDIEndSteppingRange endSteppingRange) {
        this.fireSuspendEvent(0);
    }

    private void handleBreakpointHit(IPCDIBreakpointHit breakpointHit) {
        this.fireSuspendEvent(16);
    }

    private void handleWatchpointTrigger(IPCDIWatchpointTrigger wt) {
        this.fireSuspendEvent(16);
    }

    private void handleWatchpointScope(IPCDIWatchpointScope ws) {
    }

    private void handleSuspendedBySignal(IPCDISignalReceived signal) {
        this.fireSuspendEvent(0);
    }

    private void handleErrorInfo(IPCDIErrorInfo info) {
        this.setStatus(2, info != null ? info.getMessage() : null);
        if (info != null) {
            MultiStatus status = new MultiStatus(PTPDebugCorePlugin.getUniqueIdentifier(), 10002, CoreModelMessages.getString("PDebugTarget.1"), null);
            StringTokenizer st = new StringTokenizer(info.getDetailMessage(), "\n\r");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.length() > 200) {
                    token = token.substring(0, 200);
                }
                status.add((IStatus)new Status(4, status.getPlugin(), 10002, token, null));
            }
            PDebugUtils.error((IStatus)status, this);
        }
        this.fireSuspendEvent(0);
    }

    private void handleSuspendedBySolibEvent(IPCDISharedLibraryEvent solibEvent) {
        this.fireSuspendEvent(0);
    }

    private void handleExitedEvent(IPCDIExitedEvent event, IPCDIObject source) {
        this.removeAllThreads();
        this.setState(PDebugElementState.EXITED);
        this.setCurrentStateInfo(event.getReason());
        this.fireChangeEvent(512);
        IPCDISessionConfiguration sessionConfig = this.getCDISession().getConfiguration();
        if (sessionConfig != null && sessionConfig.terminateSessionOnExit()) {
            this.terminated();
        }
    }

    private void handleTerminatedEvent(IPCDIDestroyedEvent event, IPCDIObject source) {
        this.terminated();
    }

    private void handleDisconnectedEvent(IPCDIDisconnectedEvent event, IPCDIObject source) {
        this.disconnected();
    }

    private void handleChangedEvent(IPCDIChangedEvent event, IPCDIObject source) {
    }

    private void handleRestartedEvent(IPCDIRestartedEvent event, IPCDIObject source) {
    }

    private void handleThreadCreatedEvent(IPCDICreatedEvent event, IPCDIObject source) {
        IPCDIThread cdiThread = (IPCDIThread)source;
        PThread thread = this.findThread(cdiThread);
        if (thread == null) {
            thread = this.createThread(cdiThread);
            thread.fireCreationEvent();
        }
    }

    private void handleThreadTerminatedEvent(IPCDIDestroyedEvent event, IPCDIObject source) {
        IPCDIThread cdiThread = (IPCDIThread)source;
        PThread thread = this.findThread(cdiThread);
        if (thread != null) {
            this.getThreadList().remove(thread);
            thread.terminated();
            thread.fireTerminateEvent();
        }
    }

    public PThread findThread(IPCDIThread cdiThread) {
        ArrayList threads = this.getThreadList();
        int i = 0;
        while (i < threads.size()) {
            PThread t = (PThread)threads.get(i);
            if (t.getCDIThread().equals(cdiThread)) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public PThread findThread(List threads, IPCDIThread cdiThread) {
        int i = 0;
        while (i < threads.size()) {
            PThread t = (PThread)threads.get(i);
            if (t.getCDIThread().equals(cdiThread)) {
                return t;
            }
            ++i;
        }
        return null;
    }

    protected IPCDITargetConfiguration getConfiguration() {
        return this.fConfig;
    }

    private void setConfiguration(IPCDITargetConfiguration config) {
        this.fConfig = config;
    }

    protected boolean supportsExpressionEvaluation() {
        return this.getConfiguration().supportsExpressionEvaluation();
    }

    public void expressionAdded(IExpression expression) {
    }

    public void expressionChanged(IExpression expression) {
    }

    public void expressionRemoved(IExpression expression) {
        if (expression instanceof PExpression && expression.getDebugTarget().equals(this)) {
            ((PExpression)expression).dispose();
        }
    }

    protected IThread getCurrentThread() throws DebugException {
        IThread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            if (((PThread)threads[i]).isCurrent()) {
                return threads[i];
            }
            ++i;
        }
        return null;
    }

    protected ISourceLocator getSourceLocator() {
        return this.getLaunch().getSourceLocator();
    }

    public boolean isLittleEndian() {
        if (this.fIsLittleEndian == null) {
            this.fIsLittleEndian = Boolean.TRUE;
            IBinaryParser.IBinaryObject file = this.getBinaryFile();
            if (file != null) {
                this.fIsLittleEndian = new Boolean(file.isLittleEndian());
            }
        }
        return this.fIsLittleEndian;
    }

    public IBinaryParser.IBinaryObject getExecFile() {
        return this.getBinaryFile();
    }

    public IBinaryParser.IBinaryObject getBinaryFile() {
        return this.fBinaryFile;
    }

    private void setExecFile(IBinaryParser.IBinaryObject file) {
        this.fBinaryFile = file;
    }

    protected void saveGlobalVariables() {
        this.fGlobalVariableManager.save();
    }

    protected void disposeGlobalVariableManager() {
        this.fGlobalVariableManager.dispose();
    }

    public boolean canResumeWithoutSignal() {
        return this.canResume() && this.getCurrentStateInfo() instanceof IPCDISignalReceived;
    }

    public void resumeWithoutSignal() throws DebugException {
        if (!this.canResume()) {
            return;
        }
        this.changeState(PDebugElementState.RESUMING);
        try {
            this.getCDITarget().resume(false);
        }
        catch (PCDIException e) {
            this.restoreOldState();
            PDebugTarget.targetRequestFailed(e.getMessage(), e);
        }
    }

    protected void disposeSourceManager() {
        IResourceChangeListener listener;
        ISourceLocator locator = this.getSourceLocator();
        if (locator instanceof IAdaptable && (listener = (IResourceChangeListener)((IAdaptable)locator).getAdapter(IResourceChangeListener.class)) != null) {
            CCorePlugin.getWorkspace().removeResourceChangeListener(listener);
        }
    }

    protected void disposeSourceLookupPath() {
        ISourceLocator locator = this.getLaunch().getSourceLocator();
        if (locator instanceof ISourceLookupDirector) {
            ISourceLookupParticipant[] participants = ((ISourceLookupDirector)locator).getParticipants();
            int i = 0;
            while (i < participants.length) {
                if (participants[i] instanceof PSourceLookupParticipant) {
                    ((PSourceLookupParticipant)participants[i]).removeSourceLookupChangeListener(this);
                }
                ++i;
            }
        }
    }

    public String toString() {
        String result = "";
        try {
            result = this.getName();
        }
        catch (DebugException debugException) {}
        return result;
    }

    public IPSignal[] getSignals() throws DebugException {
        PSignalManager sm = this.getSignalManager();
        if (sm != null) {
            return sm.getSignals();
        }
        return new IPSignal[0];
    }

    public boolean hasSignals() throws DebugException {
        PSignalManager sm = this.getSignalManager();
        if (sm != null) {
            return sm.getSignals().length > 0;
        }
        return false;
    }

    public IAddress getBreakpointAddress(IPLineBreakpoint breakpoint) throws DebugException {
        return null;
    }

    public void enableInstructionStepping(boolean enabled) {
        this.fPreferences.setValue("instruction_stepping_mode", enabled);
    }

    public boolean supportsInstructionStepping() {
        return this.getConfiguration().supportsInstructionStepping();
    }

    public boolean isInstructionSteppingEnabled() {
        return false;
    }

    private void initializePreferences() {
        this.fPreferences = new Preferences();
        this.fPreferences.setDefault("instruction_stepping_mode", false);
    }

    private void disposePreferences() {
        this.fPreferences = null;
    }

    public void addPropertyChangeListener(Preferences.IPropertyChangeListener listener) {
        if (this.fPreferences != null) {
            this.fPreferences.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(Preferences.IPropertyChangeListener listener) {
        if (this.fPreferences != null) {
            this.fPreferences.removePropertyChangeListener(listener);
        }
    }

    protected PGlobalVariableManager getGlobalVariableManager() {
        return this.fGlobalVariableManager;
    }

    private void setGlobalVariableManager(PGlobalVariableManager globalVariableManager) {
        this.fGlobalVariableManager = globalVariableManager;
    }

    protected void setSignalManager(PSignalManager sm) {
        this.fSignalManager = sm;
    }

    protected PSignalManager getSignalManager() {
        return this.fSignalManager;
    }

    protected void disposeSignalManager() {
        this.fSignalManager.dispose();
    }

    public boolean isPostMortem() {
        return false;
    }

    public IAddressFactory getAddressFactory() {
        IBinaryParser.IBinaryObject file;
        if (this.fAddressFactory == null && this.getExecFile() != null && (file = this.getBinaryFile()) != null) {
            this.fAddressFactory = file.getAddressFactory();
        }
        return this.fAddressFactory;
    }

    private void changeState(PDebugElementState state) {
        this.setState(state);
        Iterator it = this.getThreadList().iterator();
        while (it.hasNext()) {
            ((PThread)it.next()).setState(state);
        }
    }

    protected void restoreOldState() {
        this.restoreState();
        Iterator it = this.getThreadList().iterator();
        while (it.hasNext()) {
            ((PThread)it.next()).restoreState();
        }
    }

    protected void skipBreakpoints(boolean enabled) {
    }

    public IDisassembly getDisassembly() throws DebugException {
        return null;
    }

    public IPGlobalVariable createGlobalVariable(IGlobalVariableDescriptor info) throws DebugException {
        IPCDIGlobalVariableDescriptor vo = null;
        try {
            vo = this.getCDITarget().getGlobalVariableDescriptors(info.getPath().lastSegment(), null, info.getName());
        }
        catch (PCDIException e) {
            throw new DebugException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 5010, vo != null ? String.valueOf(vo.getName()) + ": " + e.getMessage() : e.getMessage(), null));
        }
        return PVariableFactory.createGlobalVariable(this, info, vo);
    }

    public boolean hasModules() throws DebugException {
        return false;
    }

    public ICModule[] getModules() throws DebugException {
        return null;
    }

    public void loadSymbolsForAllModules() throws DebugException {
    }

    public IRegisterDescriptor[] getRegisterDescriptors() throws DebugException {
        return null;
    }

    public void addRegisterGroup(String name, IRegisterDescriptor[] descriptors) {
    }

    public void removeRegisterGroups(IRegisterGroup[] groups) {
    }

    public void modifyRegisterGroup(IPersistableRegisterGroup group, IRegisterDescriptor[] descriptors) {
    }

    public void restoreDefaultRegisterGroups() {
    }

    public IGlobalVariableDescriptor[] getGlobals() throws DebugException {
        ArrayList list = new ArrayList();
        IBinaryParser.IBinaryObject file = this.getBinaryFile();
        if (file != null) {
            list.addAll(this.getCFileGlobals(file));
        }
        return list.toArray(new IGlobalVariableDescriptor[list.size()]);
    }

    private List getCFileGlobals(IBinaryParser.IBinaryObject file) throws DebugException {
        ArrayList<IGlobalVariableDescriptor> list = new ArrayList<IGlobalVariableDescriptor>();
        IBinaryParser.ISymbol[] symbols = file.getSymbols();
        int i = 0;
        while (i < symbols.length) {
            if (symbols[i].getType() == 2) {
                list.add(PVariableFactory.createGlobalVariableDescriptor(symbols[i]));
            }
            ++i;
        }
        return list;
    }

    public void sourceContainersChanged(ISourceLookupDirector director) {
        this.setSourceLookupPath(director.getSourceContainers());
    }

    private void setSourceLookupPath(ISourceContainer[] containers) {
        ArrayList list = new ArrayList(containers.length);
        this.getSourceLookupPath(list, containers);
        try {
            this.getCDITarget().setSourcePaths(list.toArray(new String[list.size()]));
        }
        catch (CDIException e) {
            PTPDebugCorePlugin.log(e);
        }
    }

    private void getSourceLookupPath(List list, ISourceContainer[] containers) {
        int i = 0;
        while (i < containers.length) {
            File dir;
            IContainer container;
            IProject project;
            if (containers[i] instanceof ProjectSourceContainer && (project = ((ProjectSourceContainer)containers[i]).getProject()) != null && project.exists()) {
                list.add(project.getLocation().toPortableString());
            }
            if (containers[i] instanceof FolderSourceContainer && (container = ((FolderSourceContainer)containers[i]).getContainer()) != null && container.exists()) {
                list.add(container.getLocation().toPortableString());
            }
            if (containers[i] instanceof DirectorySourceContainer && (dir = ((DirectorySourceContainer)containers[i]).getDirectory()) != null && dir.exists()) {
                Path path = new Path(dir.getAbsolutePath());
                list.add(path.toPortableString());
            }
            if (containers[i].isComposite()) {
                try {
                    this.getSourceLookupPath(list, containers[i].getSourceContainers());
                }
                catch (CoreException e) {
                    PTPDebugCorePlugin.log(e.getStatus());
                }
            }
            ++i;
        }
    }
}

