/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.external.core.AbstractDebugger;

public class DebugCommandQueue
extends Job {
    private List queue = new ArrayList();
    private boolean terminated = false;
    private boolean stopAddCommand = false;
    private IDebugCommand currentCommand = null;
    private IAbstractDebugger debugger = null;
    private IDebugCommand interruptCommand = null;

    public DebugCommandQueue(IAbstractDebugger debugger) {
        super("Debug Command Queue");
        this.debugger = debugger;
        this.setPriority(20);
        this.setSystem(true);
    }

    public synchronized boolean isTerminated() {
        return this.terminated;
    }

    public synchronized void setTerminated() {
        this.terminated = true;
        this.doFlushCommands(false);
    }

    public synchronized void setStopAddCommand(boolean stopAddCommand) {
        this.stopAddCommand = stopAddCommand;
    }

    public synchronized void setInterruptCommand(IDebugCommand interruptCommand) {
        this.interruptCommand = interruptCommand;
    }

    public synchronized IDebugCommand getInterruptCommand() {
        return this.interruptCommand;
    }

    protected IStatus run(IProgressMonitor monitor) {
        while (!this.queue.isEmpty()) {
            block7: {
                this.currentCommand = this.getCommand();
                if (!this.terminated) break block7;
                this.currentCommand.doFlush();
                this.currentCommand = null;
                break;
            }
            try {
                try {
                    PDebugUtils.println((String)("*** SEND COMMAND: " + this.currentCommand.getCommandName() + ", tasks: " + AbstractDebugger.showBitList(this.currentCommand.getTasks())));
                    this.currentCommand.execCommand(this.debugger);
                }
                catch (PCDIException e) {
                    this.debugger.handleErrorEvent(this.currentCommand.getTasks(), e.getMessage(), e.getErrorCode());
                    this.currentCommand.doFlush();
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.currentCommand = null;
            }
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDebugCommand getCommand() throws PCDIException {
        List list = this.queue;
        synchronized (list) {
            if (!this.queue.isEmpty()) {
                return (IDebugCommand)this.queue.remove(0);
            }
        }
        throw new PCDIException("No DebugCommand found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(IDebugCommand command) {
        List list = this.queue;
        synchronized (list) {
            if (command == null) {
                return;
            }
            if (!(this.stopAddCommand || this.terminated || this.contains(command))) {
                if (this.currentCommand != null && this.currentCommand.canInterrupt() && !command.canInterrupt()) {
                    command.doFlush();
                    return;
                }
                if (command.isWaitInQueue()) {
                    this.queue.add(command);
                } else {
                    PDebugUtils.println((String)("************ DebugCommandQueue -- Add cmd JUMP: " + command.getCommandName()));
                    this.queue.add(0, command);
                }
                this.schedule();
            } else {
                command.doFlush();
                if (this.stopAddCommand || this.terminated) {
                    PDebugUtils.println((String)("************ ERROR in DebugCommandQueue -- debugger is terminated or stoped to add command, cmd: " + command.getCommandName()));
                } else {
                    PDebugUtils.println((String)("************ ERROR in DebugCommandQueue -- duplicate, cmd: " + command.getCommandName()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommandByPriority(IDebugCommand command) {
        List list = this.queue;
        synchronized (list) {
            if (command.getPriority() > 1) {
                int i = 0;
                while (i < this.queue.size()) {
                    if (((IDebugCommand)this.queue.get(i)).getPriority() < command.getPriority()) {
                        PDebugUtils.println((String)("************ DebugCommandQueue -- add cmd INSERT: " + command.getCommandName()));
                        this.queue.add(i, command);
                        return;
                    }
                    ++i;
                }
            }
            PDebugUtils.println((String)("************ DebugCommandQueue -- add cmd LAST: " + command.getCommandName()));
            this.queue.add(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean contains(IDebugCommand command) {
        List list = this.queue;
        synchronized (list) {
            int size = this.queue.size();
            if (size > 0) {
                return ((IDebugCommand)this.queue.get(size - 1)).equals(command);
            }
            return false;
        }
    }

    public IDebugCommand[] getCommands() {
        return this.queue.toArray(new IDebugCommand[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommandReturn(BitList tasks, Object result) {
        List list = this.queue;
        synchronized (list) {
            if (this.currentCommand != null) {
                PDebugUtils.println((String)("*** SET COMMAND RETURN: " + this.currentCommand.getCommandName() + ", result: " + result + ", tasks: " + AbstractDebugger.showBitList(tasks)));
                this.currentCommand.setReturn(tasks, result);
            }
        }
    }

    public IDebugCommand getCurrentCommand() {
        return this.currentCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlushCommands(boolean removeInterrupt) {
        List list = this.queue;
        synchronized (list) {
            IDebugCommand[] commands = this.getCommands();
            int i = commands.length - 1;
            while (i > -1) {
                if (removeInterrupt || !commands[i].canInterrupt()) {
                    this.removeCommand(commands[i]);
                }
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCommand(IDebugCommand command) {
        List list = this.queue;
        synchronized (list) {
            command.doFlush();
            this.queue.remove(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(boolean removeInterrupt) {
        List list = this.queue;
        synchronized (list) {
            this.doFlushCommands(removeInterrupt);
            if (this.currentCommand != null) {
                this.currentCommand.doFlush();
                this.currentCommand = null;
            }
        }
    }
}

