/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class PTPDebugExternalPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.debug.external.core";
    private static PTPDebugExternalPlugin plugin;
    private ResourceBundle resourceBundle;
    private static Logger logger;
    private Level loggingLevel = Level.FINE;

    public PTPDebugExternalPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.resourceBundle = null;
    }

    public static PTPDebugExternalPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PTPDebugExternalPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.ptp.debug.external.ExternalPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public static String getUniqueIdentifier() {
        if (PTPDebugExternalPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return PTPDebugExternalPlugin.getDefault().getBundle().getSymbolicName();
    }

    public Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
            Handler[] handlers = logger.getHandlers();
            int index = 0;
            while (index < handlers.length) {
                logger.removeHandler(handlers[index]);
                ++index;
            }
            ConsoleHandler console = new ConsoleHandler();
            console.setFormatter(new Formatter(){

                public String format(LogRecord record) {
                    String out = record.getLevel() + " : " + record.getSourceClassName() + "." + record.getSourceMethodName();
                    if (!record.getMessage().equals("")) {
                        out = String.valueOf(out) + " : " + record.getMessage();
                    }
                    out = String.valueOf(out) + "\n";
                    return out;
                }
            });
            console.setLevel(this.loggingLevel);
            logger.addHandler(console);
            logger.setLevel(this.loggingLevel);
        }
        return logger;
    }

    public static void log(String message) {
        PTPDebugExternalPlugin.getDefault().getLog().log((IStatus)new Status(4, PTPDebugExternalPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(IStatus status) {
        PTPDebugExternalPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        PTPDebugExternalPlugin.log((IStatus)new Status(4, PTPDebugExternalPlugin.getUniqueIdentifier(), 4, "Internal Error", e));
    }
}

