/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi.model;

import java.math.BigInteger;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.aif.IAIFValue;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIArgument;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIArgumentDescriptor;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocalVariable;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocalVariableDescriptor;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocator;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIStackFrame;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIThread;
import org.eclipse.ptp.debug.external.core.cdi.Locator;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.VariableManager;
import org.eclipse.ptp.debug.external.core.cdi.model.PObject;
import org.eclipse.ptp.debug.external.core.cdi.model.Target;
import org.eclipse.ptp.debug.external.core.cdi.model.Thread;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.ArgumentDescriptor;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.LocalVariableDescriptor;
import org.eclipse.ptp.debug.external.core.commands.StepFinishCommand;

public class StackFrame
extends PObject
implements IPCDIStackFrame {
    IPCDIThread pthread;
    IPCDIArgumentDescriptor[] argDescs;
    IPCDILocalVariableDescriptor[] localDescs;
    Locator fLocator;
    int level = -1;
    BigInteger addr = BigInteger.ZERO;
    String func = "";
    String file = "";
    int line = -1;
    String fullname = "";
    Argument[] args = new Argument[0];

    public StackFrame(Thread thread, int level, IPCDILocator locator, Argument[] args) {
        super((Target)thread.getTarget());
        this.pthread = thread;
        this.fLocator = (Locator)locator;
        this.level = level;
        this.addr = this.fLocator.getAddress();
        this.file = this.fLocator.getFile();
        this.line = this.fLocator.getLineNumber();
        this.func = this.fLocator.getFunction();
        if (args != null) {
            this.args = args;
        }
    }

    public StackFrame(Thread thread, int level, String file, String func, int line, BigInteger addr, Argument[] args) {
        super((Target)thread.getTarget());
        this.pthread = thread;
        this.level = level;
        this.addr = addr;
        this.file = file;
        this.line = line;
        this.func = func;
        if (args != null) {
            this.args = args;
        }
    }

    public IPCDIThread getThread() {
        return this.pthread;
    }

    public IPCDIArgumentDescriptor[] getArgumentDescriptors() throws PCDIException {
        if (this.argDescs == null) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager mgr = session.getVariableManager();
            this.argDescs = mgr.getArgumentDescriptors(this);
        }
        return this.argDescs;
    }

    public IPCDILocalVariableDescriptor[] getLocalVariableDescriptors() throws PCDIException {
        if (this.localDescs == null) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager mgr = session.getVariableManager();
            this.localDescs = mgr.getLocalVariableDescriptors(this);
        }
        return this.localDescs;
    }

    public IPCDIArgument createArgument(IPCDIArgumentDescriptor varDesc) throws PCDIException {
        if (varDesc instanceof ArgumentDescriptor) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager mgr = session.getVariableManager();
            return mgr.createArgument((ArgumentDescriptor)varDesc);
        }
        return null;
    }

    public IPCDILocalVariable createLocalVariable(IPCDILocalVariableDescriptor varDesc) throws PCDIException {
        if (varDesc instanceof ArgumentDescriptor) {
            return this.createArgument((IPCDIArgumentDescriptor)varDesc);
        }
        if (varDesc instanceof LocalVariableDescriptor) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager mgr = session.getVariableManager();
            return mgr.createLocalVariable((LocalVariableDescriptor)varDesc);
        }
        return null;
    }

    public IPCDILocator getLocator() {
        if (this.fLocator == null) {
            this.fLocator = new Locator(this.getFile(), this.getFunction(), this.getLine(), this.addr);
        }
        return this.fLocator;
    }

    public boolean equals(IPCDIStackFrame stackframe) {
        if (stackframe instanceof StackFrame) {
            boolean equal;
            StackFrame stack = (StackFrame)stackframe;
            boolean bl = equal = this.pthread != null && this.pthread.equals(stack.getThread()) && this.getLevel() == stack.getLevel();
            if (equal) {
                IPCDILocator otherLocator = stack.getLocator();
                IPCDILocator myLocator = this.getLocator();
                if (Locator.equalString(myLocator.getFile(), otherLocator.getFile()) && Locator.equalString(myLocator.getFunction(), otherLocator.getFunction())) {
                    return true;
                }
            }
        }
        return super.equals(stackframe);
    }

    public void stepReturn() throws PCDIException {
        this.finish();
    }

    public void stepReturn(IAIFValue value) throws PCDIException {
        throw new PCDIException("----StackFrame - stepReturn not implemented yet");
    }

    protected void finish() throws PCDIException {
        ((Thread)this.getThread()).setCurrentStackFrame(this, false);
        Target target = (Target)this.getTarget();
        target.getDebugger().postCommand((IDebugCommand)new StepFinishCommand(target.getTask()));
    }

    protected void execReturn(String value) throws PCDIException {
        ((Thread)this.getThread()).setCurrentStackFrame(this, false);
        Target target = (Target)this.getTarget();
        target.getDebugger().postCommand((IDebugCommand)new StepFinishCommand(target.getTask()));
    }

    public int getLevel() {
        return this.level;
    }

    public BigInteger getAddress() {
        return this.addr;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public String getFunction() {
        return this.func;
    }

    public class Argument {
        String name;
        String value;

        public Argument(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

