/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.external.core.cdi.model;

import java.math.BigInteger;
import java.util.ArrayList;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMixedInstruction;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegister;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterGroup;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRuntimeOptions;
import org.eclipse.cdt.debug.core.cdi.model.ICDISharedLibrary;
import org.eclipse.ptp.core.IPProcess;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IAbstractDebugger;
import org.eclipse.ptp.debug.core.IDebugCommand;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.cdi.IPCDIAddressLocation;
import org.eclipse.ptp.debug.core.cdi.IPCDICondition;
import org.eclipse.ptp.debug.core.cdi.IPCDIFunctionLocation;
import org.eclipse.ptp.debug.core.cdi.IPCDILineLocation;
import org.eclipse.ptp.debug.core.cdi.PCDIException;
import org.eclipse.ptp.debug.core.cdi.event.IPCDIEvent;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIExpression;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIGlobalVariable;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIGlobalVariableDescriptor;
import org.eclipse.ptp.debug.core.cdi.model.IPCDILocation;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIMemoryBlock;
import org.eclipse.ptp.debug.core.cdi.model.IPCDISignal;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIStackFrame;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITarget;
import org.eclipse.ptp.debug.core.cdi.model.IPCDITargetConfiguration;
import org.eclipse.ptp.debug.core.cdi.model.IPCDIThread;
import org.eclipse.ptp.debug.external.core.cdi.ExpressionManager;
import org.eclipse.ptp.debug.external.core.cdi.MemoryManager;
import org.eclipse.ptp.debug.external.core.cdi.Session;
import org.eclipse.ptp.debug.external.core.cdi.SessionObject;
import org.eclipse.ptp.debug.external.core.cdi.SignalManager;
import org.eclipse.ptp.debug.external.core.cdi.VariableManager;
import org.eclipse.ptp.debug.external.core.cdi.event.ThreadCreatedEvent;
import org.eclipse.ptp.debug.external.core.cdi.event.ThreadExitedEvent;
import org.eclipse.ptp.debug.external.core.cdi.model.StackFrame;
import org.eclipse.ptp.debug.external.core.cdi.model.TargetConfiguration;
import org.eclipse.ptp.debug.external.core.cdi.model.Thread;
import org.eclipse.ptp.debug.external.core.cdi.model.variable.GlobalVariableDescriptor;
import org.eclipse.ptp.debug.external.core.commands.CLISignalInfoCommand;
import org.eclipse.ptp.debug.external.core.commands.DataEvaluateExpressionCommand;
import org.eclipse.ptp.debug.external.core.commands.GetInfoThreadsCommand;
import org.eclipse.ptp.debug.external.core.commands.GoCommand;
import org.eclipse.ptp.debug.external.core.commands.HaltCommand;
import org.eclipse.ptp.debug.external.core.commands.SetThreadSelectCommand;
import org.eclipse.ptp.debug.external.core.commands.StepIntoCommand;
import org.eclipse.ptp.debug.external.core.commands.StepOverCommand;
import org.eclipse.ptp.debug.external.core.commands.TerminateCommand;
import org.eclipse.ptp.debug.external.core.proxy.ProxyDebugStackframe;

public class Target
extends SessionObject
implements IPCDITarget {
    IPCDITargetConfiguration fConfiguration;
    Thread[] noThreads = new Thread[0];
    Thread[] currentThreads;
    int currentThreadId;
    String fEndian = null;
    boolean suspended = true;
    private int task_id = -1;
    private BitList task = null;
    boolean deferBreakpoints = true;
    Lock lock = new Lock();

    public Target(Session session, int task_id) {
        super(session);
        this.task_id = task_id;
        this.task = session.createBitList(task_id);
        this.currentThreads = this.noThreads;
    }

    public void lockTarget() {
        this.lock.aquire();
    }

    public void releaseTarget() {
        this.lock.release();
    }

    public IAbstractDebugger getDebugger() {
        return this.getSession().getDebugger();
    }

    public void setConfiguration(IPCDITargetConfiguration configuration) {
        this.fConfiguration = configuration;
    }

    public BitList getTask() {
        return this.task;
    }

    public IPCDITarget getTarget() {
        return this;
    }

    public void setCurrentThread(IPCDIThread pthread) throws PCDIException {
        if (!(pthread instanceof Thread)) {
            throw new PCDIException("Target - Unknown_thread");
        }
        this.setCurrentThread(pthread, true);
    }

    public void setCurrentThread(IPCDIThread pthread, boolean doUpdate) throws PCDIException {
        if (!(pthread instanceof Thread)) {
            throw new PCDIException("Target - Unknown_thread");
        }
        this.setCurrentThread((Thread)pthread, doUpdate);
    }

    public synchronized void setSupended(boolean state) {
        this.suspended = state;
        this.notifyAll();
    }

    public void setCurrentThread(Thread pthread, boolean doUpdate) throws PCDIException {
        int id = pthread.getId();
        if (id == 0) {
            return;
        }
        if (this.currentThreadId != id) {
            VariableManager varMgr;
            SetThreadSelectCommand command = new SetThreadSelectCommand(this.getTask(), id);
            this.getDebugger().postCommand((IDebugCommand)command);
            Object[] objects = command.getThreadInfo();
            if (objects.length != 2) {
                throw new PCDIException("Cannot SetThreadSelectCommand error");
            }
            this.currentThreadId = (Integer)objects[0];
            ProxyDebugStackframe frame = (ProxyDebugStackframe)objects[1];
            int depth = pthread.getStackFrameCount();
            pthread.currentFrame = new StackFrame(pthread, depth - frame.getLevel(), frame.getLocator(), null);
            if (doUpdate && (varMgr = ((Session)this.getSession()).getVariableManager()).isAutoUpdate()) {
                varMgr.update(this);
            }
        }
        if (this.currentThreadId != id) {
            this.getDebugger().fireEvent((IPCDIEvent)new ThreadExitedEvent(this.getSession(), this.getTask(), this.getThread(id), id));
            throw new PCDIException("Cannot switch to thread " + id);
        }
    }

    public synchronized void updateState(int newThreadId) {
        int j;
        Thread[] oldThreads = this.currentThreads;
        this.currentThreadId = newThreadId;
        try {
            this.currentThreads = this.getPThreads();
        }
        catch (PCDIException pCDIException) {
            this.currentThreads = this.noThreads;
        }
        ArrayList<Integer> cList = new ArrayList<Integer>(this.currentThreads.length);
        int i = 0;
        while (i < this.currentThreads.length) {
            boolean found = false;
            j = 0;
            while (j < oldThreads.length) {
                if (this.currentThreads[i].getId() == oldThreads[j].getId()) {
                    oldThreads[j].clearState();
                    this.currentThreads[i] = oldThreads[j];
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                cList.add(new Integer(this.currentThreads[i].getId()));
            }
            ++i;
        }
        if (!cList.isEmpty()) {
            IPCDIEvent[] events = new ThreadCreatedEvent[cList.size()];
            int j2 = 0;
            while (j2 < events.length) {
                int id = (Integer)cList.get(j2);
                events[j2] = new ThreadCreatedEvent(this.getSession(), this.getTask(), this.getThread(id), id);
                ++j2;
            }
            this.getDebugger().fireEvents(events);
        }
        ArrayList<Integer> dList = new ArrayList<Integer>(oldThreads.length);
        int i2 = 0;
        while (i2 < oldThreads.length) {
            boolean found = false;
            int j3 = 0;
            while (j3 < this.currentThreads.length) {
                if (this.currentThreads[j3].getId() == oldThreads[i2].getId()) {
                    found = true;
                    break;
                }
                ++j3;
            }
            if (!found) {
                dList.add(new Integer(oldThreads[i2].getId()));
            }
            ++i2;
        }
        if (!dList.isEmpty()) {
            IPCDIEvent[] events = new ThreadExitedEvent[dList.size()];
            j = 0;
            while (j < events.length) {
                int id = (Integer)dList.get(j);
                events[j] = new ThreadExitedEvent(this.getSession(), this.getTask(), this.getThread(id), id);
                ++j;
            }
            this.getDebugger().fireEvents(events);
        }
    }

    public Thread[] getPThreads() throws PCDIException {
        Thread[] pthreads = this.noThreads;
        GetInfoThreadsCommand command = new GetInfoThreadsCommand(this.getTask());
        this.getDebugger().postCommand((IDebugCommand)command);
        String[] ids = command.getThreadIds();
        if (ids.length > 0) {
            pthreads = new Thread[ids.length];
            int i = 0;
            while (i < ids.length) {
                pthreads[i] = new Thread(this, Integer.parseInt(ids[i]));
                ++i;
            }
        } else {
            pthreads = new Thread[]{new Thread(this, 0)};
        }
        this.currentThreadId = pthreads[0].getId();
        if (this.currentThreadId == 0 && pthreads.length > 1) {
            this.currentThreadId = pthreads[1].getId();
        }
        return pthreads;
    }

    public IPCDIThread getCurrentThread() throws PCDIException {
        IPCDIThread[] threads = this.getThreads();
        int i = 0;
        while (i < threads.length) {
            Thread pthread = (Thread)threads[i];
            if (pthread.getId() == this.currentThreadId) {
                return pthread;
            }
            ++i;
        }
        return null;
    }

    public synchronized IPCDIThread[] getThreads() throws PCDIException {
        if (this.currentThreads.length == 0) {
            this.currentThreads = this.getPThreads();
        }
        return this.currentThreads;
    }

    public IPCDIThread getThread(int tid) {
        Thread th = null;
        if (this.currentThreads != null) {
            int i = 0;
            while (i < this.currentThreads.length) {
                Thread pthread = this.currentThreads[i];
                if (pthread.getId() == tid) {
                    th = pthread;
                    break;
                }
                ++i;
            }
        }
        return th;
    }

    public void restart() throws PCDIException {
        throw new PCDIException("Target - restart not implemented yet");
    }

    public void stepInto() throws PCDIException {
        this.stepInto(1);
    }

    public void stepInto(int count) throws PCDIException {
        this.getDebugger().postCommand((IDebugCommand)new StepIntoCommand(this.getTask(), count));
    }

    public void stepIntoInstruction() throws PCDIException {
        this.stepIntoInstruction(1);
    }

    public void stepIntoInstruction(int count) throws PCDIException {
        throw new PCDIException("Not implement yet - Target: stepIntoInstruction");
    }

    public void stepOver() throws PCDIException {
        this.stepOver(1);
    }

    public void stepOver(int count) throws PCDIException {
        this.getDebugger().postCommand((IDebugCommand)new StepOverCommand(this.getTask(), count));
    }

    public void stepOverInstruction() throws PCDIException {
        this.stepOverInstruction(1);
    }

    public void stepOverInstruction(int count) throws PCDIException {
        throw new PCDIException("Not implement yet - Target: stepOverInstruction");
    }

    public void stepReturn() throws PCDIException {
        ((Thread)this.getCurrentThread()).getCurrentStackFrame().stepReturn();
    }

    public void runUntil(IPCDILocation location) throws PCDIException {
        this.stepUntil(location);
    }

    public void stepUntil(IPCDILocation location) throws PCDIException {
        IPCDIAddressLocation addrLocation;
        if (location instanceof IPCDILineLocation) {
            IPCDILineLocation lineLocation = (IPCDILineLocation)location;
            if (lineLocation.getFile() != null && lineLocation.getFile().length() > 0) {
                lineLocation.getFile();
                lineLocation.getLineNumber();
            }
        } else if (location instanceof IPCDIFunctionLocation) {
            IPCDIFunctionLocation funcLocation = (IPCDIFunctionLocation)location;
            if (funcLocation.getFunction() != null && funcLocation.getFunction().length() > 0) {
                funcLocation.getFunction();
            }
            if (funcLocation.getFile() != null && funcLocation.getFile().length() > 0) {
                funcLocation.getFile();
            }
        } else if (location instanceof IPCDIAddressLocation && !(addrLocation = (IPCDIAddressLocation)location).getAddress().equals(BigInteger.ZERO)) {
            String cfr_ignored_0 = "*0x" + addrLocation.getAddress().toString(16);
        }
        throw new PCDIException("Not implement yet - stepUntil(location)");
    }

    public void suspend() throws PCDIException {
        this.getDebugger().postCommand((IDebugCommand)new HaltCommand(this.getTask()));
    }

    public void disconnect() throws PCDIException {
        throw new PCDIException("Target - disconnect not implemented yet");
    }

    public void resume() throws PCDIException {
        this.resume(false);
    }

    public void resume(IPCDILocation location) throws PCDIException {
        this.jump(location);
    }

    public void resume(IPCDISignal signal) throws PCDIException {
        this.signal(signal);
    }

    public void resume(boolean passSignal) throws PCDIException {
        String state = this.getPProcess().getStatus();
        if (state.equals("running")) {
            throw new PCDIException("The process is already running");
        }
        if (state.equals("stopped")) {
            if (passSignal) {
                this.signal();
            } else {
                this.continuation();
            }
        } else if (state.equals("exited")) {
            this.restart();
        } else {
            this.restart();
        }
    }

    public void continuation() throws PCDIException {
        this.getDebugger().postCommand((IDebugCommand)new GoCommand(this.getTask()));
    }

    public void jump(IPCDILocation location) throws PCDIException {
        IPCDIAddressLocation addrLocation;
        if (location instanceof IPCDILineLocation) {
            IPCDILineLocation lineLocation = (IPCDILineLocation)location;
            if (lineLocation.getFile() != null && lineLocation.getFile().length() > 0) {
                lineLocation.getFile();
                lineLocation.getLineNumber();
            }
        } else if (location instanceof IPCDIFunctionLocation) {
            IPCDIFunctionLocation funcLocation = (IPCDIFunctionLocation)location;
            if (funcLocation.getFunction() != null && funcLocation.getFunction().length() > 0) {
                funcLocation.getFunction();
            }
            if (funcLocation.getFile() != null && funcLocation.getFile().length() > 0) {
                funcLocation.getFile();
            }
        } else if (location instanceof IPCDIAddressLocation && !(addrLocation = (IPCDIAddressLocation)location).getAddress().equals(BigInteger.ZERO)) {
            String cfr_ignored_0 = "*0x" + addrLocation.getAddress().toString(16);
        }
        throw new PCDIException("Target - Not implement yet - jump(location)");
    }

    public void signal() throws PCDIException {
        this.getDebugger().postCommand((IDebugCommand)new CLISignalInfoCommand(this.getTask(), "0"));
    }

    public void signal(IPCDISignal signal) throws PCDIException {
        this.getDebugger().postCommand((IDebugCommand)new CLISignalInfoCommand(this.getTask(), signal.getName()));
    }

    public String evaluateExpressionToString(IPCDIStackFrame frame, String expressionText) throws PCDIException {
        Target target = (Target)frame.getTarget();
        Thread currentThread = (Thread)target.getCurrentThread();
        StackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.setCurrentThread(frame.getThread(), false);
        ((Thread)frame.getThread()).setCurrentStackFrame((StackFrame)frame, false);
        try {
            DataEvaluateExpressionCommand command = new DataEvaluateExpressionCommand(this.getTask(), expressionText);
            this.getDebugger().postCommand((IDebugCommand)command);
            String string = command.getExpressionValue();
            return string;
        }
        finally {
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
        }
    }

    public void terminate() throws PCDIException {
        this.getDebugger().postCommand((IDebugCommand)new TerminateCommand(this.getTask()));
    }

    public boolean isTerminated() {
        return this.getPProcess().isTerminated();
    }

    public boolean isDisconnected() {
        return this.isTerminated();
    }

    public boolean isSuspended() {
        return this.getPProcess().getStatus().equals("stopped");
    }

    public boolean isRunning() {
        return this.getPProcess().getStatus().equals("running");
    }

    public Process getProcess() {
        return null;
    }

    public IPCDICondition createCondition(int ignoreCount, String expression) {
        return this.createCondition(ignoreCount, expression, null);
    }

    public IPCDICondition createCondition(int ignoreCount, String expression, String[] tids) {
        return this.getSession().getBreakpointManager().createCondition(ignoreCount, expression, tids);
    }

    public IPCDILineLocation createLineLocation(String file, int line) {
        return this.getSession().getBreakpointManager().createLineLocation(file, line);
    }

    public IPCDIFunctionLocation createFunctionLocation(String file, String function) {
        return this.getSession().getBreakpointManager().createFunctionLocation(file, function);
    }

    public IPCDIAddressLocation createAddressLocation(BigInteger address) {
        return this.getSession().getBreakpointManager().createAddressLocation(address);
    }

    public ICDIRuntimeOptions getRuntimeOptions() {
        return null;
    }

    public IPCDIExpression createExpression(String code) throws PCDIException {
        ExpressionManager expMgr = ((Session)this.getSession()).getExpressionManager();
        return expMgr.createExpression(this, code);
    }

    public IPCDIExpression[] getExpressions() throws PCDIException {
        ExpressionManager expMgr = ((Session)this.getSession()).getExpressionManager();
        return expMgr.getExpressions(this);
    }

    public void destroyExpressions(IPCDIExpression[] expressions) throws PCDIException {
        ExpressionManager expMgr = ((Session)this.getSession()).getExpressionManager();
        expMgr.destroyExpressions(this, expressions);
    }

    public void destroyAllExpressions() throws PCDIException {
        ExpressionManager expMgr = ((Session)this.getSession()).getExpressionManager();
        expMgr.destroyAllExpressions(this);
    }

    public IPCDISignal[] getSignals() throws PCDIException {
        SignalManager sigMgr = ((Session)this.getSession()).getSignalManager();
        return sigMgr.getSignals(this);
    }

    public void setSourcePaths(String[] srcPaths) throws PCDIException {
    }

    public String[] getSourcePaths() throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getSourcePaths");
    }

    public ICDIInstruction[] getInstructions(BigInteger startAddress, BigInteger endAddress) throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getInstructions");
    }

    public ICDIInstruction[] getInstructions(String filename, int linenum) throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getInstructions");
    }

    public ICDIInstruction[] getInstructions(String filename, int linenum, int lines) throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getInstructions");
    }

    public ICDIMixedInstruction[] getMixedInstructions(BigInteger startAddress, BigInteger endAddress) throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getMixedInstructions");
    }

    public ICDIMixedInstruction[] getMixedInstructions(String filename, int linenum) throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getMixedInstructions");
    }

    public ICDIMixedInstruction[] getMixedInstructions(String filename, int linenum, int lines) throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getMixedInstructions");
    }

    public IPCDIMemoryBlock createMemoryBlock(String address, int units, int wordSize) throws PCDIException {
        MemoryManager memMgr = ((Session)this.getSession()).getMemoryManager();
        return memMgr.createMemoryBlock(this, address, units, wordSize);
    }

    public void removeBlocks(IPCDIMemoryBlock[] memoryBlocks) throws PCDIException {
        MemoryManager memMgr = ((Session)this.getSession()).getMemoryManager();
        memMgr.removeBlocks(this, memoryBlocks);
    }

    public void removeAllBlocks() throws PCDIException {
        MemoryManager memMgr = ((Session)this.getSession()).getMemoryManager();
        memMgr.removeAllBlocks(this);
    }

    public IPCDIMemoryBlock[] getMemoryBlocks() throws PCDIException {
        MemoryManager memMgr = ((Session)this.getSession()).getMemoryManager();
        return memMgr.getMemoryBlocks(this);
    }

    public ICDISharedLibrary[] getSharedLibraries() throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getSharedLibraries");
    }

    public IPCDIGlobalVariableDescriptor getGlobalVariableDescriptors(String filename, String function, String name) throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getGlobalVariableDescriptors");
    }

    public ICDIRegisterGroup[] getRegisterGroups() throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: getRegisterGroups");
    }

    public IPCDITargetConfiguration getConfiguration() {
        if (this.fConfiguration == null) {
            this.fConfiguration = new TargetConfiguration(this);
        }
        return this.fConfiguration;
    }

    public IPCDIGlobalVariable createGlobalVariable(IPCDIGlobalVariableDescriptor varDesc) throws PCDIException {
        if (varDesc instanceof GlobalVariableDescriptor) {
            VariableManager varMgr = ((Session)this.getSession()).getVariableManager();
            return varMgr.createGlobalVariable((GlobalVariableDescriptor)varDesc);
        }
        return null;
    }

    public ICDIRegister createRegister(ICDIRegisterDescriptor varDesc) throws PCDIException {
        throw new PCDIException("Not implemented yet - Target: createRegister");
    }

    public IPProcess getPProcess() {
        return this.getDebugger().getProcess(this.task_id);
    }

    public int getTargetID() {
        return this.task_id;
    }

    public boolean isLittleEndian() throws PCDIException {
        PDebugUtils.println((String)"---- called isLittleEndian");
        return true;
    }

    public void deferBreakpoints(boolean defer) {
        this.deferBreakpoints = defer;
    }

    public boolean areBreakpointsDeferred() {
        return this.deferBreakpoints;
    }

    public class Lock {
        java.lang.Thread heldBy;
        int count;

        public synchronized void aquire() {
            if (this.heldBy == null || this.heldBy == java.lang.Thread.currentThread()) {
                this.heldBy = java.lang.Thread.currentThread();
                ++this.count;
            } else {
                do {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } while (this.heldBy != null);
                this.heldBy = java.lang.Thread.currentThread();
                ++this.count;
                return;
            }
        }

        public synchronized void release() {
            if (this.heldBy == null || this.heldBy != java.lang.Thread.currentThread()) {
                throw new IllegalStateException("Thread does not own lock");
            }
            if (--this.count == 0) {
                this.heldBy = null;
                this.notifyAll();
            }
        }
    }
}

